/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.carplay;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.mapkit.*;
import org.robovm.apple.coreanimation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 12.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("CarPlay") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CPNavigationSession/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class CPNavigationSessionPtr extends Ptr<CPNavigationSession, CPNavigationSessionPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(CPNavigationSession.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    protected CPNavigationSession() {}
    protected CPNavigationSession(Handle h, long handle) { super(h, handle); }
    protected CPNavigationSession(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "upcomingManeuvers")
    public native NSArray<CPManeuver> getUpcomingManeuvers();
    @Property(selector = "setUpcomingManeuvers:")
    public native void setUpcomingManeuvers(NSArray<CPManeuver> v);
    @Property(selector = "trip")
    public native CPTrip getTrip();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "pauseTripForReason:description:")
    public native void pauseTrip(CPTripPauseReason reason, String description);
    /**
     * @since Available in iOS 15.4 and later.
     */
    @Method(selector = "pauseTripForReason:description:turnCardColor:")
    public native void pauseTripForReason(CPTripPauseReason reason, String description, UIColor turnCardColor);
    @Method(selector = "finishTrip")
    public native void finishTrip();
    @Method(selector = "cancelTrip")
    public native void cancelTrip();
    @Method(selector = "updateTravelEstimates:forManeuver:")
    public native void updateTravelEstimates(CPTravelEstimates estimates, CPManeuver maneuver);
    /*</methods>*/
}
