/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.contacts;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 9.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("Contacts") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CNSocialProfile/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSSecureCoding/*</implements>*/ {

    /*<ptr>*/public static class CNSocialProfilePtr extends Ptr<CNSocialProfile, CNSocialProfilePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(CNSocialProfile.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public CNSocialProfile() {}
    protected CNSocialProfile(Handle h, long handle) { super(h, handle); }
    protected CNSocialProfile(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithUrlString:username:userIdentifier:service:")
    public CNSocialProfile(String urlString, String username, String userIdentifier, String service) { super((SkipInit) null); initObject(init(urlString, username, userIdentifier, service)); }
    @Method(selector = "initWithCoder:")
    public CNSocialProfile(NSCoder coder) { super((SkipInit) null); initObject(init(coder)); }
    /*</constructors>*/
    public CNSocialProfile(String urlString, String username, String userIdentifier, CNSocialProfileService service) {
        super((SkipInit) null);
        initObject(init(urlString, username, userIdentifier, service.value().toString()));
    }
    /*<properties>*/
    @Property(selector = "urlString")
    public native String getUrlString();
    @Property(selector = "username")
    public native String getUsername();
    @Property(selector = "userIdentifier")
    public native String getUserIdentifier();
    @Property(selector = "service")
    public native String getService();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    public static String getLocalizedService(CNSocialProfileService service) {
        return getLocalizedService(service.value().toString());
    }
    /*<methods>*/
    @Method(selector = "initWithUrlString:username:userIdentifier:service:")
    protected native @Pointer long init(String urlString, String username, String userIdentifier, String service);
    @Method(selector = "localizedStringForKey:")
    public static native String getLocalizedProperty(CNSocialProfilePropertyKey key);
    @Method(selector = "localizedStringForService:")
    public static native String getLocalizedService(String service);
    @Method(selector = "encodeWithCoder:")
    public native void encode(NSCoder coder);
    @Method(selector = "initWithCoder:")
    protected native @Pointer long init(NSCoder coder);
    /*</methods>*/
}
