/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.coremedia;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.dispatch.*;
import org.robovm.apple.coreaudio.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.corevideo.*;
import org.robovm.apple.audiotoolbox.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("CoreMedia") @StronglyLinked/*</annotations>*/
@Marshaler(/*<name>*/CMMetadataKeySpace/*</name>*/.Marshaler.class)
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CMMetadataKeySpace/*</name>*/ 
    extends /*<extends>*/GlobalValueEnumeration<CFString>/*</extends>*/
    /*<implements>*//*</implements>*/ {

    /*<marshalers>*/
    public static class Marshaler {
        @MarshalsPointer
        public static CMMetadataKeySpace toObject(Class<CMMetadataKeySpace> cls, long handle, long flags) {
            CFString o = (CFString) CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return CMMetadataKeySpace.valueOf(o);
        }
        @MarshalsPointer
        public static long toNative(CMMetadataKeySpace o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.value(), flags);
        }
    }
    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CMMetadataKeySpace> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray) CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            List<CMMetadataKeySpace> list = new ArrayList<>();
            for (int i = 0; i < o.size(); i++) {
                list.add(CMMetadataKeySpace.valueOf(o.get(i, CFString.class)));
            }
            return list;
        }
        @MarshalsPointer
        public static long toNative(List<CMMetadataKeySpace> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFArray array = CFMutableArray.create();
            for (CMMetadataKeySpace o : l) {
                array.add(o.value());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }
    /*</marshalers>*/

    /*<constants>*/
    public static final CMMetadataKeySpace QuickTimeUserData = new CMMetadataKeySpace("QuickTimeUserData");
    public static final CMMetadataKeySpace ISOUserData = new CMMetadataKeySpace("ISOUserData");
    public static final CMMetadataKeySpace QuickTimeMetadata = new CMMetadataKeySpace("QuickTimeMetadata");
    public static final CMMetadataKeySpace iTunes = new CMMetadataKeySpace("iTunes");
    public static final CMMetadataKeySpace ID3 = new CMMetadataKeySpace("ID3");
    public static final CMMetadataKeySpace Icy = new CMMetadataKeySpace("Icy");
    /**
     * @since Available in iOS 9.3 and later.
     */
    public static final CMMetadataKeySpace HLSDateRange = new CMMetadataKeySpace("HLSDateRange");
    /*</constants>*/
    
    private static /*<name>*/CMMetadataKeySpace/*</name>*/[] values = new /*<name>*/CMMetadataKeySpace/*</name>*/[] {/*<value_list>*/QuickTimeUserData, ISOUserData, QuickTimeMetadata, iTunes, ID3, Icy, HLSDateRange/*</value_list>*/};
    
    /*<name>*/CMMetadataKeySpace/*</name>*/ (String getterName) {
        super(Values.class, getterName);
    }
    
    public static /*<name>*/CMMetadataKeySpace/*</name>*/ valueOf(/*<type>*/CFString/*</type>*/ value) {
        for (/*<name>*/CMMetadataKeySpace/*</name>*/ v : values) {
            if (v.value().equals(value)) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " 
            + /*<name>*/CMMetadataKeySpace/*</name>*/.class.getName());
    }
    
    /*<methods>*//*</methods>*/
    
    /*<annotations>*/@Library("CoreMedia") @StronglyLinked/*</annotations>*/
    public static class Values {
    	static { Bro.bind(Values.class); }

        /*<values>*/
        @GlobalValue(symbol="kCMMetadataKeySpace_QuickTimeUserData", optional=true)
        public static native CFString QuickTimeUserData();
        @GlobalValue(symbol="kCMMetadataKeySpace_ISOUserData", optional=true)
        public static native CFString ISOUserData();
        @GlobalValue(symbol="kCMMetadataKeySpace_QuickTimeMetadata", optional=true)
        public static native CFString QuickTimeMetadata();
        @GlobalValue(symbol="kCMMetadataKeySpace_iTunes", optional=true)
        public static native CFString iTunes();
        @GlobalValue(symbol="kCMMetadataKeySpace_ID3", optional=true)
        public static native CFString ID3();
        @GlobalValue(symbol="kCMMetadataKeySpace_Icy", optional=true)
        public static native CFString Icy();
        /**
         * @since Available in iOS 9.3 and later.
         */
        @GlobalValue(symbol="kCMMetadataKeySpace_HLSDateRange", optional=true)
        public static native CFString HLSDateRange();
        /*</values>*/
    }
}
