/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.coremidi;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("CoreMIDI")/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/MIDIEventList/*</name>*/ 
    extends /*<extends>*/Struct<MIDIEventList>/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class MIDIEventListPtr extends Ptr<MIDIEventList, MIDIEventListPtr> {}/*</ptr>*/
    /*<bind>*/static { Bro.bind(MIDIEventList.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public MIDIEventList() {}
    public MIDIEventList(MIDIProtocolID protocol, int numPackets) {
        this.setProtocol(protocol);
        this.setNumPackets(numPackets);
    }
    /*</constructors>*/
    /*<properties>*//*</properties>*/
    /*<members>*/
    @StructMember(0) public native MIDIProtocolID getProtocol();
    @StructMember(0) public native MIDIEventList setProtocol(MIDIProtocolID protocol);
    @StructMember(1) public native int getNumPackets();
    @StructMember(1) public native MIDIEventList setNumPackets(int numPackets);
    @StructMember(2) public native @Array({1}) MIDIEventPacket getPacket();
    /*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 15.0 and later.
     */
    @Bridge(symbol="MIDIEventListForEachEvent", optional=true)
    public native void forEachEvent(FunctionPtr visitor, VoidPtr visitorContext);
    /*</methods>*/
}
