/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.coretelephony;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 9.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("CoreTelephony") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CTCellularData/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class CTCellularDataPtr extends Ptr<CTCellularData, CTCellularDataPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(CTCellularData.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public CTCellularData() {}
    protected CTCellularData(Handle h, long handle) { super(h, handle); }
    protected CTCellularData(SkipInit skipInit) { super(skipInit); }
    /*</constructors>*/
    /*<properties>*/
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "cellularDataRestrictionDidUpdateNotifier")
    public native @Block VoidBlock1<CTCellularDataRestrictedState> getCellularDataRestrictionDidUpdateNotifier();
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "setCellularDataRestrictionDidUpdateNotifier:")
    public native void setCellularDataRestrictionDidUpdateNotifier(@Block VoidBlock1<CTCellularDataRestrictedState> v);
    /**
     * @since Available in iOS 9.0 and later.
     */
    @Property(selector = "restrictedState")
    public native CTCellularDataRestrictedState getRestrictedState();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
