/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.coretext;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coremedia.*;
import org.robovm.apple.uikit.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("CoreText")/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/CoreTextVersionNumber/*</name>*/ 
    extends /*<extends>*/CocoaUtility/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/
    /*</ptr>*/
    /*<bind>*/static { Bro.bind(CoreTextVersionNumber.class); }/*</bind>*/
    /*<constants>*/
    public static final int Version10_5 = 0x00020000;
    public static final int Version10_5_2 = 0x00020001;
    public static final int Version10_5_3 = 0x00020002;
    public static final int Version10_5_5 = 0x00020003;
    public static final int Version10_6 = 0x00030000;
    public static final int Version10_7 = 0x00040000;
    public static final int Version10_8 = 0x00050000;
    public static final int Version10_9 = 0x00060000;
    public static final int Version10_10 = 0x00070000;
    public static final int Version10_11 = 0x00080000;
    public static final int Version10_12 = 0x00090000;
    public static final int Version10_13 = 0x000A0000;
    public static final int Version10_14 = 0x000B0000;
    public static final int Version10_15 = 0x000C0000;
    public static final int Version11_0 = 0x000D0000;
    /*</constants>*/
    /*<constructors>*//*</constructors>*/
    /*<properties>*//*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @deprecated Deprecated in iOS 14.0. Use -[NSProcessInfo operatingSystemVersion]
     */
    @Deprecated
    @Bridge(symbol="CTGetCoreTextVersion", optional=true)
    public static native int getVersion();
    /*</methods>*/
}
