/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.cryptotokenkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.security.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Marshaler(Bits.AsMachineSizedIntMarshaler.class)/*</annotations>*/
public final class /*<name>*/TKSmartCardProtocol/*</name>*/ extends Bits</*<name>*/TKSmartCardProtocol/*</name>*/> {
    /*<values>*/
    public static final TKSmartCardProtocol None = new TKSmartCardProtocol(0L);
    public static final TKSmartCardProtocol T0 = new TKSmartCardProtocol(1L);
    public static final TKSmartCardProtocol T1 = new TKSmartCardProtocol(2L);
    public static final TKSmartCardProtocol T15 = new TKSmartCardProtocol(32768L);
    public static final TKSmartCardProtocol Any = new TKSmartCardProtocol(65535L);
    /*</values>*/

    /*<bind>*/
    /*</bind>*/
    /*<constants>*//*</constants>*/
    /*<methods>*//*</methods>*/

    private static final /*<name>*/TKSmartCardProtocol/*</name>*/[] values = _values(/*<name>*/TKSmartCardProtocol/*</name>*/.class);

    public /*<name>*/TKSmartCardProtocol/*</name>*/(long value) { super(value); }
    private /*<name>*/TKSmartCardProtocol/*</name>*/(long value, long mask) { super(value, mask); }
    protected /*<name>*/TKSmartCardProtocol/*</name>*/ wrap(long value, long mask) {
        return new /*<name>*/TKSmartCardProtocol/*</name>*/(value, mask);
    }
    protected /*<name>*/TKSmartCardProtocol/*</name>*/[] _values() {
        return values;
    }
    public static /*<name>*/TKSmartCardProtocol/*</name>*/[] values() {
        return values.clone();
    }
}
