/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.foundation;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coretext.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.coredata.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coremedia.*;
import org.robovm.apple.security.*;
import org.robovm.apple.dispatch.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("Foundation") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/NSIndexPath/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSSecureCoding/*</implements>*/ {

    /*<ptr>*/public static class NSIndexPathPtr extends Ptr<NSIndexPath, NSIndexPathPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(NSIndexPath.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public NSIndexPath() {}
    protected NSIndexPath(Handle h, long handle) { super(h, handle); }
    protected NSIndexPath(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithIndex:")
    public NSIndexPath(@MachineSizedUInt long index) { super((SkipInit) null); initObject(init(index)); }
    @Method(selector = "initWithCoder:")
    public NSIndexPath(NSCoder coder) { super((SkipInit) null); initObject(init(coder)); }
    /*</constructors>*/
    
    public NSIndexPath(long[] indexes) {
        super((SkipInit) null);
        if (indexes == null) {
            throw new NullPointerException("indexes");
        }
        MachineSizedUIntPtr p = Struct.allocate(MachineSizedUIntPtr.class, indexes.length);
        p.set(indexes);
        initObject(init(p, indexes.length));
    }
    
    /*<properties>*/
    @Property(selector = "length")
    public native @MachineSizedUInt long getLength();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    
    public int[] getIndexes() {
        int n = (int) getLength();
        MachineSizedUIntPtr p = Struct.allocate(MachineSizedUIntPtr.class, n);
        getIndexes(p);
        return p.toIntArray(n);
    }
    /**
    * @since Available in iOS 7.0 and later.
    */
    public int[] getIndexes(NSRange positionRange) {
        int n = (int) getLength();
        MachineSizedUIntPtr p = Struct.allocate(MachineSizedUIntPtr.class, (int)positionRange.getLength());
        getIndexes(p, positionRange);
        return p.toIntArray(n);
    }
    
    
    /* UIKit extensions */
    @WeaklyLinked
    public int getSection() {
        return (int) NSIndexPathExtensions.getSection(this);
    }
    @WeaklyLinked
    public int getRow() {
        return (int) NSIndexPathExtensions.getRow(this);
    }
    /**
     * @since Available in iOS 6.0 and later.
     */
    @WeaklyLinked
    public int getItem() {
        return (int) NSIndexPathExtensions.getItem(this);
    }
    @WeaklyLinked
    public static NSIndexPath row(@MachineSizedSInt long row, @MachineSizedSInt long section) {
        return NSIndexPathExtensions.createIndexPathForRowInSection(row, section);
    }
    /**
     * @since Available in iOS 6.0 and later.
     */
    @WeaklyLinked
    public static NSIndexPath item(@MachineSizedSInt long item, @MachineSizedSInt long section) {
        return NSIndexPathExtensions.createIndexPathForItemInSection(item, section);
    }
    
    /*<methods>*/
    @Method(selector = "initWithIndexes:length:")
    private native @Pointer long init(MachineSizedUIntPtr indexes, @MachineSizedUInt long length);
    @Method(selector = "initWithIndex:")
    protected native @Pointer long init(@MachineSizedUInt long index);
    @Method(selector = "indexPathByAddingIndex:")
    public native NSIndexPath addIndex(@MachineSizedUInt long index);
    @Method(selector = "indexPathByRemovingLastIndex")
    public native NSIndexPath removeLastIndex();
    @Method(selector = "indexAtPosition:")
    public native @MachineSizedUInt long getIndexAt(@MachineSizedUInt long position);
    @Method(selector = "getIndexes:range:")
    private native void getIndexes(MachineSizedUIntPtr indexes, @ByVal NSRange positionRange);
    @Method(selector = "compare:")
    public native NSComparisonResult compare(NSIndexPath otherObject);
    /**
     * @deprecated Use getIndexes:range:
     */
    @Deprecated
    @Method(selector = "getIndexes:")
    private native void getIndexes(MachineSizedUIntPtr indexes);
    @Method(selector = "encodeWithCoder:")
    public native void encode(NSCoder coder);
    @Method(selector = "initWithCoder:")
    protected native @Pointer long init(NSCoder coder);
    /*</methods>*/
}
