/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.healthkit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 13.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("HealthKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/HKHeartbeatSeriesQuery/*</name>*/ 
    extends /*<extends>*/HKQuery/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class HKHeartbeatSeriesQueryPtr extends Ptr<HKHeartbeatSeriesQuery, HKHeartbeatSeriesQueryPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(HKHeartbeatSeriesQuery.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    protected HKHeartbeatSeriesQuery() {}
    protected HKHeartbeatSeriesQuery(Handle h, long handle) { super(h, handle); }
    protected HKHeartbeatSeriesQuery(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithHeartbeatSeries:dataHandler:")
    public HKHeartbeatSeriesQuery(HKHeartbeatSeriesSample heartbeatSeries, @Block VoidBlock5<HKHeartbeatSeriesQuery, Double, Boolean, Boolean, NSError> dataHandler) { super((SkipInit) null); initObject(init(heartbeatSeries, dataHandler)); }
    /*</constructors>*/
    /*<properties>*/
    
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "initWithHeartbeatSeries:dataHandler:")
    protected native @Pointer long init(HKHeartbeatSeriesSample heartbeatSeries, @Block VoidBlock5<HKHeartbeatSeriesQuery, Double, Boolean, Boolean, NSError> dataHandler);
    /*</methods>*/
}
