/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.intents;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.eventkit.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.coregraphics.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 12.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("Intents") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/INMediaItem/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSSecureCoding/*</implements>*/ {

    /*<ptr>*/public static class INMediaItemPtr extends Ptr<INMediaItem, INMediaItemPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(INMediaItem.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    protected INMediaItem() {}
    protected INMediaItem(Handle h, long handle) { super(h, handle); }
    protected INMediaItem(SkipInit skipInit) { super(skipInit); }
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Method(selector = "initWithIdentifier:title:type:artwork:artist:")
    public INMediaItem(String identifier, String title, INMediaItemType type, INImage artwork, String artist) { super((SkipInit) null); initObject(init(identifier, title, type, artwork, artist)); }
    @Method(selector = "initWithIdentifier:title:type:artwork:")
    public INMediaItem(String identifier, String title, INMediaItemType type, INImage artwork) { super((SkipInit) null); initObject(init(identifier, title, type, artwork)); }
    @Method(selector = "initWithCoder:")
    public INMediaItem(NSCoder coder) { super((SkipInit) null); initObject(init(coder)); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "identifier")
    public native String getIdentifier();
    @Property(selector = "title")
    public native String getTitle();
    @Property(selector = "type")
    public native INMediaItemType getType();
    @Property(selector = "artwork")
    public native INImage getArtwork();
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Property(selector = "artist")
    public native String getArtist();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 13.0 and later.
     */
    @Method(selector = "initWithIdentifier:title:type:artwork:artist:")
    protected native @Pointer long init(String identifier, String title, INMediaItemType type, INImage artwork, String artist);
    @Method(selector = "initWithIdentifier:title:type:artwork:")
    protected native @Pointer long init(String identifier, String title, INMediaItemType type, INImage artwork);
    @Method(selector = "encodeWithCoder:")
    public native void encode(NSCoder coder);
    @Method(selector = "initWithCoder:")
    protected native @Pointer long init(NSCoder coder);
    /*</methods>*/
}
