/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.intents;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.eventkit.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.coregraphics.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 10.0 and later.
 * @deprecated Deprecated in iOS 15.0. INSetRadioStationIntent is deprecated. There is no replacement.
 */
/*</javadoc>*/
/*<annotations>*/@Library("Intents") @NativeClass @Deprecated/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/INSetRadioStationIntent/*</name>*/ 
    extends /*<extends>*/INIntent/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class INSetRadioStationIntentPtr extends Ptr<INSetRadioStationIntent, INSetRadioStationIntentPtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(INSetRadioStationIntent.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public INSetRadioStationIntent() {}
    protected INSetRadioStationIntent(Handle h, long handle) { super(h, handle); }
    protected INSetRadioStationIntent(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithRadioType:frequency:stationName:channel:presetNumber:")
    public INSetRadioStationIntent(INRadioType radioType, NSNumber frequency, String stationName, String channel, NSNumber presetNumber) { super((SkipInit) null); initObject(init(radioType, frequency, stationName, channel, presetNumber)); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "radioType")
    public native INRadioType getRadioType();
    @Property(selector = "frequency")
    public native NSNumber getFrequency();
    @Property(selector = "stationName")
    public native String getStationName();
    @Property(selector = "channel")
    public native String getChannel();
    @Property(selector = "presetNumber")
    public native NSNumber getPresetNumber();
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "initWithRadioType:frequency:stationName:channel:presetNumber:")
    protected native @Pointer long init(INRadioType radioType, NSNumber frequency, String stationName, String channel, NSNumber presetNumber);
    /*</methods>*/
}
