/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.metal;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.dispatch.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Library("Metal") @NativeProtocolProxy/*</annotations>*/
/*<visibility>*/public final/*</visibility>*/ class /*<name>*/MTLCommandQueue/*</name>*/ 
    extends /*<extends>*/NSObject/*</extends>*/ 
    /*<implements>*/implements NSObjectProtocol/*</implements>*/ {

    /*<ptr>*/public static class MTLCommandQueuePtr extends Ptr<MTLCommandQueue, MTLCommandQueuePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(MTLCommandQueue.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "label")
    public native String getLabel();
    @Property(selector = "setLabel:")
    public native void setLabel(String v);
    @Property(selector = "device")
    public native MTLDevice getDevice();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    @Method(selector = "commandBuffer")
    public native MTLCommandBuffer getCommandBuffer();
    /**
     * @since Available in iOS 14.0 and later.
     */
    @Method(selector = "commandBufferWithDescriptor:")
    public native MTLCommandBuffer commandBuffer(MTLCommandBufferDescriptor descriptor);
    @Method(selector = "commandBufferWithUnretainedReferences")
    public native MTLCommandBuffer getCommandBufferWithUnretainedReferences();
    /**
     * @deprecated Deprecated in iOS 11.0. Use MTLCaptureScope instead
     */
    @Deprecated
    @Method(selector = "insertDebugCaptureBoundary")
    public native void insertDebugCaptureBoundary();
    /*</methods>*/
}
