/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.scenekit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.uikit.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.dispatch.*;
import org.robovm.apple.glkit.*;
import org.robovm.apple.spritekit.*;
import org.robovm.apple.opengles.*;
import org.robovm.apple.metal.*;
import org.robovm.apple.avfoundation.*;
/*</imports>*/

/*<javadoc>*/
/*</javadoc>*/
/*<annotations>*/@Library("SceneKit") @StronglyLinked/*</annotations>*/
@Marshaler(/*<name>*/SCNLightingModel/*</name>*/.Marshaler.class)
/*<visibility>*/public/*</visibility>*/ class /*<name>*/SCNLightingModel/*</name>*/ 
    extends /*<extends>*/GlobalValueEnumeration<NSString>/*</extends>*/
    /*<implements>*//*</implements>*/ {

    static { Bro.bind(/*<name>*/SCNLightingModel/*</name>*/.class); }

    /*<marshalers>*/
    public static class Marshaler {
        @MarshalsPointer
        public static SCNLightingModel toObject(Class<SCNLightingModel> cls, long handle, long flags) {
            NSString o = (NSString) NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return SCNLightingModel.valueOf(o);
        }
        @MarshalsPointer
        public static long toNative(SCNLightingModel o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
    public static class AsListMarshaler {
        @SuppressWarnings("unchecked")
        @MarshalsPointer
        public static List<SCNLightingModel> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray<NSString> o = (NSArray<NSString>) NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            List<SCNLightingModel> list = new ArrayList<>();
            for (int i = 0; i < o.size(); i++) {
                list.add(SCNLightingModel.valueOf(o.get(i)));
            }
            return list;
        }
        @MarshalsPointer
        public static long toNative(List<SCNLightingModel> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSArray<NSString> array = new NSMutableArray<>();
            for (SCNLightingModel o : l) {
                array.add(o.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }
    /*</marshalers>*/

    /*<constants>*/
    public static final SCNLightingModel Phong = new SCNLightingModel("Phong");
    public static final SCNLightingModel Blinn = new SCNLightingModel("Blinn");
    public static final SCNLightingModel Lambert = new SCNLightingModel("Lambert");
    public static final SCNLightingModel Constant = new SCNLightingModel("Constant");
    /**
     * @since Available in iOS 10.0 and later.
     */
    public static final SCNLightingModel PhysicallyBased = new SCNLightingModel("PhysicallyBased");
    /**
     * @since Available in iOS 13.0 and later.
     */
    public static final SCNLightingModel ShadowOnly = new SCNLightingModel("ShadowOnly");
    /*</constants>*/
    
    private static /*<name>*/SCNLightingModel/*</name>*/[] values = new /*<name>*/SCNLightingModel/*</name>*/[] {/*<value_list>*/Phong, Blinn, Lambert, Constant, PhysicallyBased, ShadowOnly/*</value_list>*/};
    
    /*<name>*/SCNLightingModel/*</name>*/ (String getterName) {
        super(Values.class, getterName);
    }
    
    public static /*<name>*/SCNLightingModel/*</name>*/ valueOf(/*<type>*/NSString/*</type>*/ value) {
        for (/*<name>*/SCNLightingModel/*</name>*/ v : values) {
            if (v.value().equals(value)) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " 
            + /*<name>*/SCNLightingModel/*</name>*/.class.getName());
    }
    
    /*<methods>*//*</methods>*/
    
    /*<annotations>*/@Library("SceneKit") @StronglyLinked/*</annotations>*/
    public static class Values {
    	static { Bro.bind(Values.class); }

        /*<values>*/
        @GlobalValue(symbol="SCNLightingModelPhong", optional=true)
        public static native NSString Phong();
        @GlobalValue(symbol="SCNLightingModelBlinn", optional=true)
        public static native NSString Blinn();
        @GlobalValue(symbol="SCNLightingModelLambert", optional=true)
        public static native NSString Lambert();
        @GlobalValue(symbol="SCNLightingModelConstant", optional=true)
        public static native NSString Constant();
        /**
         * @since Available in iOS 10.0 and later.
         */
        @GlobalValue(symbol="SCNLightingModelPhysicallyBased", optional=true)
        public static native NSString PhysicallyBased();
        /**
         * @since Available in iOS 13.0 and later.
         */
        @GlobalValue(symbol="SCNLightingModelShadowOnly", optional=true)
        public static native NSString ShadowOnly();
        /*</values>*/
    }
}
