/*
 * Copyright (C) 2013-2015 RoboVM AB
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.security;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.corefoundation.*;
import org.robovm.apple.dispatch.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Marshaler(ValuedEnum.AsUnsignedShortMarshaler.class)/*</annotations>*/
public enum /*<name>*/SSLCipherSuite/*</name>*/ implements ValuedEnum {
    /*<values>*/
    SSL_NULL_WITH_NULL_NULL(0L),
    SSL_RSA_WITH_NULL_MD5(1L),
    SSL_RSA_WITH_NULL_SHA(2L),
    SSL_RSA_EXPORT_WITH_RC4_40_MD5(3L),
    SSL_RSA_WITH_RC4_128_MD5(4L),
    SSL_RSA_WITH_RC4_128_SHA(5L),
    SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5(6L),
    SSL_RSA_WITH_IDEA_CBC_SHA(7L),
    SSL_RSA_EXPORT_WITH_DES40_CBC_SHA(8L),
    SSL_RSA_WITH_DES_CBC_SHA(9L),
    SSL_RSA_WITH_3DES_EDE_CBC_SHA(10L),
    SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA(11L),
    SSL_DH_DSS_WITH_DES_CBC_SHA(12L),
    SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA(13L),
    SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA(14L),
    SSL_DH_RSA_WITH_DES_CBC_SHA(15L),
    SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA(16L),
    SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA(17L),
    SSL_DHE_DSS_WITH_DES_CBC_SHA(18L),
    SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA(19L),
    SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA(20L),
    SSL_DHE_RSA_WITH_DES_CBC_SHA(21L),
    SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA(22L),
    SSL_DH_anon_EXPORT_WITH_RC4_40_MD5(23L),
    SSL_DH_anon_WITH_RC4_128_MD5(24L),
    SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA(25L),
    SSL_DH_anon_WITH_DES_CBC_SHA(26L),
    SSL_DH_anon_WITH_3DES_EDE_CBC_SHA(27L),
    SSL_FORTEZZA_DMS_WITH_NULL_SHA(28L),
    SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA(29L),
    TLS_RSA_WITH_AES_128_CBC_SHA(47L),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA(48L),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA(49L),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA(50L),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA(51L),
    TLS_DH_anon_WITH_AES_128_CBC_SHA(52L),
    TLS_RSA_WITH_AES_256_CBC_SHA(53L),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA(54L),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA(55L),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA(56L),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA(57L),
    TLS_DH_anon_WITH_AES_256_CBC_SHA(58L),
    TLS_ECDH_ECDSA_WITH_NULL_SHA(49153L),
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA(49154L),
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA(49155L),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA(49156L),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA(49157L),
    TLS_ECDHE_ECDSA_WITH_NULL_SHA(49158L),
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA(49159L),
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA(49160L),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA(49161L),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162L),
    TLS_ECDH_RSA_WITH_NULL_SHA(49163L),
    TLS_ECDH_RSA_WITH_RC4_128_SHA(49164L),
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA(49165L),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA(49166L),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA(49167L),
    TLS_ECDHE_RSA_WITH_NULL_SHA(49168L),
    TLS_ECDHE_RSA_WITH_RC4_128_SHA(49169L),
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA(49170L),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA(49171L),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(49172L),
    TLS_ECDH_anon_WITH_NULL_SHA(49173L),
    TLS_ECDH_anon_WITH_RC4_128_SHA(49174L),
    TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA(49175L),
    TLS_ECDH_anon_WITH_AES_128_CBC_SHA(49176L),
    TLS_ECDH_anon_WITH_AES_256_CBC_SHA(49177L),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA(49205L),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA(49206L),
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256(52395L),
    TLS_NULL_WITH_NULL_NULL(0L),
    TLS_RSA_WITH_NULL_MD5(1L),
    TLS_RSA_WITH_NULL_SHA(2L),
    TLS_RSA_WITH_RC4_128_MD5(4L),
    TLS_RSA_WITH_RC4_128_SHA(5L),
    TLS_RSA_WITH_3DES_EDE_CBC_SHA(10L),
    TLS_RSA_WITH_NULL_SHA256(59L),
    TLS_RSA_WITH_AES_128_CBC_SHA256(60L),
    TLS_RSA_WITH_AES_256_CBC_SHA256(61L),
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA(13L),
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA(16L),
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA(19L),
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA(22L),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA256(62L),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA256(63L),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256(64L),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256(103L),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA256(104L),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA256(105L),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256(106L),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256(107L),
    TLS_DH_anon_WITH_RC4_128_MD5(24L),
    TLS_DH_anon_WITH_3DES_EDE_CBC_SHA(27L),
    TLS_DH_anon_WITH_AES_128_CBC_SHA256(108L),
    TLS_DH_anon_WITH_AES_256_CBC_SHA256(109L),
    TLS_PSK_WITH_RC4_128_SHA(138L),
    TLS_PSK_WITH_3DES_EDE_CBC_SHA(139L),
    TLS_PSK_WITH_AES_128_CBC_SHA(140L),
    TLS_PSK_WITH_AES_256_CBC_SHA(141L),
    TLS_DHE_PSK_WITH_RC4_128_SHA(142L),
    TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA(143L),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA(144L),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA(145L),
    TLS_RSA_PSK_WITH_RC4_128_SHA(146L),
    TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA(147L),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA(148L),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA(149L),
    TLS_PSK_WITH_NULL_SHA(44L),
    TLS_DHE_PSK_WITH_NULL_SHA(45L),
    TLS_RSA_PSK_WITH_NULL_SHA(46L),
    TLS_RSA_WITH_AES_128_GCM_SHA256(156L),
    TLS_RSA_WITH_AES_256_GCM_SHA384(157L),
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256(158L),
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384(159L),
    TLS_DH_RSA_WITH_AES_128_GCM_SHA256(160L),
    TLS_DH_RSA_WITH_AES_256_GCM_SHA384(161L),
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256(162L),
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384(163L),
    TLS_DH_DSS_WITH_AES_128_GCM_SHA256(164L),
    TLS_DH_DSS_WITH_AES_256_GCM_SHA384(165L),
    TLS_DH_anon_WITH_AES_128_GCM_SHA256(166L),
    TLS_DH_anon_WITH_AES_256_GCM_SHA384(167L),
    TLS_PSK_WITH_AES_128_GCM_SHA256(168L),
    TLS_PSK_WITH_AES_256_GCM_SHA384(169L),
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256(170L),
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384(171L),
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256(172L),
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384(173L),
    TLS_PSK_WITH_AES_128_CBC_SHA256(174L),
    TLS_PSK_WITH_AES_256_CBC_SHA384(175L),
    TLS_PSK_WITH_NULL_SHA256(176L),
    TLS_PSK_WITH_NULL_SHA384(177L),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256(178L),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384(179L),
    TLS_DHE_PSK_WITH_NULL_SHA256(180L),
    TLS_DHE_PSK_WITH_NULL_SHA384(181L),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256(182L),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384(183L),
    TLS_RSA_PSK_WITH_NULL_SHA256(184L),
    TLS_RSA_PSK_WITH_NULL_SHA384(185L),
    TLS_AES_128_GCM_SHA256(4865L),
    TLS_AES_256_GCM_SHA384(4866L),
    TLS_CHACHA20_POLY1305_SHA256(4867L),
    TLS_AES_128_CCM_SHA256(4868L),
    TLS_AES_128_CCM_8_SHA256(4869L),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187L),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(49188L),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256(49189L),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384(49190L),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256(49191L),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384(49192L),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256(49193L),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384(49194L),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195L),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(49196L),
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256(49197L),
    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384(49198L),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(49199L),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(49200L),
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256(49201L),
    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384(49202L),
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52392L),
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52393L),
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV(255L),
    SSL_RSA_WITH_RC2_CBC_MD5(65408L),
    SSL_RSA_WITH_IDEA_CBC_MD5(65409L),
    SSL_RSA_WITH_DES_CBC_MD5(65410L),
    SSL_RSA_WITH_3DES_EDE_CBC_MD5(65411L),
    SSL_NO_SUCH_CIPHERSUITE(65535L);
    /*</values>*/

    private final long n;

    private /*<name>*/SSLCipherSuite/*</name>*/(long n) { this.n = n; }
    public long value() { return n; }
    public static /*<name>*/SSLCipherSuite/*</name>*/ valueOf(long n) {
        for (/*<name>*/SSLCipherSuite/*</name>*/ v : values()) {
            if (v.n == n) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " 
            + /*<name>*/SSLCipherSuite/*</name>*/.class.getName());
    }
}
