/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.uikit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coredata.*;
import org.robovm.apple.coreimage.*;
import org.robovm.apple.coretext.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.cloudkit.*;
import org.robovm.apple.fileprovider.*;
import org.robovm.apple.intents.*;
import org.robovm.apple.usernotifications.*;
import org.robovm.apple.linkpresentation.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Marshaler(Bits.AsMachineSizedIntMarshaler.class)/*</annotations>*/
public final class /*<name>*/NSGlyphProperty/*</name>*/ extends Bits</*<name>*/NSGlyphProperty/*</name>*/> {
    /*<values>*/
    public static final NSGlyphProperty None = new NSGlyphProperty(0L);
    public static final NSGlyphProperty Null = new NSGlyphProperty(1L);
    public static final NSGlyphProperty ControlCharacter = new NSGlyphProperty(2L);
    public static final NSGlyphProperty Elastic = new NSGlyphProperty(4L);
    public static final NSGlyphProperty NonBaseCharacter = new NSGlyphProperty(8L);
    /*</values>*/

    /*<bind>*/
    /*</bind>*/
    /*<constants>*//*</constants>*/
    /*<methods>*//*</methods>*/

    private static final /*<name>*/NSGlyphProperty/*</name>*/[] values = _values(/*<name>*/NSGlyphProperty/*</name>*/.class);

    public /*<name>*/NSGlyphProperty/*</name>*/(long value) { super(value); }
    private /*<name>*/NSGlyphProperty/*</name>*/(long value, long mask) { super(value, mask); }
    protected /*<name>*/NSGlyphProperty/*</name>*/ wrap(long value, long mask) {
        return new /*<name>*/NSGlyphProperty/*</name>*/(value, mask);
    }
    protected /*<name>*/NSGlyphProperty/*</name>*/[] _values() {
        return values;
    }
    public static /*<name>*/NSGlyphProperty/*</name>*/[] values() {
        return values.clone();
    }
}
