/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.uikit;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coreanimation.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coredata.*;
import org.robovm.apple.coreimage.*;
import org.robovm.apple.coretext.*;
import org.robovm.apple.corelocation.*;
import org.robovm.apple.cloudkit.*;
import org.robovm.apple.fileprovider.*;
import org.robovm.apple.intents.*;
import org.robovm.apple.usernotifications.*;
import org.robovm.apple.linkpresentation.*;
/*</imports>*/

/*<javadoc>*/
/**
 * @since Available in iOS 13.0 and later.
 */
/*</javadoc>*/
/*<annotations>*/@Library("UIKit") @NativeClass/*</annotations>*/
/*<visibility>*/public/*</visibility>*/ class /*<name>*/UITabBarAppearance/*</name>*/ 
    extends /*<extends>*/UIBarAppearance/*</extends>*/ 
    /*<implements>*//*</implements>*/ {

    /*<ptr>*/public static class UITabBarAppearancePtr extends Ptr<UITabBarAppearance, UITabBarAppearancePtr> {}/*</ptr>*/
    /*<bind>*/static { ObjCRuntime.bind(UITabBarAppearance.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<constructors>*/
    public UITabBarAppearance() {}
    protected UITabBarAppearance(Handle h, long handle) { super(h, handle); }
    protected UITabBarAppearance(SkipInit skipInit) { super(skipInit); }
    @Method(selector = "initWithIdiom:")
    public UITabBarAppearance(UIUserInterfaceIdiom idiom) { super(idiom); }
    @Method(selector = "initWithBarAppearance:")
    public UITabBarAppearance(UIBarAppearance barAppearance) { super(barAppearance); }
    @Method(selector = "initWithCoder:")
    public UITabBarAppearance(NSCoder coder) { super(coder); }
    /*</constructors>*/
    /*<properties>*/
    @Property(selector = "stackedLayoutAppearance")
    public native UITabBarItemAppearance getStackedLayoutAppearance();
    @Property(selector = "setStackedLayoutAppearance:")
    public native void setStackedLayoutAppearance(UITabBarItemAppearance v);
    @Property(selector = "inlineLayoutAppearance")
    public native UITabBarItemAppearance getInlineLayoutAppearance();
    @Property(selector = "setInlineLayoutAppearance:")
    public native void setInlineLayoutAppearance(UITabBarItemAppearance v);
    @Property(selector = "compactInlineLayoutAppearance")
    public native UITabBarItemAppearance getCompactInlineLayoutAppearance();
    @Property(selector = "setCompactInlineLayoutAppearance:")
    public native void setCompactInlineLayoutAppearance(UITabBarItemAppearance v);
    @Property(selector = "selectionIndicatorTintColor")
    public native UIColor getSelectionIndicatorTintColor();
    @Property(selector = "setSelectionIndicatorTintColor:")
    public native void setSelectionIndicatorTintColor(UIColor v);
    @Property(selector = "selectionIndicatorImage")
    public native UIImage getSelectionIndicatorImage();
    @Property(selector = "setSelectionIndicatorImage:")
    public native void setSelectionIndicatorImage(UIImage v);
    @Property(selector = "stackedItemPositioning")
    public native UITabBarItemPositioning getStackedItemPositioning();
    @Property(selector = "setStackedItemPositioning:")
    public native void setStackedItemPositioning(UITabBarItemPositioning v);
    @Property(selector = "stackedItemWidth")
    public native @MachineSizedFloat double getStackedItemWidth();
    @Property(selector = "setStackedItemWidth:")
    public native void setStackedItemWidth(@MachineSizedFloat double v);
    @Property(selector = "stackedItemSpacing")
    public native @MachineSizedFloat double getStackedItemSpacing();
    @Property(selector = "setStackedItemSpacing:")
    public native void setStackedItemSpacing(@MachineSizedFloat double v);
    @Property(selector = "supportsSecureCoding")
    public static native boolean supportsSecureCoding();
    /*</properties>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    
    /*</methods>*/
}
