/*
 * Copyright (C) 2013-2015 RoboVM AB
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.robovm.apple.vision;

/*<imports>*/
import java.io.*;
import java.nio.*;
import java.util.*;
import org.robovm.objc.*;
import org.robovm.objc.annotation.*;
import org.robovm.objc.block.*;
import org.robovm.rt.*;
import org.robovm.rt.annotation.*;
import org.robovm.rt.bro.*;
import org.robovm.rt.bro.annotation.*;
import org.robovm.rt.bro.ptr.*;
import org.robovm.apple.foundation.*;
import org.robovm.apple.coreml.*;
import org.robovm.apple.coregraphics.*;
import org.robovm.apple.coremedia.*;
import org.robovm.apple.corevideo.*;
import org.robovm.apple.metal.*;
import org.robovm.apple.coreimage.*;
import org.robovm.apple.imageio.*;
/*</imports>*/

/*<javadoc>*/

/*</javadoc>*/
/*<annotations>*/@Marshaler(ValuedEnum.AsMachineSizedSIntMarshaler.class) @Library("Vision")/*</annotations>*/
public enum /*<name>*/VNErrorCode/*</name>*/ implements NSErrorCode {
    /*<values>*/
    OK(0L),
    RequestCancelled(1L),
    InvalidFormat(2L),
    OperationFailed(3L),
    OutOfBoundsError(4L),
    InvalidOption(5L),
    IOError(6L),
    MissingOption(7L),
    NotImplemented(8L),
    InternalError(9L),
    OutOfMemory(10L),
    UnknownError(11L),
    InvalidOperation(12L),
    InvalidImage(13L),
    InvalidArgument(14L),
    InvalidModel(15L),
    /**
     * @since Available in iOS 12.0 and later.
     */
    UnsupportedRevision(16L),
    /**
     * @since Available in iOS 13.0 and later.
     */
    DataUnavailable(17L),
    /**
     * @since Available in iOS 14.0 and later.
     */
    TimeStampNotFound(18L),
    /**
     * @since Available in iOS 15.0 and later.
     */
    UnsupportedRequest(19L);
    /*</values>*/

    /*<bind>*/static { Bro.bind(VNErrorCode.class); }/*</bind>*/
    /*<constants>*//*</constants>*/
    /*<members>*//*</members>*/
    /*<methods>*/
    /**
     * @since Available in iOS 11.0 and later.
     */
    @GlobalValue(symbol="VNErrorDomain", optional=true)
    public static native String getClassDomain();
    /*</methods>*/

    private final long n;

    private /*<name>*/VNErrorCode/*</name>*/(long n) { this.n = n; }
    public long value() { return n; }
    public static /*<name>*/VNErrorCode/*</name>*/ valueOf(long n) {
        for (/*<name>*/VNErrorCode/*</name>*/ v : values()) {
            if (v.n == n) {
                return v;
            }
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in "
            + /*<name>*/VNErrorCode/*</name>*/.class.getName());
    }

    // bind wrap to include it in compilation as long as nserror enum is used 
    static { Bro.bind(NSErrorWrap.class); }
    @StronglyLinked
    public static class NSErrorWrap extends NSError {
        protected NSErrorWrap(SkipInit skipInit) {super(skipInit);}

        @Override public NSErrorCode getErrorCode() {
             try {
                 return  /*<name>*/VNErrorCode/*</name>*/.valueOf(getCode());
             } catch (IllegalArgumentException e) {
                 return null;
             }
         }

        public static String getClassDomain() {
            /** must be incerted in value section */
            return /*<name>*/VNErrorCode/*</name>*/.getClassDomain();
        }
    }
}
