/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.addressbook.ABGroup;
import org.robovm.apple.addressbook.ABRecord;
import org.robovm.apple.addressbook.ABSourceProperty;
import org.robovm.apple.addressbook.ABSourceType;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AddressBook")
public class ABSource
extends ABRecord {
    public String getName() {
        CFString val = this.getValue(ABSourceProperty.Name, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABSource setName(String name) throws NSErrorException {
        if (name == null) {
            this.setValue(ABSourceProperty.Name, null);
        } else {
            this.setValue(ABSourceProperty.Name, new CFString(name));
        }
        return this;
    }

    public ABSourceType getType() {
        CFNumber val = this.getValue(ABSourceProperty.Type, CFNumber.class);
        if (val != null) {
            return new ABSourceType(val.intValue());
        }
        return null;
    }

    public ABSource setType(ABSourceType type) throws NSErrorException {
        if (type == null) {
            this.setValue(ABSourceProperty.Type, null);
        } else {
            this.setValue(ABSourceProperty.Type, CFNumber.valueOf((int)type.value()));
        }
        return this;
    }

    static {
        Bro.bind(ABGroup.class);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<ABSource> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<ABSource> list = new ArrayList<ABSource>();
            long n = o.size();
            for (long i = 0L; i < n; ++i) {
                ABRecord record = o.get(i, ABRecord.class);
                list.add((ABSource)NativeObject.Marshaler.toObject(ABSource.class, (long)record.getHandle(), (long)flags));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<ABSource> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (ABSource i : l) {
                ((CFArray)array).add(i);
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }
}

