/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAuthorizationStatus;
import org.robovm.apple.avfoundation.AVCaptureAutoFocusRangeRestriction;
import org.robovm.apple.avfoundation.AVCaptureCenterStageControlMode;
import org.robovm.apple.avfoundation.AVCaptureColorSpace;
import org.robovm.apple.avfoundation.AVCaptureDeviceFormat;
import org.robovm.apple.avfoundation.AVCaptureDevicePosition;
import org.robovm.apple.avfoundation.AVCaptureExposureMode;
import org.robovm.apple.avfoundation.AVCaptureFlashMode;
import org.robovm.apple.avfoundation.AVCaptureFocusMode;
import org.robovm.apple.avfoundation.AVCaptureMicrophoneMode;
import org.robovm.apple.avfoundation.AVCapturePrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions;
import org.robovm.apple.avfoundation.AVCapturePrimaryConstituentDeviceSwitchingBehavior;
import org.robovm.apple.avfoundation.AVCaptureSessionPreset;
import org.robovm.apple.avfoundation.AVCaptureSystemPressureState;
import org.robovm.apple.avfoundation.AVCaptureSystemUserInterface;
import org.robovm.apple.avfoundation.AVCaptureTorchMode;
import org.robovm.apple.avfoundation.AVCaptureWhiteBalanceChromaticityValues;
import org.robovm.apple.avfoundation.AVCaptureWhiteBalanceGains;
import org.robovm.apple.avfoundation.AVCaptureWhiteBalanceMode;
import org.robovm.apple.avfoundation.AVCaptureWhiteBalanceTemperatureAndTintValues;
import org.robovm.apple.avfoundation.AVMediaType;
import org.robovm.apple.coregraphics.CGPoint;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVCaptureDevice
extends NSObject {
    protected AVCaptureDevice() {
    }

    protected AVCaptureDevice(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVCaptureDevice(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="uniqueID")
    public native String getUniqueID();

    @Property(selector="modelID")
    public native String getModelID();

    @Property(selector="localizedName")
    public native String getLocalizedName();

    @Property(selector="manufacturer")
    public native String getManufacturer();

    @Property(selector="isConnected")
    public native boolean isConnected();

    @Property(selector="isSuspended")
    public native boolean isSuspended();

    @Property(selector="formats")
    public native NSArray<AVCaptureDeviceFormat> getFormats();

    @Property(selector="activeFormat")
    public native AVCaptureDeviceFormat getActiveFormat();

    @Property(selector="setActiveFormat:")
    public native void setActiveFormat(AVCaptureDeviceFormat var1);

    @Property(selector="activeVideoMinFrameDuration")
    @ByVal
    public native CMTime getActiveVideoMinFrameDuration();

    @Property(selector="setActiveVideoMinFrameDuration:")
    public native void setActiveVideoMinFrameDuration(@ByVal CMTime var1);

    @Property(selector="activeVideoMaxFrameDuration")
    @ByVal
    public native CMTime getActiveVideoMaxFrameDuration();

    @Property(selector="setActiveVideoMaxFrameDuration:")
    public native void setActiveVideoMaxFrameDuration(@ByVal CMTime var1);

    @Property(selector="position")
    public native AVCaptureDevicePosition getPosition();

    @Property(selector="deviceType")
    public native String getDeviceType();

    @Property(selector="systemPressureState")
    public native AVCaptureSystemPressureState getSystemPressureState();

    @Property(selector="isVirtualDevice")
    public native boolean isVirtualDevice();

    @Property(selector="constituentDevices")
    public native NSArray<AVCaptureDevice> getConstituentDevices();

    @Property(selector="virtualDeviceSwitchOverVideoZoomFactors")
    public native NSArray<NSNumber> getVirtualDeviceSwitchOverVideoZoomFactors();

    @Property(selector="primaryConstituentDeviceSwitchingBehavior")
    public native AVCapturePrimaryConstituentDeviceSwitchingBehavior getPrimaryConstituentDeviceSwitchingBehavior();

    @Property(selector="primaryConstituentDeviceRestrictedSwitchingBehaviorConditions")
    public native AVCapturePrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions getPrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions();

    @Property(selector="activePrimaryConstituentDeviceSwitchingBehavior")
    public native AVCapturePrimaryConstituentDeviceSwitchingBehavior getActivePrimaryConstituentDeviceSwitchingBehavior();

    @Property(selector="activePrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions")
    public native AVCapturePrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions getActivePrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions();

    @Property(selector="activePrimaryConstituentDevice")
    public native AVCaptureDevice getActivePrimaryConstituentDevice();

    @Property(selector="supportedFallbackPrimaryConstituentDevices")
    public native NSArray<AVCaptureDevice> getSupportedFallbackPrimaryConstituentDevices();

    @Property(selector="fallbackPrimaryConstituentDevices")
    public native NSArray<AVCaptureDevice> getFallbackPrimaryConstituentDevices();

    @Property(selector="setFallbackPrimaryConstituentDevices:")
    public native void setFallbackPrimaryConstituentDevices(NSArray<AVCaptureDevice> var1);

    @Property(selector="hasFlash")
    public native boolean hasFlash();

    @Property(selector="isFlashAvailable")
    public native boolean isFlashAvailable();

    @Deprecated
    @Property(selector="isFlashActive")
    public native boolean isFlashActive();

    @Deprecated
    @Property(selector="flashMode")
    public native AVCaptureFlashMode getFlashMode();

    @Deprecated
    @Property(selector="setFlashMode:")
    public native void setFlashMode(AVCaptureFlashMode var1);

    @Property(selector="hasTorch")
    public native boolean hasTorch();

    @Property(selector="isTorchAvailable")
    public native boolean isTorchAvailable();

    @Property(selector="isTorchActive")
    public native boolean isTorchActive();

    @Property(selector="torchLevel")
    public native float getTorchLevel();

    @Property(selector="torchMode")
    public native AVCaptureTorchMode getTorchMode();

    @Property(selector="setTorchMode:")
    public native void setTorchMode(AVCaptureTorchMode var1);

    @Property(selector="isLockingFocusWithCustomLensPositionSupported")
    public native boolean isLockingFocusWithCustomLensPositionSupported();

    @Property(selector="focusMode")
    public native AVCaptureFocusMode getFocusMode();

    @Property(selector="setFocusMode:")
    public native void setFocusMode(AVCaptureFocusMode var1);

    @Property(selector="isFocusPointOfInterestSupported")
    public native boolean isFocusPointOfInterestSupported();

    @Property(selector="focusPointOfInterest")
    @ByVal
    public native CGPoint getFocusPointOfInterest();

    @Property(selector="setFocusPointOfInterest:")
    public native void setFocusPointOfInterest(@ByVal CGPoint var1);

    @Property(selector="isAdjustingFocus")
    public native boolean isAdjustingFocus();

    @Property(selector="isAutoFocusRangeRestrictionSupported")
    public native boolean isAutoFocusRangeRestrictionSupported();

    @Property(selector="autoFocusRangeRestriction")
    public native AVCaptureAutoFocusRangeRestriction getAutoFocusRangeRestriction();

    @Property(selector="setAutoFocusRangeRestriction:")
    public native void setAutoFocusRangeRestriction(AVCaptureAutoFocusRangeRestriction var1);

    @Property(selector="isSmoothAutoFocusSupported")
    public native boolean isSmoothAutoFocusSupported();

    @Property(selector="isSmoothAutoFocusEnabled")
    public native boolean isSmoothAutoFocusEnabled();

    @Property(selector="setSmoothAutoFocusEnabled:")
    public native void setSmoothAutoFocusEnabled(boolean var1);

    @Property(selector="automaticallyAdjustsFaceDrivenAutoFocusEnabled")
    public native boolean automaticallyAdjustsFaceDrivenAutoFocusEnabled();

    @Property(selector="setAutomaticallyAdjustsFaceDrivenAutoFocusEnabled:")
    public native void setAutomaticallyAdjustsFaceDrivenAutoFocusEnabled(boolean var1);

    @Property(selector="isFaceDrivenAutoFocusEnabled")
    public native boolean isFaceDrivenAutoFocusEnabled();

    @Property(selector="setFaceDrivenAutoFocusEnabled:")
    public native void setFaceDrivenAutoFocusEnabled(boolean var1);

    @Property(selector="lensPosition")
    public native float getLensPosition();

    @Property(selector="minimumFocusDistance")
    @MachineSizedSInt
    public native long getMinimumFocusDistance();

    @Property(selector="exposureMode")
    public native AVCaptureExposureMode getExposureMode();

    @Property(selector="setExposureMode:")
    public native void setExposureMode(AVCaptureExposureMode var1);

    @Property(selector="isExposurePointOfInterestSupported")
    public native boolean isExposurePointOfInterestSupported();

    @Property(selector="exposurePointOfInterest")
    @ByVal
    public native CGPoint getExposurePointOfInterest();

    @Property(selector="setExposurePointOfInterest:")
    public native void setExposurePointOfInterest(@ByVal CGPoint var1);

    @Property(selector="automaticallyAdjustsFaceDrivenAutoExposureEnabled")
    public native boolean automaticallyAdjustsFaceDrivenAutoExposureEnabled();

    @Property(selector="setAutomaticallyAdjustsFaceDrivenAutoExposureEnabled:")
    public native void setAutomaticallyAdjustsFaceDrivenAutoExposureEnabled(boolean var1);

    @Property(selector="isFaceDrivenAutoExposureEnabled")
    public native boolean isFaceDrivenAutoExposureEnabled();

    @Property(selector="setFaceDrivenAutoExposureEnabled:")
    public native void setFaceDrivenAutoExposureEnabled(boolean var1);

    @Property(selector="activeMaxExposureDuration")
    @ByVal
    public native CMTime getActiveMaxExposureDuration();

    @Property(selector="setActiveMaxExposureDuration:")
    public native void setActiveMaxExposureDuration(@ByVal CMTime var1);

    @Property(selector="isAdjustingExposure")
    public native boolean isAdjustingExposure();

    @Property(selector="lensAperture")
    public native float getLensAperture();

    @Property(selector="exposureDuration")
    @ByVal
    public native CMTime getExposureDuration();

    @Property(selector="ISO")
    public native float getISO();

    @Property(selector="exposureTargetOffset")
    public native float getExposureTargetOffset();

    @Property(selector="exposureTargetBias")
    public native float getExposureTargetBias();

    @Property(selector="minExposureTargetBias")
    public native float getMinExposureTargetBias();

    @Property(selector="maxExposureTargetBias")
    public native float getMaxExposureTargetBias();

    @Property(selector="isGlobalToneMappingEnabled")
    public native boolean isGlobalToneMappingEnabled();

    @Property(selector="setGlobalToneMappingEnabled:")
    public native void setGlobalToneMappingEnabled(boolean var1);

    @Property(selector="isLockingWhiteBalanceWithCustomDeviceGainsSupported")
    public native boolean isLockingWhiteBalanceWithCustomDeviceGainsSupported();

    @Property(selector="whiteBalanceMode")
    public native AVCaptureWhiteBalanceMode getWhiteBalanceMode();

    @Property(selector="setWhiteBalanceMode:")
    public native void setWhiteBalanceMode(AVCaptureWhiteBalanceMode var1);

    @Property(selector="isAdjustingWhiteBalance")
    public native boolean isAdjustingWhiteBalance();

    @Property(selector="deviceWhiteBalanceGains")
    @ByVal
    public native AVCaptureWhiteBalanceGains getDeviceWhiteBalanceGains();

    @Property(selector="grayWorldDeviceWhiteBalanceGains")
    @ByVal
    public native AVCaptureWhiteBalanceGains getGrayWorldDeviceWhiteBalanceGains();

    @Property(selector="maxWhiteBalanceGain")
    public native float getMaxWhiteBalanceGain();

    @Property(selector="isSubjectAreaChangeMonitoringEnabled")
    public native boolean isSubjectAreaChangeMonitoringEnabled();

    @Property(selector="setSubjectAreaChangeMonitoringEnabled:")
    public native void setSubjectAreaChangeMonitoringEnabled(boolean var1);

    @Property(selector="isLowLightBoostSupported")
    public native boolean isLowLightBoostSupported();

    @Property(selector="isLowLightBoostEnabled")
    public native boolean isLowLightBoostEnabled();

    @Property(selector="automaticallyEnablesLowLightBoostWhenAvailable")
    public native boolean automaticallyEnablesLowLightBoostWhenAvailable();

    @Property(selector="setAutomaticallyEnablesLowLightBoostWhenAvailable:")
    public native void setAutomaticallyEnablesLowLightBoostWhenAvailable(boolean var1);

    @Property(selector="videoZoomFactor")
    @MachineSizedFloat
    public native double getVideoZoomFactor();

    @Property(selector="setVideoZoomFactor:")
    public native void setVideoZoomFactor(@MachineSizedFloat double var1);

    @Property(selector="isRampingVideoZoom")
    public native boolean isRampingVideoZoom();

    @Deprecated
    @Property(selector="dualCameraSwitchOverVideoZoomFactor")
    @MachineSizedFloat
    public native double getDualCameraSwitchOverVideoZoomFactor();

    @Property(selector="automaticallyAdjustsVideoHDREnabled")
    public native boolean automaticallyAdjustsVideoHDREnabled();

    @Property(selector="setAutomaticallyAdjustsVideoHDREnabled:")
    public native void setAutomaticallyAdjustsVideoHDREnabled(boolean var1);

    @Property(selector="isVideoHDREnabled")
    public native boolean isVideoHDREnabled();

    @Property(selector="setVideoHDREnabled:")
    public native void setVideoHDREnabled(boolean var1);

    @Property(selector="activeColorSpace")
    public native AVCaptureColorSpace getActiveColorSpace();

    @Property(selector="setActiveColorSpace:")
    public native void setActiveColorSpace(AVCaptureColorSpace var1);

    @Property(selector="activeDepthDataFormat")
    public native AVCaptureDeviceFormat getActiveDepthDataFormat();

    @Property(selector="setActiveDepthDataFormat:")
    public native void setActiveDepthDataFormat(AVCaptureDeviceFormat var1);

    @Property(selector="activeDepthDataMinFrameDuration")
    @ByVal
    public native CMTime getActiveDepthDataMinFrameDuration();

    @Property(selector="setActiveDepthDataMinFrameDuration:")
    public native void setActiveDepthDataMinFrameDuration(@ByVal CMTime var1);

    @Property(selector="minAvailableVideoZoomFactor")
    @MachineSizedFloat
    public native double getMinAvailableVideoZoomFactor();

    @Property(selector="maxAvailableVideoZoomFactor")
    @MachineSizedFloat
    public native double getMaxAvailableVideoZoomFactor();

    @Property(selector="isGeometricDistortionCorrectionSupported")
    public native boolean isGeometricDistortionCorrectionSupported();

    @Property(selector="isGeometricDistortionCorrectionEnabled")
    public native boolean isGeometricDistortionCorrectionEnabled();

    @Property(selector="setGeometricDistortionCorrectionEnabled:")
    public native void setGeometricDistortionCorrectionEnabled(boolean var1);

    @Property(selector="centerStageControlMode")
    public static native AVCaptureCenterStageControlMode getCenterStageControlMode();

    @Property(selector="setCenterStageControlMode:")
    public static native void setCenterStageControlMode(AVCaptureCenterStageControlMode var0);

    @Property(selector="isCenterStageEnabled")
    public static native boolean isCenterStageEnabled();

    @Property(selector="setCenterStageEnabled:")
    public static native void setCenterStageEnabled(boolean var0);

    @Property(selector="isCenterStageActive")
    public native boolean isCenterStageActive();

    @Property(selector="isPortraitEffectEnabled")
    public static native boolean isPortraitEffectEnabled();

    @Property(selector="isPortraitEffectActive")
    public native boolean isPortraitEffectActive();

    @Property(selector="preferredMicrophoneMode")
    public static native AVCaptureMicrophoneMode getPreferredMicrophoneMode();

    @Property(selector="activeMicrophoneMode")
    public static native AVCaptureMicrophoneMode getActiveMicrophoneMode();

    @GlobalValue(symbol="AVCaptureDeviceWasConnectedNotification", optional=true)
    public static native NSString WasConnectedNotification();

    @GlobalValue(symbol="AVCaptureDeviceWasDisconnectedNotification", optional=true)
    public static native NSString WasDisconnectedNotification();

    @GlobalValue(symbol="AVCaptureDeviceSubjectAreaDidChangeNotification", optional=true)
    public static native NSString SubjectAreaDidChangeNotification();

    @GlobalValue(symbol="AVCaptureMaxAvailableTorchLevel", optional=true)
    public static native float getMaxAvailableTorchLevel();

    @GlobalValue(symbol="AVCaptureLensPositionCurrent", optional=true)
    public static native float getLensPositionCurrent();

    @GlobalValue(symbol="AVCaptureExposureDurationCurrent", optional=true)
    @ByVal
    public static native CMTime getExposureDurationCurrent();

    @GlobalValue(symbol="AVCaptureISOCurrent", optional=true)
    public static native float getISOCurrent();

    @GlobalValue(symbol="AVCaptureExposureTargetBiasCurrent", optional=true)
    public static native float getExposureTargetBiasCurrent();

    @GlobalValue(symbol="AVCaptureWhiteBalanceGainsCurrent", optional=true)
    @ByVal
    public static native AVCaptureWhiteBalanceGains getWhiteBalanceGainsCurrent();

    @Method(selector="hasMediaType:")
    public native boolean hasMediaType(AVMediaType var1);

    public boolean lockForConfiguration() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.lockForConfiguration(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="lockForConfiguration:")
    private native boolean lockForConfiguration(NSError.NSErrorPtr var1);

    @Method(selector="unlockForConfiguration")
    public native void unlockForConfiguration();

    @Method(selector="supportsAVCaptureSessionPreset:")
    public native boolean supportsAVCaptureSessionPreset(AVCaptureSessionPreset var1);

    @Deprecated
    @Method(selector="devices")
    public static native NSArray<AVCaptureDevice> getDevices();

    @Deprecated
    @Method(selector="devicesWithMediaType:")
    public static native NSArray<AVCaptureDevice> getDevicesForMediaType(AVMediaType var0);

    @Method(selector="defaultDeviceWithMediaType:")
    public static native AVCaptureDevice getDefaultDeviceForMediaType(AVMediaType var0);

    @Method(selector="deviceWithUniqueID:")
    public static native AVCaptureDevice getDeviceWithUniqueID(String var0);

    @Method(selector="defaultDeviceWithDeviceType:mediaType:position:")
    public static native AVCaptureDevice getDefaultDevice(String var0, AVMediaType var1, AVCaptureDevicePosition var2);

    @Method(selector="setPrimaryConstituentDeviceSwitchingBehavior:restrictedSwitchingBehaviorConditions:")
    public native void setPrimaryConstituentDeviceSwitchingBehavior(AVCapturePrimaryConstituentDeviceSwitchingBehavior var1, AVCapturePrimaryConstituentDeviceRestrictedSwitchingBehaviorConditions var2);

    @Deprecated
    @Method(selector="isFlashModeSupported:")
    public native boolean isFlashModeSupported(AVCaptureFlashMode var1);

    @Method(selector="isTorchModeSupported:")
    public native boolean isTorchModeSupported(AVCaptureTorchMode var1);

    public boolean setTorchModeOn(float torchLevel) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setTorchModeOn(torchLevel, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setTorchModeOnWithLevel:error:")
    private native boolean setTorchModeOn(float var1, NSError.NSErrorPtr var2);

    @Method(selector="isFocusModeSupported:")
    public native boolean isFocusModeSupported(AVCaptureFocusMode var1);

    @Method(selector="setFocusModeLockedWithLensPosition:completionHandler:")
    public native void setFocusModeLocked(float var1, @Block(value="(@ByVal)") VoidBlock1<CMTime> var2);

    @Method(selector="isExposureModeSupported:")
    public native boolean isExposureModeSupported(AVCaptureExposureMode var1);

    @Method(selector="setExposureModeCustomWithDuration:ISO:completionHandler:")
    public native void setExposureModeCustom(@ByVal CMTime var1, float var2, @Block(value="(@ByVal)") VoidBlock1<CMTime> var3);

    @Method(selector="setExposureTargetBias:completionHandler:")
    public native void setExposureTargetBias(float var1, @Block(value="(@ByVal)") VoidBlock1<CMTime> var2);

    @Method(selector="isWhiteBalanceModeSupported:")
    public native boolean isWhiteBalanceModeSupported(AVCaptureWhiteBalanceMode var1);

    @Method(selector="setWhiteBalanceModeLockedWithDeviceWhiteBalanceGains:completionHandler:")
    public native void setWhiteBalanceModeLocked(@ByVal AVCaptureWhiteBalanceGains var1, @Block(value="(@ByVal)") VoidBlock1<CMTime> var2);

    @Method(selector="chromaticityValuesForDeviceWhiteBalanceGains:")
    @ByVal
    public native AVCaptureWhiteBalanceChromaticityValues convertDeviceWhiteBalanceGainsToChromaticityValues(@ByVal AVCaptureWhiteBalanceGains var1);

    @Method(selector="deviceWhiteBalanceGainsForChromaticityValues:")
    @ByVal
    public native AVCaptureWhiteBalanceGains convertChromaticityValuesToDeviceWhiteBalanceGains(@ByVal AVCaptureWhiteBalanceChromaticityValues var1);

    @Method(selector="temperatureAndTintValuesForDeviceWhiteBalanceGains:")
    @ByVal
    public native AVCaptureWhiteBalanceTemperatureAndTintValues convertDeviceWhiteBalanceGainsToTemperatureAndTintValues(@ByVal AVCaptureWhiteBalanceGains var1);

    @Method(selector="deviceWhiteBalanceGainsForTemperatureAndTintValues:")
    @ByVal
    public native AVCaptureWhiteBalanceGains convertTemperatureAndTintValuesToDeviceWhiteBalanceGains(@ByVal AVCaptureWhiteBalanceTemperatureAndTintValues var1);

    @Method(selector="rampToVideoZoomFactor:withRate:")
    public native void rampToVideoZoomFactor(@MachineSizedFloat double var1, float var3);

    @Method(selector="cancelVideoZoomRamp")
    public native void cancelVideoZoomRamp();

    @Method(selector="authorizationStatusForMediaType:")
    public static native AVAuthorizationStatus getAuthorizationStatusForMediaType(AVMediaType var0);

    @Method(selector="requestAccessForMediaType:completionHandler:")
    public static native void requestAccessForMediaType(AVMediaType var0, @Block VoidBooleanBlock var1);

    @Method(selector="extrinsicMatrixFromDevice:toDevice:")
    public static native NSData getExtrinsicMatrix(AVCaptureDevice var0, AVCaptureDevice var1);

    @Method(selector="showSystemUserInterface:")
    public static native void showSystemUserInterface(AVCaptureSystemUserInterface var0);

    static {
        ObjCRuntime.bind(AVCaptureDevice.class);
    }

    public static class AVCaptureDevicePtr
    extends Ptr<AVCaptureDevice, AVCaptureDevicePtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeWasConnected(final VoidBlock1<AVCaptureDevice> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureDevice.WasConnectedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVCaptureDevice)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeWasDisconnected(final VoidBlock1<AVCaptureDevice> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureDevice.WasDisconnectedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVCaptureDevice)a.getObject()));
                }
            });
        }

        public static NSObjectProtocol observeSubjectAreaDidChange(AVCaptureDevice object, final VoidBlock1<AVCaptureDevice> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVCaptureDevice.SubjectAreaDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVCaptureDevice)a.getObject()));
                }
            });
        }
    }
}

