/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.cloudkit;

import org.robovm.apple.cloudkit.CKErrorCode;
import org.robovm.apple.cloudkit.CKErrorUserInfoKey;
import org.robovm.apple.cloudkit.CKRecord;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="CloudKit")
@StronglyLinked
public class CKError
extends NSError {
    private NSErrorUserInfo userInfo;

    protected CKError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    private NSErrorUserInfo getCachedUserInfo() {
        if (this.userInfo == null) {
            this.userInfo = this.getUserInfo();
        }
        return this.userInfo;
    }

    @Override
    public CKErrorCode getErrorCode() {
        CKErrorCode code = null;
        try {
            code = CKErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public NSDictionary<?, ?> getPartialErrors() {
        if (this.getCachedUserInfo().has(CKErrorUserInfoKey.PartialErrorsByItemID)) {
            NSDictionary val = (NSDictionary)this.getCachedUserInfo().get(CKErrorUserInfoKey.PartialErrorsByItemID);
            return val;
        }
        return null;
    }

    public CKRecord getAncestorRecord() {
        if (this.getCachedUserInfo().has(CKErrorUserInfoKey.AncestorRecord)) {
            CKRecord val = (CKRecord)this.getCachedUserInfo().get(CKErrorUserInfoKey.AncestorRecord);
            return val;
        }
        return null;
    }

    public CKRecord getServerRecord() {
        if (this.getCachedUserInfo().has(CKErrorUserInfoKey.ServerRecord)) {
            CKRecord val = (CKRecord)this.getCachedUserInfo().get(CKErrorUserInfoKey.ServerRecord);
            return val;
        }
        return null;
    }

    public CKRecord getClientRecord() {
        if (this.getCachedUserInfo().has(CKErrorUserInfoKey.ClientRecord)) {
            CKRecord val = (CKRecord)this.getCachedUserInfo().get(CKErrorUserInfoKey.ClientRecord);
            return val;
        }
        return null;
    }

    public double retriesAfterTime() {
        if (this.getCachedUserInfo().has(CKErrorUserInfoKey.RetryAfter)) {
            NSNumber val = (NSNumber)this.getCachedUserInfo().get(CKErrorUserInfoKey.RetryAfter);
            return val.doubleValue();
        }
        return -1.0;
    }

    @GlobalValue(symbol="CKErrorDomain", optional=true)
    public static native String getClassDomain();

    @GlobalValue(symbol="CKErrorUserDidResetEncryptedDataKey", optional=true)
    public static native String getUserDidResetEncryptedDataKey();

    static {
        Bro.bind(CKError.class);
    }
}

