/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Field;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFCharacterSet;
import org.robovm.apple.corefoundation.CFComparisonResult;
import org.robovm.apple.corefoundation.CFData;
import org.robovm.apple.corefoundation.CFLocale;
import org.robovm.apple.corefoundation.CFPropertyList;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFStringCompareFlags;
import org.robovm.apple.corefoundation.CFStringEncodings;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.AfterBridgeCall;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.ShortPtr;

@Library(value="CoreFoundation")
public class CFString
extends CFPropertyList {
    private static String EMPTY_STRING;
    private static final long STRING_VALUE_OFFSET;
    private static final long STRING_OFFSET_OFFSET;

    protected CFString() {
    }

    public CFString(String s) {
        int offset = VM.getInt((long)(VM.getObjectAddress((Object)s) + STRING_OFFSET_OFFSET));
        char[] value = (char[])VM.getObject((long)(VM.getObjectAddress((Object)s) + STRING_VALUE_OFFSET));
        long content = VM.getArrayValuesAddress((Object)value) + (long)(offset << 1);
        this.setHandle(CFString.createWithCharacters(null, content, (long)s.length()));
    }

    @Override
    public String toString() {
        int len = (int)this.length();
        if (len == 0) {
            return EMPTY_STRING;
        }
        char[] chars = new char[len];
        CFString.getCharacters(this.getHandle(), new CFRange(0L, len), VM.getArrayValuesAddress((Object)chars));
        return VM.newStringNoCopy((char[])chars, (int)0, (int)len);
    }

    @Bridge(symbol="CFStringCreateWithCharacters")
    @Pointer
    private static native long createWithCharacters(CFAllocator var0, @Pointer long var1, @MachineSizedSInt long var3);

    @Bridge(symbol="CFStringGetCharacters")
    private static native void getCharacters(@Pointer long var0, @ByVal CFRange var2, @Pointer long var3);

    @Bridge(symbol="CFStringGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFStringCreateWithPascalString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithPascalString(CFAllocator var0, BytePtr var1, CFStringEncodings var2);

    @Bridge(symbol="CFStringCreateWithCString", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithCString(CFAllocator var0, BytePtr var1, CFStringEncodings var2);

    @Bridge(symbol="CFStringCreateWithBytes", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithBytes(CFAllocator var0, BytePtr var1, @MachineSizedSInt long var2, CFStringEncodings var4, boolean var5);

    @Bridge(symbol="CFStringCreateWithCharacters", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithCharacters(CFAllocator var0, ShortPtr var1, @MachineSizedSInt long var2);

    @Bridge(symbol="CFStringCreateWithPascalStringNoCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithPascalStringNoCopy(CFAllocator var0, BytePtr var1, CFStringEncodings var2, CFAllocator var3);

    @Bridge(symbol="CFStringCreateWithCStringNoCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithCStringNoCopy(CFAllocator var0, BytePtr var1, CFStringEncodings var2, CFAllocator var3);

    @Bridge(symbol="CFStringCreateWithBytesNoCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithBytesNoCopy(CFAllocator var0, BytePtr var1, @MachineSizedSInt long var2, CFStringEncodings var4, boolean var5, CFAllocator var6);

    @Bridge(symbol="CFStringCreateWithCharactersNoCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithCharactersNoCopy(CFAllocator var0, ShortPtr var1, @MachineSizedSInt long var2, CFAllocator var4);

    @Bridge(symbol="CFStringCreateWithSubstring", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithSubstring(CFAllocator var0, String var1, @ByVal CFRange var2);

    @Bridge(symbol="CFStringCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createCopy(CFAllocator var0, CFString var1);

    @Bridge(symbol="CFStringGetLength", optional=true)
    @MachineSizedSInt
    public native long length();

    @Bridge(symbol="CFStringGetCharacterAtIndex", optional=true)
    protected native short getCharacterAtIndex(@MachineSizedSInt long var1);

    @Bridge(symbol="CFStringGetCharacters", optional=true)
    protected native void getCharacters(@ByVal CFRange var1, ShortPtr var2);

    @Bridge(symbol="CFStringGetPascalString", optional=true)
    protected native boolean getPascalString(BytePtr var1, @MachineSizedSInt long var2, CFStringEncodings var4);

    @Bridge(symbol="CFStringGetCString", optional=true)
    protected native boolean getCString(BytePtr var1, @MachineSizedSInt long var2, CFStringEncodings var4);

    @Bridge(symbol="CFStringGetPascalStringPtr", optional=true)
    protected native BytePtr getPascalStringPtr(CFStringEncodings var1);

    @Bridge(symbol="CFStringGetCStringPtr", optional=true)
    protected native BytePtr getCStringPtr(CFStringEncodings var1);

    @Bridge(symbol="CFStringGetCharactersPtr", optional=true)
    protected native ShortPtr getCharactersPtr();

    @Bridge(symbol="CFStringGetBytes", optional=true)
    @MachineSizedSInt
    protected native long getBytes(@ByVal CFRange var1, CFStringEncodings var2, byte var3, boolean var4, BytePtr var5, @MachineSizedSInt long var6, MachineSizedSIntPtr var8);

    @Bridge(symbol="CFStringCreateFromExternalRepresentation", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createFromExternalRepresentation(CFAllocator var0, CFData var1, CFStringEncodings var2);

    @Bridge(symbol="CFStringCreateExternalRepresentation", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createExternalRepresentation(CFAllocator var0, CFString var1, CFStringEncodings var2, byte var3);

    @Bridge(symbol="CFStringGetSmallestEncoding", optional=true)
    protected native CFStringEncodings getSmallestEncoding();

    @Bridge(symbol="CFStringGetFastestEncoding", optional=true)
    protected native CFStringEncodings getFastestEncoding();

    @Bridge(symbol="CFStringGetSystemEncoding", optional=true)
    protected static native CFStringEncodings getSystemEncoding();

    @Bridge(symbol="CFStringGetMaximumSizeForEncoding", optional=true)
    @MachineSizedSInt
    protected static native long getMaximumSizeForEncoding(@MachineSizedSInt long var0, CFStringEncodings var2);

    @Bridge(symbol="CFStringGetFileSystemRepresentation", optional=true)
    protected static native boolean getFileSystemRepresentation(String var0, BytePtr var1, @MachineSizedSInt long var2);

    @Bridge(symbol="CFStringGetMaximumSizeOfFileSystemRepresentation", optional=true)
    @MachineSizedSInt
    protected static native long getMaximumSizeOfFileSystemRepresentation(String var0);

    @Bridge(symbol="CFStringCreateWithFileSystemRepresentation", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createWithFileSystemRepresentation(CFAllocator var0, BytePtr var1);

    @Bridge(symbol="CFStringCompareWithOptionsAndLocale", optional=true)
    public static native CFComparisonResult compare(String var0, String var1, @ByVal CFRange var2, CFStringCompareFlags var3, CFLocale var4);

    @Bridge(symbol="CFStringCompareWithOptions", optional=true)
    public static native CFComparisonResult compare(String var0, String var1, @ByVal CFRange var2, CFStringCompareFlags var3);

    @Bridge(symbol="CFStringCompare", optional=true)
    public static native CFComparisonResult compare(String var0, String var1, CFStringCompareFlags var2);

    @Bridge(symbol="CFStringFindWithOptionsAndLocale", optional=true)
    public native boolean find(String var1, @ByVal CFRange var2, CFStringCompareFlags var3, CFLocale var4, CFRange var5);

    @Bridge(symbol="CFStringFindWithOptions", optional=true)
    public native boolean find(String var1, @ByVal CFRange var2, CFStringCompareFlags var3, CFRange var4);

    @Bridge(symbol="CFStringCreateArrayWithFindResults", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createArrayWithFindResults(CFAllocator var0, CFString var1, String var2, @ByVal CFRange var3, CFStringCompareFlags var4);

    @Bridge(symbol="CFStringFind", optional=true)
    @ByVal
    public native CFRange find(String var1, CFStringCompareFlags var2);

    @Bridge(symbol="CFStringHasPrefix", optional=true)
    public native boolean hasPrefix(String var1);

    @Bridge(symbol="CFStringHasSuffix", optional=true)
    public native boolean hasSuffix(String var1);

    @Bridge(symbol="CFStringGetRangeOfComposedCharactersAtIndex", optional=true)
    @ByVal
    protected native CFRange getRangeOfComposedCharactersAtIndex(@MachineSizedSInt long var1);

    @Bridge(symbol="CFStringFindCharacterFromSet", optional=true)
    public native boolean find(CFCharacterSet var1, @ByVal CFRange var2, CFStringCompareFlags var3, CFRange var4);

    @Bridge(symbol="CFStringGetLineBounds", optional=true)
    protected native void getLineBounds(@ByVal CFRange var1, MachineSizedSIntPtr var2, MachineSizedSIntPtr var3, MachineSizedSIntPtr var4);

    @Bridge(symbol="CFStringGetParagraphBounds", optional=true)
    protected static native void getParagraphBounds(String var0, @ByVal CFRange var1, MachineSizedSIntPtr var2, MachineSizedSIntPtr var3, MachineSizedSIntPtr var4);

    @Bridge(symbol="CFStringGetHyphenationLocationBeforeIndex", optional=true)
    @MachineSizedSInt
    protected native long getHyphenationLocationBeforeIndex(@MachineSizedSInt long var1, @ByVal CFRange var3, @MachineSizedUInt long var4, CFLocale var6, IntPtr var7);

    @Bridge(symbol="CFStringIsHyphenationAvailableForLocale", optional=true)
    protected static native boolean isHyphenationAvailableForLocale(CFLocale var0);

    @Bridge(symbol="CFStringCreateByCombiningStrings", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createByCombiningStrings(CFAllocator var0, CFArray var1, String var2);

    @Bridge(symbol="CFStringCreateArrayBySeparatingStrings", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CFString createArrayBySeparatingStrings(CFAllocator var0, CFString var1, String var2);

    @Bridge(symbol="CFStringGetIntValue", optional=true)
    protected static native int getIntValue(String var0);

    @Bridge(symbol="CFStringGetDoubleValue", optional=true)
    protected static native double getDoubleValue(String var0);

    @Bridge(symbol="CFStringIsEncodingAvailable", optional=true)
    protected static native boolean isEncodingAvailable(CFStringEncodings var0);

    @Bridge(symbol="CFStringGetListOfAvailableEncodings", optional=true)
    protected static native IntPtr getListOfAvailableEncodings();

    @Bridge(symbol="CFStringGetNameOfEncoding", optional=true)
    protected static native String getNameOfEncoding(CFStringEncodings var0);

    @Bridge(symbol="CFStringConvertEncodingToNSStringEncoding", optional=true)
    @MachineSizedUInt
    protected static native long convertEncodingToNSStringEncoding(CFStringEncodings var0);

    @Bridge(symbol="CFStringConvertNSStringEncodingToEncoding", optional=true)
    protected static native CFStringEncodings convertNSStringEncodingToEncoding(@MachineSizedUInt long var0);

    @Bridge(symbol="CFStringConvertEncodingToWindowsCodepage", optional=true)
    protected static native int convertEncodingToWindowsCodepage(CFStringEncodings var0);

    @Bridge(symbol="CFStringConvertWindowsCodepageToEncoding", optional=true)
    protected static native CFStringEncodings convertWindowsCodepageToEncoding(int var0);

    @Bridge(symbol="CFStringConvertIANACharSetNameToEncoding", optional=true)
    protected native CFStringEncodings convertIANACharSetNameToEncoding();

    @Bridge(symbol="CFStringConvertEncodingToIANACharSetName", optional=true)
    protected static native String convertEncodingToIANACharSetName(CFStringEncodings var0);

    @Bridge(symbol="CFStringGetMostCompatibleMacStringEncoding", optional=true)
    protected static native CFStringEncodings getMostCompatibleMacStringEncoding(CFStringEncodings var0);

    @Override
    @Bridge(symbol="CFShowStr", optional=true)
    public native void show();

    static {
        Bro.bind(CFString.class);
        EMPTY_STRING = "";
        try {
            STRING_VALUE_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)String.class.getDeclaredField("value")));
            STRING_OFFSET_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)String.class.getDeclaredField("offset")));
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static class AsStringNoRetainMarshaler {
        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            try (CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags, false);){
                String string = o != null ? o.toString() : null;
                return string;
            }
        }
    }

    public static class AsStringMarshaler {
        @MarshalsPointer
        public static String toObject(Class<?> cls, long handle, long flags) {
            try (CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags, true);){
                String string = o != null ? o.toString() : null;
                return string;
            }
        }

        @MarshalsPointer
        public static long toNative(String o, long flags) {
            if (o == null) {
                return 0L;
            }
            try (CFString s = new CFString(o);){
                s.retain();
                long l = s.getHandle();
                return l;
            }
        }

        @AfterBridgeCall
        public static void afterJavaToNative(String before, long after, long flags) {
            if (after != 0L) {
                CFType.release(after);
            }
        }
    }

    public static class CFStringPtr
    extends Ptr<CFString, CFStringPtr> {
    }
}

