/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.Collection;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFBundle;
import org.robovm.apple.coregraphics.CGFont;
import org.robovm.apple.coretext.CTFontDescriptor;
import org.robovm.apple.coretext.CTFontManagerScope;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.Block2;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Library(value="CoreText")
public class CTFontManager
extends CocoaUtility {
    public static boolean registerFonts(List<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.registerFonts(new NSArray<NSURL>((Collection<NSURL>)fontURLs), scope, null);
    }

    public static boolean registerFonts(NSArray<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.registerFonts(fontURLs, scope, null);
    }

    public static boolean unregisterFonts(List<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.unregisterFonts(new NSArray<NSURL>((Collection<NSURL>)fontURLs), scope, null);
    }

    public static boolean unregisterFonts(NSArray<NSURL> fontURLs, CTFontManagerScope scope) {
        return CTFontManager.unregisterFonts(fontURLs, scope, null);
    }

    @GlobalValue(symbol="kCTFontManagerRegisteredFontsChangedNotification", optional=true)
    public static native NSString RegisteredFontsChangedNotification();

    @Bridge(symbol="CTFontManagerCopyAvailablePostScriptNames", optional=true)
    public static native CFArray copyAvailablePostScriptNames();

    @Bridge(symbol="CTFontManagerCopyAvailableFontFamilyNames", optional=true)
    public static native CFArray copyAvailableFontFamilyNames();

    @Bridge(symbol="CTFontManagerCreateFontDescriptorsFromURL", optional=true)
    @Marshaler(value=CTFontDescriptor.AsListMarshaler.class)
    public static native List<CTFontDescriptor> createFontDescriptors(NSURL var0);

    @Bridge(symbol="CTFontManagerCreateFontDescriptorFromData", optional=true)
    public static native CTFontDescriptor createFontDescriptor(NSData var0);

    @Bridge(symbol="CTFontManagerCreateFontDescriptorsFromData", optional=true)
    public static native CFArray createFontDescriptorsFromData(NSData var0);

    public static boolean registerFonts(NSURL fontURL, CTFontManagerScope scope) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.registerFonts(fontURL, scope, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerRegisterFontsForURL", optional=true)
    private static native boolean registerFonts(NSURL var0, CTFontManagerScope var1, NSError.NSErrorPtr var2);

    public static boolean unregisterFonts(NSURL fontURL, CTFontManagerScope scope) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.unregisterFonts(fontURL, scope, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerUnregisterFontsForURL", optional=true)
    private static native boolean unregisterFonts(NSURL var0, CTFontManagerScope var1, NSError.NSErrorPtr var2);

    public static boolean registerGraphicsFont(CGFont font) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.registerGraphicsFont(font, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerRegisterGraphicsFont", optional=true)
    private static native boolean registerGraphicsFont(CGFont var0, NSError.NSErrorPtr var1);

    public static boolean unregisterGraphicsFont(CGFont font) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = CTFontManager.unregisterGraphicsFont(font, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="CTFontManagerUnregisterGraphicsFont", optional=true)
    private static native boolean unregisterGraphicsFont(CGFont var0, NSError.NSErrorPtr var1);

    @Deprecated
    @Bridge(symbol="CTFontManagerRegisterFontsForURLs", optional=true)
    protected static native boolean registerFonts(NSArray<NSURL> var0, CTFontManagerScope var1, NSArray.NSArrayPtr var2);

    @Deprecated
    @Bridge(symbol="CTFontManagerUnregisterFontsForURLs", optional=true)
    protected static native boolean unregisterFonts(NSArray<NSURL> var0, CTFontManagerScope var1, NSArray.NSArrayPtr var2);

    @Bridge(symbol="CTFontManagerRegisterFontURLs", optional=true)
    public static native void registerFontURLs(CFArray var0, CTFontManagerScope var1, boolean var2, @Block Block2<CFArray, Boolean, Boolean> var3);

    @Bridge(symbol="CTFontManagerUnregisterFontURLs", optional=true)
    public static native void unregisterFontURLs(CFArray var0, CTFontManagerScope var1, @Block Block2<CFArray, Boolean, Boolean> var2);

    @Bridge(symbol="CTFontManagerRegisterFontDescriptors", optional=true)
    public static native void registerFontDescriptors(CFArray var0, CTFontManagerScope var1, boolean var2, @Block Block2<CFArray, Boolean, Boolean> var3);

    @Bridge(symbol="CTFontManagerUnregisterFontDescriptors", optional=true)
    public static native void unregisterFontDescriptors(CFArray var0, CTFontManagerScope var1, @Block Block2<CFArray, Boolean, Boolean> var2);

    @Bridge(symbol="CTFontManagerRegisterFontsWithAssetNames", optional=true)
    public static native void registerFontsWithAssetNames(CFArray var0, CFBundle var1, CTFontManagerScope var2, boolean var3, @Block Block2<CFArray, Boolean, Boolean> var4);

    @Bridge(symbol="CTFontManagerCopyRegisteredFontDescriptors", optional=true)
    public static native CFArray copyRegisteredFontDescriptors(CTFontManagerScope var0, boolean var1);

    @Bridge(symbol="CTFontManagerRequestFonts", optional=true)
    public static native void requestFonts(CFArray var0, @Block VoidBlock1<CFArray> var1);

    static {
        Bro.bind(CTFontManager.class);
    }

    public static class Notifications {
        public static NSObjectProtocol observeRegisteredFontsChanged(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(CTFontManager.RegisteredFontsChangedNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

