/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.dispatch;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.robovm.apple.dispatch.AutoreleaseFrequency;
import org.robovm.apple.dispatch.Dispatch;
import org.robovm.apple.dispatch.DispatchObject;
import org.robovm.apple.dispatch.DispatchQueueAttr;
import org.robovm.apple.dispatch.timespec;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.StringMarshalers;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="System")
public class DispatchQueue
extends DispatchObject {
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_LOW = -2;
    public static final int PRIORITY_BACKGROUND = Short.MIN_VALUE;

    protected DispatchQueue() {
    }

    public void apply(long iterations, VoidBlock1<Long> block) {
        DispatchQueue.apply(iterations, this, block);
    }

    public void after(long delay, TimeUnit unit, Runnable block) {
        DispatchQueue.after(Dispatch.time(0L, unit.toNanos(delay)), this, block);
    }

    public void at(Date when, Runnable block) {
        long ms = when.getTime();
        timespec ts = new timespec(ms / 1000L, ms % 1000L * 1000L);
        DispatchQueue.after(Dispatch.walltime(ts, 0L), this, block);
    }

    @GlobalValue(symbol="_dispatch_main_q", optional=true, dereference=false)
    public static native DispatchQueue getMainQueue();

    @Bridge(symbol="dispatch_async", optional=true)
    public native void async(@Block Runnable var1);

    @Bridge(symbol="dispatch_sync", optional=true)
    public native void sync(@Block Runnable var1);

    @Bridge(symbol="dispatch_async_and_wait", optional=true)
    public native void asyncAndWait(@Block Runnable var1);

    @Bridge(symbol="dispatch_async_and_wait_f", optional=true)
    public native void asyncAndWaitF(VoidPtr var1, FunctionPtr var2);

    @Bridge(symbol="dispatch_apply", optional=true)
    private static native void apply(@MachineSizedUInt long var0, DispatchQueue var2, @Block(value="(@MachineSizedUInt)") VoidBlock1<Long> var3);

    @Bridge(symbol="dispatch_get_global_queue", optional=true)
    public static native DispatchQueue getGlobalQueue(@MachineSizedSInt long var0, @MachineSizedUInt long var2);

    @Bridge(symbol="dispatch_queue_attr_make_initially_inactive", optional=true)
    public static native DispatchQueueAttr attrMakeInitiallyInactive(DispatchQueueAttr var0);

    @Bridge(symbol="dispatch_queue_attr_make_with_autorelease_frequency", optional=true)
    public static native DispatchQueueAttr attrMakeWithAutoreleaseFrequency(DispatchQueueAttr var0, AutoreleaseFrequency var1);

    @Bridge(symbol="dispatch_queue_create_with_target", optional=true)
    public static native DispatchQueue createWithTarget(@Marshaler(value=StringMarshalers.AsUtf8ZMarshaler.class) String var0, DispatchQueueAttr var1, DispatchQueue var2);

    @Bridge(symbol="dispatch_queue_create", optional=true)
    public static native DispatchQueue create(@Marshaler(value=StringMarshalers.AsUtf8ZMarshaler.class) String var0, DispatchQueueAttr var1);

    @Bridge(symbol="dispatch_queue_get_label", optional=true)
    @Marshaler(value=StringMarshalers.AsUtf8ZMarshaler.class)
    public native String getLabel();

    @Bridge(symbol="dispatch_after", optional=true)
    private static native void after(long var0, DispatchQueue var2, @Block Runnable var3);

    @Bridge(symbol="dispatch_barrier_async", optional=true)
    public native void barrierAsync(@Block Runnable var1);

    @Bridge(symbol="dispatch_barrier_sync", optional=true)
    public native void barrierSync(@Block Runnable var1);

    @Bridge(symbol="dispatch_barrier_async_and_wait", optional=true)
    public native void barrierAsyncAndWait(@Block Runnable var1);

    @Bridge(symbol="dispatch_queue_set_specific", optional=true)
    public native void setSpecific(VoidPtr var1, VoidPtr var2, FunctionPtr var3);

    @Bridge(symbol="dispatch_queue_get_specific", optional=true)
    public native VoidPtr getSpecific(VoidPtr var1);

    @Bridge(symbol="dispatch_get_specific", optional=true)
    public static native VoidPtr getCurrentSpecific(VoidPtr var0);

    @Bridge(symbol="dispatch_assert_queue", optional=true)
    public native void assertQueue();

    @Bridge(symbol="dispatch_assert_queue_barrier", optional=true)
    public native void assertQueueBarrier();

    @Bridge(symbol="dispatch_assert_queue_not", optional=true)
    public native void assertQueueNot();

    static {
        Bro.bind(DispatchQueue.class);
    }

    public static class DispatchQueuePtr
    extends Ptr<DispatchQueue, DispatchQueuePtr> {
    }
}

