/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.eventkit;

import org.robovm.apple.eventkit.EKAuthorizationStatus;
import org.robovm.apple.eventkit.EKCalendar;
import org.robovm.apple.eventkit.EKCalendarItem;
import org.robovm.apple.eventkit.EKEntityType;
import org.robovm.apple.eventkit.EKEvent;
import org.robovm.apple.eventkit.EKReminder;
import org.robovm.apple.eventkit.EKSource;
import org.robovm.apple.eventkit.EKSpan;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSPredicate;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="EventKit")
@NativeClass
public class EKEventStore
extends NSObject {
    public EKEventStore() {
    }

    protected EKEventStore(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected EKEventStore(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="eventStoreIdentifier")
    public native String getEventStoreIdentifier();

    @Property(selector="delegateSources")
    public native NSArray<EKSource> getDelegateSources();

    @Property(selector="sources")
    public native NSArray<EKSource> getSources();

    @Property(selector="defaultCalendarForNewEvents")
    public native EKCalendar getDefaultCalendarForNewEvents();

    @GlobalValue(symbol="EKEventStoreChangedNotification", optional=true)
    public static native NSString ChangedNotification();

    @Method(selector="requestAccessToEntityType:completion:")
    public native void requestAccess(EKEntityType var1, @Block VoidBlock2<Boolean, NSError> var2);

    @Method(selector="sourceWithIdentifier:")
    public native EKSource getSource(String var1);

    @Method(selector="calendarsForEntityType:")
    public native NSArray<EKCalendar> getCalendars(EKEntityType var1);

    @Method(selector="defaultCalendarForNewReminders")
    public native EKCalendar getDefaultCalendarForNewReminders();

    @Method(selector="calendarWithIdentifier:")
    public native EKCalendar getCalendar(String var1);

    public boolean saveCalendar(EKCalendar calendar, boolean commit) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.saveCalendar(calendar, commit, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="saveCalendar:commit:error:")
    private native boolean saveCalendar(EKCalendar var1, boolean var2, NSError.NSErrorPtr var3);

    public boolean removeCalendar(EKCalendar calendar, boolean commit) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeCalendar(calendar, commit, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeCalendar:commit:error:")
    private native boolean removeCalendar(EKCalendar var1, boolean var2, NSError.NSErrorPtr var3);

    @Method(selector="calendarItemWithIdentifier:")
    public native EKCalendarItem getCalendarItem(String var1);

    @Method(selector="calendarItemsWithExternalIdentifier:")
    public native NSArray<EKCalendarItem> getCalendarItems(String var1);

    public boolean saveEvent(EKEvent event, EKSpan span) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.saveEvent(event, span, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="saveEvent:span:error:")
    private native boolean saveEvent(EKEvent var1, EKSpan var2, NSError.NSErrorPtr var3);

    public boolean removeEvent(EKEvent event, EKSpan span) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeEvent(event, span, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeEvent:span:error:")
    private native boolean removeEvent(EKEvent var1, EKSpan var2, NSError.NSErrorPtr var3);

    public boolean saveEvent(EKEvent event, EKSpan span, boolean commit) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.saveEvent(event, span, commit, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="saveEvent:span:commit:error:")
    private native boolean saveEvent(EKEvent var1, EKSpan var2, boolean var3, NSError.NSErrorPtr var4);

    public boolean removeEvent(EKEvent event, EKSpan span, boolean commit) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeEvent(event, span, commit, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeEvent:span:commit:error:")
    private native boolean removeEvent(EKEvent var1, EKSpan var2, boolean var3, NSError.NSErrorPtr var4);

    @Method(selector="eventWithIdentifier:")
    public native EKEvent getEvent(String var1);

    @Method(selector="eventsMatchingPredicate:")
    public native NSArray<EKEvent> getEvents(NSPredicate var1);

    @Method(selector="enumerateEventsMatchingPredicate:usingBlock:")
    public native void enumerateEvents(NSPredicate var1, @Block VoidBlock2<EKEvent, BooleanPtr> var2);

    @Method(selector="predicateForEventsWithStartDate:endDate:calendars:")
    public native NSPredicate getPredicateForEvents(NSDate var1, NSDate var2, NSArray<EKCalendar> var3);

    public boolean saveReminder(EKReminder reminder, boolean commit) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.saveReminder(reminder, commit, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="saveReminder:commit:error:")
    private native boolean saveReminder(EKReminder var1, boolean var2, NSError.NSErrorPtr var3);

    public boolean removeReminder(EKReminder reminder, boolean commit) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeReminder(reminder, commit, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeReminder:commit:error:")
    private native boolean removeReminder(EKReminder var1, boolean var2, NSError.NSErrorPtr var3);

    @Method(selector="fetchRemindersMatchingPredicate:completion:")
    public native NSObject fetchReminders(NSPredicate var1, @Block VoidBlock1<NSArray<EKReminder>> var2);

    @Method(selector="cancelFetchRequest:")
    public native void cancelFetchRequest(NSObject var1);

    @Method(selector="predicateForRemindersInCalendars:")
    public native NSPredicate getPredicateForReminders(NSArray<EKCalendar> var1);

    @Method(selector="predicateForIncompleteRemindersWithDueDateStarting:ending:calendars:")
    public native NSPredicate getPredicateForIncompleteReminders(NSDate var1, NSDate var2, NSArray<EKCalendar> var3);

    @Method(selector="predicateForCompletedRemindersWithCompletionDateStarting:ending:calendars:")
    public native NSPredicate getPredicateForCompletedReminders(NSDate var1, NSDate var2, NSArray<EKCalendar> var3);

    public boolean commit() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.commit(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="commit:")
    private native boolean commit(NSError.NSErrorPtr var1);

    @Method(selector="reset")
    public native void reset();

    @Method(selector="refreshSourcesIfNecessary")
    public native void refreshSourcesIfNecessary();

    @Method(selector="authorizationStatusForEntityType:")
    public static native EKAuthorizationStatus getAuthorizationStatusForEntityType(EKEntityType var0);

    static {
        ObjCRuntime.bind(EKEventStore.class);
    }

    public static class EKEventStorePtr
    extends Ptr<EKEventStore, EKEventStorePtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeChanged(EKEventStore object, final VoidBlock1<EKEventStore> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(EKEventStore.ChangedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((EKEventStore)a.getObject()));
                }
            });
        }
    }
}

