/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSCoder;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.apple.foundation.NSSecureCoding;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSFileHandle
extends NSObject
implements NSSecureCoding {
    public NSFileHandle() {
    }

    protected NSFileHandle(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSFileHandle(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithFileDescriptor:closeOnDealloc:")
    public NSFileHandle(int fd, boolean closeopt) {
        super(null);
        this.initObject(this.init(fd, closeopt));
    }

    @Method(selector="initWithCoder:")
    public NSFileHandle(NSCoder coder) {
        super(null);
        this.initObject(this.init(coder));
    }

    @Method(selector="initWithFileDescriptor:")
    public NSFileHandle(int fd) {
        super(null);
        this.initObject(this.init(fd));
    }

    @Property(selector="availableData")
    public native NSData getAvailableData();

    @Property(selector="fileHandleWithStandardInput")
    public static native NSFileHandle getStandardInput();

    @Property(selector="fileHandleWithStandardOutput")
    public static native NSFileHandle getStandardOutput();

    @Property(selector="fileHandleWithStandardError")
    public static native NSFileHandle getStandardError();

    @Property(selector="fileHandleWithNullDevice")
    public static native NSFileHandle getNullDevice();

    @Property(selector="readabilityHandler")
    @Block
    public native VoidBlock1<NSFileHandle> getReadabilityHandler();

    @Property(selector="setReadabilityHandler:")
    public native void setReadabilityHandler(@Block VoidBlock1<NSFileHandle> var1);

    @Property(selector="writeabilityHandler")
    @Block
    public native VoidBlock1<NSFileHandle> getWriteabilityHandler();

    @Property(selector="setWriteabilityHandler:")
    public native void setWriteabilityHandler(@Block VoidBlock1<NSFileHandle> var1);

    @Property(selector="fileDescriptor")
    public native int getFileDescriptor();

    @Deprecated
    @Property(selector="offsetInFile")
    public native long getOffsetInFile();

    @Property(selector="supportsSecureCoding")
    public static native boolean supportsSecureCoding();

    public void readInBackgroundAndNotify(NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(((NSString)mode.value()).toString());
        }
        this.readInBackgroundAndNotify(list);
    }

    public void readToEndOfFileInBackgroundAndNotify(NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(((NSString)mode.value()).toString());
        }
        this.readToEndOfFileInBackgroundAndNotify(list);
    }

    public void acceptConnectionInBackgroundAndNotify(NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(((NSString)mode.value()).toString());
        }
        this.acceptConnectionInBackgroundAndNotify(list);
    }

    public void waitForDataInBackgroundAndNotify(NSRunLoopMode ... modes) {
        ArrayList<String> list = new ArrayList<String>();
        for (NSRunLoopMode mode : modes) {
            list.add(((NSString)mode.value()).toString());
        }
        this.waitForDataInBackgroundAndNotify(list);
    }

    @GlobalValue(symbol="NSFileHandleReadCompletionNotification", optional=true)
    public static native NSString ReadCompletionNotification();

    @GlobalValue(symbol="NSFileHandleReadToEndOfFileCompletionNotification", optional=true)
    public static native NSString ReadToEndOfFileCompletionNotification();

    @GlobalValue(symbol="NSFileHandleConnectionAcceptedNotification", optional=true)
    public static native NSString ConnectionAcceptedNotification();

    @GlobalValue(symbol="NSFileHandleDataAvailableNotification", optional=true)
    public static native NSString DataAvailableNotification();

    @GlobalValue(symbol="NSFileHandleNotificationDataItem", optional=true)
    protected static native NSString NotificationDataItem();

    @GlobalValue(symbol="NSFileHandleNotificationFileHandleItem", optional=true)
    protected static native NSString NotificationFileHandleItem();

    @Method(selector="initWithFileDescriptor:closeOnDealloc:")
    @Pointer
    protected native long init(int var1, boolean var2);

    @Method(selector="initWithCoder:")
    @Pointer
    protected native long init(NSCoder var1);

    public NSData readDataToEndOfFileEx() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.readDataToEndOfFileEx(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="readDataToEndOfFileAndReturnError:")
    private native NSData readDataToEndOfFileEx(NSError.NSErrorPtr var1);

    public NSData readDataUpToLengthEx(@MachineSizedUInt long length) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.readDataUpToLengthEx(length, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="readDataUpToLength:error:")
    private native NSData readDataUpToLengthEx(@MachineSizedUInt long var1, NSError.NSErrorPtr var3);

    public boolean writeDataEx(NSData data) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeDataEx(data, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeData:error:")
    private native boolean writeDataEx(NSData var1, NSError.NSErrorPtr var2);

    public boolean getOffsetEx(LongPtr offsetInFile) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.getOffsetEx(offsetInFile, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="getOffset:error:")
    private native boolean getOffsetEx(LongPtr var1, NSError.NSErrorPtr var2);

    public boolean seekToEndReturningOffsetEx(LongPtr offsetInFile) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.seekToEndReturningOffsetEx(offsetInFile, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="seekToEndReturningOffset:error:")
    private native boolean seekToEndReturningOffsetEx(LongPtr var1, NSError.NSErrorPtr var2);

    public boolean seekToOffsetEx(long offset) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.seekToOffsetEx(offset, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="seekToOffset:error:")
    private native boolean seekToOffsetEx(long var1, NSError.NSErrorPtr var3);

    public boolean truncateAtOffsetEx(long offset) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.truncateAtOffsetEx(offset, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="truncateAtOffset:error:")
    private native boolean truncateAtOffsetEx(long var1, NSError.NSErrorPtr var3);

    @Method(selector="synchronizeAndReturnError:")
    public native boolean synchronizeAndReturnError(NSError.NSErrorPtr var1);

    @Method(selector="closeAndReturnError:")
    public native boolean closeAndReturnError(NSError.NSErrorPtr var1);

    @Method(selector="fileHandleForReadingAtPath:")
    public static native NSFileHandle createForReading(String var0);

    @Method(selector="fileHandleForWritingAtPath:")
    public static native NSFileHandle createForWriting(String var0);

    @Method(selector="fileHandleForUpdatingAtPath:")
    public static native NSFileHandle createForUpdating(String var0);

    public static NSFileHandle createForReading(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSFileHandle result = NSFileHandle.createForReading(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="fileHandleForReadingFromURL:error:")
    private static native NSFileHandle createForReading(NSURL var0, NSError.NSErrorPtr var1);

    public static NSFileHandle createForWriting(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSFileHandle result = NSFileHandle.createForWriting(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="fileHandleForWritingToURL:error:")
    private static native NSFileHandle createForWriting(NSURL var0, NSError.NSErrorPtr var1);

    public static NSFileHandle createForUpdating(NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSFileHandle result = NSFileHandle.createForUpdating(url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="fileHandleForUpdatingURL:error:")
    private static native NSFileHandle createForUpdating(NSURL var0, NSError.NSErrorPtr var1);

    @Method(selector="readInBackgroundAndNotifyForModes:")
    public native void readInBackgroundAndNotify(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="readInBackgroundAndNotify")
    public native void readInBackgroundAndNotify();

    @Method(selector="readToEndOfFileInBackgroundAndNotifyForModes:")
    public native void readToEndOfFileInBackgroundAndNotify(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="readToEndOfFileInBackgroundAndNotify")
    public native void readToEndOfFileInBackgroundAndNotify();

    @Method(selector="acceptConnectionInBackgroundAndNotifyForModes:")
    public native void acceptConnectionInBackgroundAndNotify(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="acceptConnectionInBackgroundAndNotify")
    public native void acceptConnectionInBackgroundAndNotify();

    @Method(selector="waitForDataInBackgroundAndNotifyForModes:")
    public native void waitForDataInBackgroundAndNotify(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="waitForDataInBackgroundAndNotify")
    public native void waitForDataInBackgroundAndNotify();

    @Method(selector="initWithFileDescriptor:")
    @Pointer
    protected native long init(int var1);

    @Deprecated
    @Method(selector="readDataToEndOfFile")
    public native NSData readDataToEndOfFile();

    @Deprecated
    @Method(selector="readDataOfLength:")
    public native NSData readData(@MachineSizedUInt long var1);

    @Deprecated
    @Method(selector="writeData:")
    public native void writeData(NSData var1);

    @Deprecated
    @Method(selector="seekToEndOfFile")
    public native long seekToEndOfFile();

    @Deprecated
    @Method(selector="seekToFileOffset:")
    public native void seekToFileOffset(long var1);

    @Deprecated
    @Method(selector="truncateFileAtOffset:")
    public native void truncateFile(long var1);

    @Deprecated
    @Method(selector="synchronizeFile")
    public native void synchronizeFile();

    @Deprecated
    @Method(selector="closeFile")
    public native void closeFile();

    @Override
    @Method(selector="encodeWithCoder:")
    public native void encode(NSCoder var1);

    static {
        ObjCRuntime.bind(NSFileHandle.class);
    }

    public static class NSFileHandlePtr
    extends Ptr<NSFileHandle, NSFileHandlePtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeReadCompletion(NSFileHandle object, final VoidBlock2<NSFileHandle, NSData> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSFileHandle.ReadCompletionNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSData d = null;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(NSFileHandle.NotificationDataItem())) {
                        d = (NSData)data.get(NSFileHandle.NotificationDataItem());
                    }
                    block.invoke((Object)((NSFileHandle)a.getObject()), (Object)d);
                }
            });
        }

        public static NSObjectProtocol observeReadToEndOfFileCompletion(NSFileHandle object, final VoidBlock2<NSFileHandle, NSData> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSFileHandle.ReadToEndOfFileCompletionNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSData d = null;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(NSFileHandle.NotificationDataItem())) {
                        d = (NSData)data.get(NSFileHandle.NotificationDataItem());
                    }
                    block.invoke((Object)((NSFileHandle)a.getObject()), (Object)d);
                }
            });
        }

        public static NSObjectProtocol observeConnectionAccepted(NSFileHandle object, final VoidBlock2<NSFileHandle, NSFileHandle> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSFileHandle.ConnectionAcceptedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSFileHandle f = null;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(NSFileHandle.NotificationDataItem())) {
                        f = (NSFileHandle)data.get(NSFileHandle.NotificationFileHandleItem());
                    }
                    block.invoke((Object)((NSFileHandle)a.getObject()), (Object)f);
                }
            });
        }

        public static NSObjectProtocol observeDataAvailable(NSFileHandle object, final VoidBlock1<NSFileHandle> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSFileHandle.DataAvailableNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSFileHandle)a.getObject()));
                }
            });
        }
    }
}

