/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock3;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSUbiquitousKeyValueStore
extends NSObject {
    public NSUbiquitousKeyValueStore() {
    }

    protected NSUbiquitousKeyValueStore(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSUbiquitousKeyValueStore(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="defaultStore")
    public static native NSUbiquitousKeyValueStore getDefaultStore();

    @Property(selector="dictionaryRepresentation")
    public native NSDictionary<NSString, ?> asDictionary();

    public void put(String key, NSObject object) {
        this.setObject(object, key);
    }

    public void put(String key, String string) {
        this.setString(string, key);
    }

    public void put(String key, NSData data) {
        this.setData(data, key);
    }

    public void put(String key, NSArray<?> array) {
        this.setArray(array, key);
    }

    public void put(String key, NSDictionary<NSString, ?> dictionary) {
        this.setDictionary(dictionary, key);
    }

    public void put(String key, long value) {
        this.setLongLong(value, key);
    }

    public void put(String key, double value) {
        this.setDouble(value, key);
    }

    public void put(String key, boolean value) {
        this.setBool(value, key);
    }

    public Map<String, ?> asMap() {
        return this.asDictionary().asStringMap();
    }

    @GlobalValue(symbol="NSUbiquitousKeyValueStoreDidChangeExternallyNotification", optional=true)
    public static native NSString DidChangeExternallyNotification();

    @GlobalValue(symbol="NSUbiquitousKeyValueStoreChangeReasonKey", optional=true)
    protected static native NSString ChangeReasonKey();

    @GlobalValue(symbol="NSUbiquitousKeyValueStoreChangedKeysKey", optional=true)
    protected static native NSString ChangedKeysKey();

    @Method(selector="objectForKey:")
    public native NSObject get(String var1);

    @Method(selector="setObject:forKey:")
    protected native void setObject(NSObject var1, String var2);

    @Method(selector="removeObjectForKey:")
    public native void remove(String var1);

    @Method(selector="stringForKey:")
    public native String getString(String var1);

    @Method(selector="arrayForKey:")
    public native NSArray<?> getArray(String var1);

    @Method(selector="dictionaryForKey:")
    public native NSDictionary<NSString, ?> getDictionary(String var1);

    @Method(selector="dataForKey:")
    public native NSData getData(String var1);

    @Method(selector="longLongForKey:")
    public native long getLong(String var1);

    @Method(selector="doubleForKey:")
    public native double getDouble(String var1);

    @Method(selector="boolForKey:")
    public native boolean getBoolean(String var1);

    @Method(selector="setString:forKey:")
    protected native void setString(String var1, String var2);

    @Method(selector="setData:forKey:")
    protected native void setData(NSData var1, String var2);

    @Method(selector="setArray:forKey:")
    protected native void setArray(NSArray<?> var1, String var2);

    @Method(selector="setDictionary:forKey:")
    protected native void setDictionary(NSDictionary<NSString, ?> var1, String var2);

    @Method(selector="setLongLong:forKey:")
    protected native void setLongLong(long var1, String var3);

    @Method(selector="setDouble:forKey:")
    protected native void setDouble(double var1, String var3);

    @Method(selector="setBool:forKey:")
    protected native void setBool(boolean var1, String var2);

    @Method(selector="synchronize")
    public native boolean synchronize();

    static {
        ObjCRuntime.bind(NSUbiquitousKeyValueStore.class);
    }

    public static class NSUbiquitousKeyValueStorePtr
    extends Ptr<NSUbiquitousKeyValueStore, NSUbiquitousKeyValueStorePtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeDidChangeExternally(NSUbiquitousKeyValueStore object, final VoidBlock3<NSUbiquitousKeyValueStore, String, List<String>> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUbiquitousKeyValueStore.DidChangeExternallyNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSObject val;
                    String reason = null;
                    List<String> keys = null;
                    NSDictionary<?, ?> data = a.getUserInfo();
                    if (data.containsKey(NSUbiquitousKeyValueStore.ChangeReasonKey())) {
                        val = (NSString)data.get(NSUbiquitousKeyValueStore.ChangeReasonKey());
                        reason = ((NSString)val).toString();
                    }
                    if (data.containsKey(NSUbiquitousKeyValueStore.ChangedKeysKey())) {
                        val = (NSArray)data.get(NSUbiquitousKeyValueStore.ChangedKeysKey());
                        keys = ((NSArray)val).asStringList();
                    }
                    block.invoke((Object)((NSUbiquitousKeyValueStore)a.getObject()), (Object)reason, keys);
                }
            });
        }
    }
}

