/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSUserDefaultsDomain;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSUserDefaults
extends NSObject {
    public NSUserDefaults() {
    }

    protected NSUserDefaults(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSUserDefaults(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="standardUserDefaults")
    public static native NSUserDefaults getStandardUserDefaults();

    @Property(selector="volatileDomainNames")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getVolatileDomainNames();

    public int getInt(String defaultName) {
        return (int)this.getLong(defaultName);
    }

    public void put(String defaultName, NSObject value) {
        this.setObject(value, defaultName);
    }

    public void put(String defaultName, String value) {
        this.setObject(new NSString(value), defaultName);
    }

    public void put(String defaultName, int value) {
        this.setInteger(value, defaultName);
    }

    public void put(String defaultName, long value) {
        this.setInteger(value, defaultName);
    }

    public void put(String defaultName, float value) {
        this.setFloat(value, defaultName);
    }

    public void put(String defaultName, double value) {
        this.setDouble(value, defaultName);
    }

    public void put(String defaultName, boolean value) {
        this.setBool(value, defaultName);
    }

    public void put(String defaultName, NSURL url) {
        this.setURL(url, defaultName);
    }

    public void put(String defaultName, List<String> strings) {
        this.put(defaultName, NSArray.fromStrings(strings));
    }

    public void setVolatileDomain(String domainName, NSDictionary<NSString, ?> domain) {
        this.setVolatileDomain(domain, domainName);
    }

    public void setVolatileDomain(NSUserDefaultsDomain domainName, NSDictionary<NSString, ?> domain) {
        this.setVolatileDomain(domain, ((NSString)domainName.value()).toString());
    }

    public void setPersistentDomain(String domainName, NSDictionary<NSString, ?> domain) {
        this.setPersistentDomain(domain, domainName);
    }

    public void setPersistentDomain(NSUserDefaultsDomain domainName, NSDictionary<NSString, ?> domain) {
        this.setPersistentDomain(domain, ((NSString)domainName.value()).toString());
    }

    public NSDictionary<NSString, ?> getVolatileDomain(NSUserDefaultsDomain domainName) {
        return this.getVolatileDomain(((NSString)domainName.value()).toString());
    }

    public void removeVolatileDomain(NSUserDefaultsDomain domainName) {
        this.removeVolatileDomain(((NSString)domainName.value()).toString());
    }

    public NSDictionary<NSString, ?> getPersistentDomain(NSUserDefaultsDomain domainName) {
        return this.getPersistentDomain(((NSString)domainName.value()).toString());
    }

    public void removePersistentDomain(NSUserDefaultsDomain domainName) {
        this.removePersistentDomain(((NSString)domainName.value()).toString());
    }

    public boolean isObjectForced(String key, NSUserDefaultsDomain domain) {
        return this.isObjectForced(key, ((NSString)domain.value()).toString());
    }

    @GlobalValue(symbol="NSUserDefaultsSizeLimitExceededNotification", optional=true)
    public static native NSString SizeLimitExceededNotification();

    @GlobalValue(symbol="NSUbiquitousUserDefaultsNoCloudAccountNotification", optional=true)
    public static native NSString NoCloudAccountNotification();

    @GlobalValue(symbol="NSUbiquitousUserDefaultsDidChangeAccountsNotification", optional=true)
    public static native NSString DidChangeAccountsNotification();

    @GlobalValue(symbol="NSUbiquitousUserDefaultsCompletedInitialSyncNotification", optional=true)
    public static native NSString CompletedInitialSyncNotification();

    @GlobalValue(symbol="NSUserDefaultsDidChangeNotification", optional=true)
    public static native NSString DidChangeNotification();

    @Method(selector="objectForKey:")
    public native NSObject get(String var1);

    @Method(selector="setObject:forKey:")
    protected native void setObject(NSObject var1, String var2);

    @Method(selector="removeObjectForKey:")
    public native void remove(String var1);

    @Method(selector="stringForKey:")
    public native String getString(String var1);

    @Method(selector="arrayForKey:")
    public native NSArray<?> getArray(String var1);

    @Method(selector="dictionaryForKey:")
    public native NSDictionary<NSString, ?> getDictionary(String var1);

    @Method(selector="dataForKey:")
    public native NSData getData(String var1);

    @Method(selector="stringArrayForKey:")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getStringArray(String var1);

    @Method(selector="integerForKey:")
    @MachineSizedSInt
    public native long getLong(String var1);

    @Method(selector="floatForKey:")
    public native float getFloat(String var1);

    @Method(selector="doubleForKey:")
    public native double getDouble(String var1);

    @Method(selector="boolForKey:")
    public native boolean getBoolean(String var1);

    @Method(selector="URLForKey:")
    public native NSURL getURL(String var1);

    @Method(selector="setInteger:forKey:")
    protected native void setInteger(@MachineSizedSInt long var1, String var3);

    @Method(selector="setFloat:forKey:")
    protected native void setFloat(float var1, String var2);

    @Method(selector="setDouble:forKey:")
    protected native void setDouble(double var1, String var3);

    @Method(selector="setBool:forKey:")
    protected native void setBool(boolean var1, String var2);

    @Method(selector="setURL:forKey:")
    protected native void setURL(NSURL var1, String var2);

    @Method(selector="registerDefaults:")
    public native void registerDefaults(NSDictionary<NSString, ?> var1);

    @Method(selector="addSuiteNamed:")
    public native void addSuite(String var1);

    @Method(selector="removeSuiteNamed:")
    public native void removeSuite(String var1);

    @Method(selector="dictionaryRepresentation")
    public native NSDictionary<NSString, ?> asDictionary();

    @Method(selector="volatileDomainForName:")
    public native NSDictionary<NSString, ?> getVolatileDomain(String var1);

    @Method(selector="setVolatileDomain:forName:")
    protected native void setVolatileDomain(NSDictionary<NSString, ?> var1, String var2);

    @Method(selector="removeVolatileDomainForName:")
    public native void removeVolatileDomain(String var1);

    @Deprecated
    @Method(selector="persistentDomainNames")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getPersistentDomainNames();

    @Method(selector="persistentDomainForName:")
    public native NSDictionary<NSString, ?> getPersistentDomain(String var1);

    @Method(selector="setPersistentDomain:forName:")
    protected native void setPersistentDomain(NSDictionary<NSString, ?> var1, String var2);

    @Method(selector="removePersistentDomainForName:")
    public native void removePersistentDomain(String var1);

    @Method(selector="synchronize")
    public native boolean synchronize();

    @Method(selector="objectIsForcedForKey:")
    public native boolean isObjectForced(String var1);

    @Method(selector="objectIsForcedForKey:inDomain:")
    public native boolean isObjectForced(String var1, String var2);

    @Method(selector="resetStandardUserDefaults")
    public static native void resetStandardUserDefaults();

    static {
        ObjCRuntime.bind(NSUserDefaults.class);
    }

    public static class NSUserDefaultsPtr
    extends Ptr<NSUserDefaults, NSUserDefaultsPtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeDidChange(NSUserDefaults object, final VoidBlock1<NSUserDefaults> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSUserDefaults.DidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSUserDefaults)a.getObject()));
                }
            });
        }
    }
}

