/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.nio.FloatBuffer;
import org.robovm.apple.glkit.GLKMatrix2;
import org.robovm.apple.glkit.GLKQuaternion;
import org.robovm.apple.glkit.GLKVector3;
import org.robovm.apple.glkit.GLKVector4;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="GLKit")
public class GLKMatrix3
extends Struct<GLKMatrix3> {
    public GLKMatrix3() {
    }

    public GLKMatrix3(FloatBuffer m) {
        this.setM(m);
    }

    @StructMember(value=0)
    @Array(value={9})
    public native FloatBuffer getM();

    @StructMember(value=0)
    public native GLKMatrix3 setM(@Array(value={9}) FloatBuffer var1);

    @GlobalValue(symbol="GLKMatrix3Identity", optional=true)
    @ByVal
    public static native GLKMatrix3 Identity();

    public GLKMatrix3 invert(BooleanPtr isInvertible) {
        return GLKMatrix3.invert(this, isInvertible);
    }

    @Bridge(symbol="GLKMatrix3Invert", optional=true)
    @ByVal
    private static native GLKMatrix3 invert(@ByVal GLKMatrix3 var0, BooleanPtr var1);

    public GLKMatrix3 invertAndTranspose(BooleanPtr isInvertible) {
        return GLKMatrix3.invertAndTranspose(this, isInvertible);
    }

    @Bridge(symbol="GLKMatrix3InvertAndTranspose", optional=true)
    @ByVal
    private static native GLKMatrix3 invertAndTranspose(@ByVal GLKMatrix3 var0, BooleanPtr var1);

    public static GLKMatrix3 create(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float[] m = new float[]{m00, m01, m02, m10, m11, m12, m20, m21, m22};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createAndTranspose(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        float[] m = new float[]{m00, m10, m20, m01, m11, m21, m02, m12, m22};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 create(float[] values) {
        return new GLKMatrix3(FloatBuffer.wrap(values));
    }

    public static GLKMatrix3 createAndTranspose(float[] values) {
        float[] m = new float[]{values[0], values[3], values[6], values[1], values[4], values[7], values[2], values[5], values[8]};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createWithRows(GLKVector3 row0, GLKVector3 row1, GLKVector3 row2) {
        FloatBuffer row0_v = row0.getV();
        FloatBuffer row1_v = row1.getV();
        FloatBuffer row2_v = row2.getV();
        float[] m = new float[]{row0_v.get(0), row1_v.get(0), row2_v.get(0), row0_v.get(1), row1_v.get(1), row2_v.get(1), row0_v.get(2), row1_v.get(2), row2_v.get(2)};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createWithColumns(GLKVector3 column0, GLKVector3 column1, GLKVector3 column2) {
        FloatBuffer column0_v = column0.getV();
        FloatBuffer column1_v = column1.getV();
        FloatBuffer column2_v = column2.getV();
        float[] m = new float[]{column0_v.get(0), column0_v.get(1), column0_v.get(2), column1_v.get(0), column1_v.get(1), column1_v.get(2), column2_v.get(0), column2_v.get(1), column2_v.get(2)};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 create(GLKQuaternion quaternion) {
        quaternion = quaternion.normalize();
        FloatBuffer quaternion_q = quaternion.getQ();
        float x = quaternion_q.get(0);
        float y = quaternion_q.get(1);
        float z = quaternion_q.get(2);
        float w = quaternion_q.get(3);
        float _2x = x + x;
        float _2y = y + y;
        float _2z = z + z;
        float _2w = w + w;
        float[] m = new float[]{1.0f - _2y * y - _2z * z, _2x * y + _2w * z, _2x * z - _2w * y, _2x * y - _2w * z, 1.0f - _2x * x - _2z * z, _2y * z + _2w * x, _2x * z + _2w * y, _2y * z - _2w * x, 1.0f - _2x * x - _2y * y};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createScale(float sx, float sy, float sz) {
        GLKMatrix3 m = GLKMatrix3.Identity();
        FloatBuffer m_m = m.getM();
        m_m.put(0, sx);
        m_m.put(4, sy);
        m_m.put(8, sz);
        return m;
    }

    public static GLKMatrix3 createRotation(float radians, float x, float y, float z) {
        GLKVector3 v = GLKVector3.create(x, y, z).normalize();
        float cos = (float)Math.cos(radians);
        float cosp = 1.0f - cos;
        float sin = (float)Math.sin(radians);
        FloatBuffer v_v = v.getV();
        float[] m = new float[]{cos + cosp * v_v.get(0) * v_v.get(0), cosp * v_v.get(0) * v_v.get(1) + v_v.get(2) * sin, cosp * v_v.get(0) * v_v.get(2) - v_v.get(1) * sin, cosp * v_v.get(0) * v_v.get(1) - v_v.get(2) * sin, cos + cosp * v_v.get(1) * v_v.get(1), cosp * v_v.get(1) * v_v.get(2) + v_v.get(0) * sin, cosp * v_v.get(0) * v_v.get(2) + v_v.get(1) * sin, cosp * v_v.get(1) * v_v.get(2) - v_v.get(0) * sin, cos + cosp * v_v.get(2) * v_v.get(2)};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createXRotation(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] m = new float[]{1.0f, 0.0f, 0.0f, 0.0f, cos, sin, 0.0f, -sin, cos};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createYRotation(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] m = new float[]{cos, 0.0f, -sin, 0.0f, 1.0f, 0.0f, sin, 0.0f, cos};
        return GLKMatrix3.create(m);
    }

    public static GLKMatrix3 createZRotation(float radians) {
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        float[] m = new float[]{cos, sin, 0.0f, -sin, cos, 0.0f, 0.0f, 0.0f, 1.0f};
        return GLKMatrix3.create(m);
    }

    public GLKMatrix2 getMatrix2() {
        FloatBuffer matrix_m = this.getM();
        float[] m = new float[]{matrix_m.get(0), matrix_m.get(1), matrix_m.get(3), matrix_m.get(4)};
        return GLKMatrix2.create(m);
    }

    public GLKVector3 getRow(int row) {
        FloatBuffer matrix_m = this.getM();
        float[] v = new float[]{matrix_m.get(row), matrix_m.get(3 + row), matrix_m.get(6 + row)};
        return GLKVector3.create(v);
    }

    public GLKVector3 getColumn(int column) {
        FloatBuffer matrix_m = this.getM();
        float[] v = new float[]{matrix_m.get(column * 3), matrix_m.get(column * 3 + 1), matrix_m.get(column * 3 + 2)};
        return GLKVector3.create(v);
    }

    public GLKMatrix3 setRow(int row, GLKVector3 vector) {
        GLKMatrix3 matrix = (GLKMatrix3)this.copy();
        FloatBuffer vector_v = vector.getV();
        FloatBuffer matrix_m = this.getM();
        matrix_m.put(row, vector_v.get(0));
        matrix_m.put(row + 3, vector_v.get(1));
        matrix_m.put(row + 6, vector_v.get(2));
        return matrix;
    }

    public GLKMatrix3 setColumn(int column, GLKVector3 vector) {
        GLKMatrix3 matrix = (GLKMatrix3)this.copy();
        FloatBuffer vector_v = vector.getV();
        FloatBuffer matrix_m = this.getM();
        matrix_m.put(column * 3, vector_v.get(0));
        matrix_m.put(column * 3 + 1, vector_v.get(1));
        matrix_m.put(column * 3 + 2, vector_v.get(2));
        return matrix;
    }

    public GLKMatrix3 transpose() {
        FloatBuffer matrix_m = this.getM();
        float[] m = new float[]{matrix_m.get(0), matrix_m.get(3), matrix_m.get(6), matrix_m.get(1), matrix_m.get(4), matrix_m.get(7), matrix_m.get(2), matrix_m.get(5), matrix_m.get(8)};
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 multiply(GLKMatrix3 matrixRight) {
        return GLKMatrix3.multiply(this, matrixRight);
    }

    public static GLKMatrix3 multiply(GLKMatrix3 matrixLeft, GLKMatrix3 matrixRight) {
        float[] m = new float[9];
        float[] matrixLeft_m = new float[9];
        float[] matrixRight_m = new float[9];
        matrixLeft.getM().get(matrixLeft_m);
        matrixRight.getM().get(matrixRight_m);
        m[0] = matrixLeft_m[0] * matrixRight_m[0] + matrixLeft_m[3] * matrixRight_m[1] + matrixLeft_m[6] * matrixRight_m[2];
        m[3] = matrixLeft_m[0] * matrixRight_m[3] + matrixLeft_m[3] * matrixRight_m[4] + matrixLeft_m[6] * matrixRight_m[5];
        m[6] = matrixLeft_m[0] * matrixRight_m[6] + matrixLeft_m[3] * matrixRight_m[7] + matrixLeft_m[6] * matrixRight_m[8];
        m[1] = matrixLeft_m[1] * matrixRight_m[0] + matrixLeft_m[4] * matrixRight_m[1] + matrixLeft_m[7] * matrixRight_m[2];
        m[4] = matrixLeft_m[1] * matrixRight_m[3] + matrixLeft_m[4] * matrixRight_m[4] + matrixLeft_m[7] * matrixRight_m[5];
        m[7] = matrixLeft_m[1] * matrixRight_m[6] + matrixLeft_m[4] * matrixRight_m[7] + matrixLeft_m[7] * matrixRight_m[8];
        m[2] = matrixLeft_m[2] * matrixRight_m[0] + matrixLeft_m[5] * matrixRight_m[1] + matrixLeft_m[8] * matrixRight_m[2];
        m[5] = matrixLeft_m[2] * matrixRight_m[3] + matrixLeft_m[5] * matrixRight_m[4] + matrixLeft_m[8] * matrixRight_m[5];
        m[8] = matrixLeft_m[2] * matrixRight_m[6] + matrixLeft_m[5] * matrixRight_m[7] + matrixLeft_m[8] * matrixRight_m[8];
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 add(GLKMatrix3 matrixRight) {
        return GLKMatrix3.add(this, matrixRight);
    }

    public static GLKMatrix3 add(GLKMatrix3 matrixLeft, GLKMatrix3 matrixRight) {
        float[] m = new float[9];
        float[] matrixLeft_m = new float[9];
        float[] matrixRight_m = new float[9];
        matrixLeft.getM().get(matrixLeft_m);
        matrixRight.getM().get(matrixRight_m);
        m[0] = matrixLeft_m[0] + matrixRight_m[0];
        m[1] = matrixLeft_m[1] + matrixRight_m[1];
        m[2] = matrixLeft_m[2] + matrixRight_m[2];
        m[3] = matrixLeft_m[3] + matrixRight_m[3];
        m[4] = matrixLeft_m[4] + matrixRight_m[4];
        m[5] = matrixLeft_m[5] + matrixRight_m[5];
        m[6] = matrixLeft_m[6] + matrixRight_m[6];
        m[7] = matrixLeft_m[7] + matrixRight_m[7];
        m[8] = matrixLeft_m[8] + matrixRight_m[8];
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 subtract(GLKMatrix3 matrixRight) {
        return GLKMatrix3.subtract(this, matrixRight);
    }

    public static GLKMatrix3 subtract(GLKMatrix3 matrixLeft, GLKMatrix3 matrixRight) {
        float[] m = new float[9];
        float[] matrixLeft_m = new float[9];
        float[] matrixRight_m = new float[9];
        matrixLeft.getM().get(matrixLeft_m);
        matrixRight.getM().get(matrixRight_m);
        m[0] = matrixLeft_m[0] - matrixRight_m[0];
        m[1] = matrixLeft_m[1] - matrixRight_m[1];
        m[2] = matrixLeft_m[2] - matrixRight_m[2];
        m[3] = matrixLeft_m[3] - matrixRight_m[3];
        m[4] = matrixLeft_m[4] - matrixRight_m[4];
        m[5] = matrixLeft_m[5] - matrixRight_m[5];
        m[6] = matrixLeft_m[6] - matrixRight_m[6];
        m[7] = matrixLeft_m[7] - matrixRight_m[7];
        m[8] = matrixLeft_m[8] - matrixRight_m[8];
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 scale(float sx, float sy, float sz) {
        float[] matrix_m = new float[9];
        this.getM().get(matrix_m);
        float[] m = new float[]{matrix_m[0] * sx, matrix_m[1] * sx, matrix_m[2] * sx, matrix_m[3] * sy, matrix_m[4] * sy, matrix_m[5] * sy, matrix_m[6] * sz, matrix_m[7] * sz, matrix_m[8] * sz};
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 scale(GLKVector3 scaleVector) {
        float[] matrix_m = new float[9];
        float[] scaleVector_v = new float[3];
        this.getM().get(matrix_m);
        scaleVector.getV().get(scaleVector_v);
        float[] m = new float[]{matrix_m[0] * scaleVector_v[0], matrix_m[1] * scaleVector_v[0], matrix_m[2] * scaleVector_v[0], matrix_m[3] * scaleVector_v[1], matrix_m[4] * scaleVector_v[1], matrix_m[5] * scaleVector_v[1], matrix_m[6] * scaleVector_v[2], matrix_m[7] * scaleVector_v[2], matrix_m[8] * scaleVector_v[2]};
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 scale(GLKVector4 scaleVector) {
        float[] matrix_m = new float[9];
        float[] scaleVector_v = new float[4];
        this.getM().get(matrix_m);
        scaleVector.getV().get(scaleVector_v);
        float[] m = new float[]{matrix_m[0] * scaleVector_v[0], matrix_m[1] * scaleVector_v[0], matrix_m[2] * scaleVector_v[0], matrix_m[3] * scaleVector_v[1], matrix_m[4] * scaleVector_v[1], matrix_m[5] * scaleVector_v[1], matrix_m[6] * scaleVector_v[2], matrix_m[7] * scaleVector_v[2], matrix_m[8] * scaleVector_v[2]};
        return GLKMatrix3.create(m);
    }

    public GLKMatrix3 rotate(float radians, float x, float y, float z) {
        GLKMatrix3 rm = GLKMatrix3.createRotation(radians, x, y, z);
        return this.multiply(rm);
    }

    public GLKMatrix3 rotate(float radians, GLKVector3 axisVector) {
        GLKMatrix3 rm = GLKMatrix3.createRotation(radians, axisVector.getV().get(0), axisVector.getV().get(1), axisVector.getV().get(2));
        return this.multiply(rm);
    }

    public GLKMatrix3 rotate(float radians, GLKVector4 axisVector) {
        GLKMatrix3 rm = GLKMatrix3.createRotation(radians, axisVector.getV().get(0), axisVector.getV().get(1), axisVector.getV().get(2));
        return this.multiply(rm);
    }

    public GLKMatrix3 rotateX(float radians) {
        GLKMatrix3 rm = GLKMatrix3.createXRotation(radians);
        return this.multiply(rm);
    }

    public GLKMatrix3 rotateY(float radians) {
        GLKMatrix3 rm = GLKMatrix3.createYRotation(radians);
        return this.multiply(rm);
    }

    public GLKMatrix3 rotateZ(float radians) {
        GLKMatrix3 rm = GLKMatrix3.createZRotation(radians);
        return this.multiply(rm);
    }

    public GLKVector3 multiplyVector3(GLKVector3 vectorRight) {
        float[] m = new float[9];
        float[] matrixLeft_m = new float[9];
        float[] vectorRight_v = new float[3];
        this.getM().get(matrixLeft_m);
        vectorRight.getV().get(vectorRight_v);
        float[] v = new float[]{matrixLeft_m[0] * vectorRight_v[0] + matrixLeft_m[3] * vectorRight_v[1] + matrixLeft_m[6] * vectorRight_v[2], matrixLeft_m[1] * vectorRight_v[0] + matrixLeft_m[4] * vectorRight_v[1] + matrixLeft_m[7] * vectorRight_v[2], matrixLeft_m[2] * vectorRight_v[0] + matrixLeft_m[5] * vectorRight_v[1] + matrixLeft_m[8] * vectorRight_v[2]};
        return GLKVector3.create(v);
    }

    public void multiplyVector3Array(GLKVector3 vectors, long vectorCount) {
        GLKVector3 v = vectors;
        int i = 0;
        while ((long)i < vectorCount) {
            v.update(this.multiplyVector3(v));
            v = (GLKVector3)v.next();
            ++i;
        }
    }

    static {
        Bro.bind(GLKMatrix3.class);
    }

    public static class GLKMatrix3Ptr
    extends Ptr<GLKMatrix3, GLKMatrix3Ptr> {
    }
}

