/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.security.SecKeyOperationType;
import org.robovm.apple.security.SecKeyParameters;
import org.robovm.apple.security.SecPadding;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Security")
public class SecKey
extends CFType {
    protected SecKey() {
    }

    public static void generatePair(SecKeyParameters parameters, SecKeyPtr publicKey, SecKeyPtr privateKey) throws OSStatusException {
        OSStatus status = SecKey.generatePair0(parameters, publicKey, privateKey);
        OSStatusException.throwIfNecessary(status);
    }

    public static void generatePair(SecKeyParameters parameters, VoidBlock2<SecKey, SecKey> result) throws OSStatusException {
        SecKeyPtr publicPtr = new SecKeyPtr();
        SecKeyPtr privatePtr = new SecKeyPtr();
        SecKey.generatePair(parameters, publicPtr, privatePtr);
        result.invoke((Object)((SecKey)publicPtr.get()), (Object)((SecKey)privatePtr.get()));
    }

    public byte[] rawSign(SecPadding padding, byte[] dataToSign) throws OSStatusException {
        if (dataToSign == null) {
            throw new NullPointerException("dataToSign");
        }
        BytePtr sigPtr = new BytePtr();
        MachineSizedUIntPtr sigLenPtr = new MachineSizedUIntPtr();
        OSStatus status = this.rawSign0(padding, VM.getArrayValuesAddress((Object)dataToSign), dataToSign.length, sigPtr, sigLenPtr);
        OSStatusException.throwIfNecessary(status);
        return sigPtr.toByteArray((int)sigLenPtr.get());
    }

    public void rawVerify(SecPadding padding, byte[] signedData, byte[] sig) throws OSStatusException {
        if (signedData == null) {
            throw new NullPointerException("signedData");
        }
        if (sig == null) {
            throw new NullPointerException("sig");
        }
        OSStatus status = this.rawVerify0(padding, VM.getArrayValuesAddress((Object)signedData), signedData.length, VM.getArrayValuesAddress((Object)sig), sig.length);
        OSStatusException.throwIfNecessary(status);
    }

    public byte[] encrypt(SecPadding padding, byte[] plainText) throws OSStatusException {
        if (plainText == null) {
            throw new NullPointerException("plainText");
        }
        BytePtr cipherTextPtr = new BytePtr();
        MachineSizedUIntPtr cipherTextLenPtr = new MachineSizedUIntPtr();
        OSStatus status = this.encrypt0(padding, VM.getArrayValuesAddress((Object)plainText), plainText.length, cipherTextPtr, cipherTextLenPtr);
        OSStatusException.throwIfNecessary(status);
        return cipherTextPtr.toByteArray((int)cipherTextLenPtr.get());
    }

    public byte[] decrypt(SecPadding padding, byte[] cipherText) throws OSStatusException {
        if (cipherText == null) {
            throw new NullPointerException("cipherText");
        }
        BytePtr plainTextPtr = new BytePtr();
        MachineSizedUIntPtr plainTextLenPtr = new MachineSizedUIntPtr();
        OSStatus status = this.decrypt0(padding, VM.getArrayValuesAddress((Object)cipherText), cipherText.length, plainTextPtr, plainTextLenPtr);
        OSStatusException.throwIfNecessary(status);
        return plainTextPtr.toByteArray((int)plainTextLenPtr.get());
    }

    @Bridge(symbol="SecKeyGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Deprecated
    @Bridge(symbol="SecKeyGeneratePair", optional=true)
    protected static native OSStatus generatePair0(SecKeyParameters var0, SecKeyPtr var1, SecKeyPtr var2);

    @Deprecated
    @Bridge(symbol="SecKeyRawSign", optional=true)
    protected native OSStatus rawSign0(SecPadding var1, @Pointer long var2, @MachineSizedUInt long var4, BytePtr var6, MachineSizedUIntPtr var7);

    @Deprecated
    @Bridge(symbol="SecKeyRawVerify", optional=true)
    protected native OSStatus rawVerify0(SecPadding var1, @Pointer long var2, @MachineSizedUInt long var4, @Pointer long var6, @MachineSizedUInt long var8);

    @Deprecated
    @Bridge(symbol="SecKeyEncrypt", optional=true)
    protected native OSStatus encrypt0(SecPadding var1, @Pointer long var2, @MachineSizedUInt long var4, BytePtr var6, MachineSizedUIntPtr var7);

    @Deprecated
    @Bridge(symbol="SecKeyDecrypt", optional=true)
    protected native OSStatus decrypt0(SecPadding var1, @Pointer long var2, @MachineSizedUInt long var4, BytePtr var6, MachineSizedUIntPtr var7);

    public static SecKey createRandomKey(NSDictionary parameters) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        SecKey result = SecKey.createRandomKey(parameters, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCreateRandomKey", optional=true)
    private static native SecKey createRandomKey(NSDictionary var0, NSError.NSErrorPtr var1);

    public static SecKey createWithData(NSData keyData, NSDictionary attributes) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        SecKey result = SecKey.createWithData(keyData, attributes, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCreateWithData", optional=true)
    private static native SecKey createWithData(NSData var0, NSDictionary var1, NSError.NSErrorPtr var2);

    @Bridge(symbol="SecKeyGetBlockSize", optional=true)
    @MachineSizedUInt
    public native long getBlockSize();

    public NSData copyExternalRepresentation() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.copyExternalRepresentation(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCopyExternalRepresentation", optional=true)
    private native NSData copyExternalRepresentation(NSError.NSErrorPtr var1);

    @Bridge(symbol="SecKeyCopyAttributes", optional=true)
    public native NSDictionary copyAttributes();

    @Bridge(symbol="SecKeyCopyPublicKey", optional=true)
    public native SecKey copyPublicKey();

    public NSData createSignature(String algorithm, NSData dataToSign) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.createSignature(algorithm, dataToSign, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCreateSignature", optional=true)
    private native NSData createSignature(String var1, NSData var2, NSError.NSErrorPtr var3);

    public boolean verifySignature(String algorithm, NSData signedData, NSData signature) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.verifySignature(algorithm, signedData, signature, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyVerifySignature", optional=true)
    private native boolean verifySignature(String var1, NSData var2, NSData var3, NSError.NSErrorPtr var4);

    public NSData createEncryptedData(String algorithm, NSData plaintext) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.createEncryptedData(algorithm, plaintext, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCreateEncryptedData", optional=true)
    private native NSData createEncryptedData(String var1, NSData var2, NSError.NSErrorPtr var3);

    public NSData createDecryptedData(String algorithm, NSData ciphertext) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.createDecryptedData(algorithm, ciphertext, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCreateDecryptedData", optional=true)
    private native NSData createDecryptedData(String var1, NSData var2, NSError.NSErrorPtr var3);

    public NSData copyKeyExchangeResult(String algorithm, SecKey publicKey, NSDictionary parameters) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSData result = this.copyKeyExchangeResult(algorithm, publicKey, parameters, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="SecKeyCopyKeyExchangeResult", optional=true)
    private native NSData copyKeyExchangeResult(String var1, SecKey var2, NSDictionary var3, NSError.NSErrorPtr var4);

    @Bridge(symbol="SecKeyIsAlgorithmSupported", optional=true)
    public native boolean isAlgorithmSupported(SecKeyOperationType var1, String var2);

    static {
        Bro.bind(SecKey.class);
    }

    public static class SecKeyPtr
    extends Ptr<SecKey, SecKeyPtr> {
    }
}

