/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.security;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFDictionaryWrapper;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSData;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="Security")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class SecValue
extends CFDictionaryWrapper {
    SecValue(CFDictionary data) {
        super(data);
    }

    public SecValue() {
    }

    public boolean has(CFType key) {
        return this.data.containsKey(key);
    }

    public <T extends NativeObject> T get(CFType key, Class<T> type) {
        if (this.has(key)) {
            return this.data.get(key, type);
        }
        return null;
    }

    public SecValue set(CFType key, NativeObject value) {
        this.data.put(key, value);
        return this;
    }

    public NSData getData() {
        if (this.has(Keys.Data())) {
            NSData val = this.get(Keys.Data(), NSData.class);
            return val;
        }
        return null;
    }

    public SecValue setData(NSData data) {
        this.set(Keys.Data(), (NativeObject)data);
        return this;
    }

    public CFType getRef() {
        if (this.has(Keys.Ref())) {
            CFType val = this.get(Keys.Ref(), CFType.class);
            return val;
        }
        return null;
    }

    public SecValue setRef(CFType ref) {
        this.set(Keys.Ref(), ref);
        return this;
    }

    public NSData getPersistentRef() {
        if (this.has(Keys.PersistentRef())) {
            NSData val = this.get(Keys.PersistentRef(), NSData.class);
            return val;
        }
        return null;
    }

    public SecValue setPersistentRef(NSData persistentRef) {
        this.set(Keys.PersistentRef(), (NativeObject)persistentRef);
        return this;
    }

    @Library(value="Security")
    public static class Keys {
        @GlobalValue(symbol="kSecValueData", optional=true)
        public static native CFType Data();

        @GlobalValue(symbol="kSecValueRef", optional=true)
        public static native CFType Ref();

        @GlobalValue(symbol="kSecValuePersistentRef", optional=true)
        public static native CFType PersistentRef();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<SecValue> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<SecValue> list = new ArrayList<SecValue>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(new SecValue(o.get(i, CFDictionary.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<SecValue> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (SecValue i : l) {
                ((CFArray)array).add(i.getDictionary());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static SecValue toObject(Class<SecValue> cls, long handle, long flags) {
            CFDictionary o = (CFDictionary)CFType.Marshaler.toObject(CFDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new SecValue(o);
        }

        @MarshalsPointer
        public static long toNative(SecValue o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative(o.data, flags);
        }
    }
}

