/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.soundanalysis;

import org.robovm.apple.avfoundation.AVAudioBuffer;
import org.robovm.apple.avfoundation.AVAudioFormat;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.soundanalysis.SNRequest;
import org.robovm.apple.soundanalysis.SNResultsObserving;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="SoundAnalysis")
@NativeClass
public class SNAudioStreamAnalyzer
extends NSObject {
    protected SNAudioStreamAnalyzer() {
    }

    protected SNAudioStreamAnalyzer(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected SNAudioStreamAnalyzer(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initWithFormat:")
    public SNAudioStreamAnalyzer(AVAudioFormat format) {
        super(null);
        this.initObject(this.init(format));
    }

    @Method(selector="initWithFormat:")
    @Pointer
    protected native long init(AVAudioFormat var1);

    public boolean addRequest(SNRequest request, SNResultsObserving observer) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.addRequest(request, observer, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="addRequest:withObserver:error:")
    private native boolean addRequest(SNRequest var1, SNResultsObserving var2, NSError.NSErrorPtr var3);

    @Method(selector="removeRequest:")
    public native void removeRequest(SNRequest var1);

    @Method(selector="removeAllRequests")
    public native void removeAllRequests();

    @Method(selector="analyzeAudioBuffer:atAudioFramePosition:")
    public native void analyzeAudioBuffer(AVAudioBuffer var1, long var2);

    @Method(selector="completeAnalysis")
    public native void completeAnalysis();

    static {
        ObjCRuntime.bind(SNAudioStreamAnalyzer.class);
    }

    public static class SNAudioStreamAnalyzerPtr
    extends Ptr<SNAudioStreamAnalyzer, SNAudioStreamAnalyzerPtr> {
    }
}

