/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.UIApplicationLaunchOptionsUserActivityInfo;
import org.robovm.apple.uikit.UIApplicationShortcutItem;
import org.robovm.apple.uikit.UILocalNotification;
import org.robovm.apple.uikit.UIRemoteNotification;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="UIKit")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class UIApplicationLaunchOptions
extends NSDictionaryWrapper {
    UIApplicationLaunchOptions(NSDictionary data) {
        super(data);
    }

    public UIApplicationLaunchOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public UIApplicationLaunchOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public NSURL getURL() {
        if (this.has(Keys.URL())) {
            NSURL val = (NSURL)this.get(Keys.URL());
            return val;
        }
        return null;
    }

    public UIApplicationLaunchOptions setURL(NSURL uRL) {
        this.set(Keys.URL(), uRL);
        return this;
    }

    public String getSourceApplication() {
        if (this.has(Keys.SourceApplication())) {
            NSString val = (NSString)this.get(Keys.SourceApplication());
            return val.toString();
        }
        return null;
    }

    public UIApplicationLaunchOptions setSourceApplication(String sourceApplication) {
        this.set(Keys.SourceApplication(), new NSString(sourceApplication));
        return this;
    }

    @Deprecated
    public UILocalNotification getLocalNotification() {
        if (this.has(Keys.LocalNotification())) {
            UILocalNotification val = (UILocalNotification)this.get(Keys.LocalNotification());
            return val;
        }
        return null;
    }

    @Deprecated
    public UIApplicationLaunchOptions setLocalNotification(UILocalNotification localNotification) {
        this.set(Keys.LocalNotification(), localNotification);
        return this;
    }

    public NSObject getAnnotation() {
        if (this.has(Keys.Annotation())) {
            NSObject val = this.get(Keys.Annotation());
            return val;
        }
        return null;
    }

    public UIApplicationLaunchOptions setAnnotation(NSObject annotation) {
        this.set(Keys.Annotation(), annotation);
        return this;
    }

    public boolean isLocationStart() {
        if (this.has(Keys.Location())) {
            NSNumber val = (NSNumber)this.get(Keys.Location());
            return val.booleanValue();
        }
        return false;
    }

    public UIApplicationLaunchOptions setLocationStart(boolean locationStart) {
        this.set(Keys.Location(), NSNumber.valueOf(locationStart));
        return this;
    }

    public List<String> getNewsstandDownloadIdentifiers() {
        if (this.has(Keys.NewsstandDownloads())) {
            NSArray val = (NSArray)this.get(Keys.NewsstandDownloads());
            return val.asStringList();
        }
        return null;
    }

    public UIApplicationLaunchOptions setNewsstandDownloadIdentifiers(List<String> newsstandDownloadIdentifiers) {
        this.set(Keys.NewsstandDownloads(), NSArray.fromStrings(newsstandDownloadIdentifiers));
        return this;
    }

    public List<String> getBluetoothCentralIdentifiers() {
        if (this.has(Keys.BluetoothCentrals())) {
            NSArray val = (NSArray)this.get(Keys.BluetoothCentrals());
            return val.asStringList();
        }
        return null;
    }

    public UIApplicationLaunchOptions setBluetoothCentralIdentifiers(List<String> bluetoothCentralIdentifiers) {
        this.set(Keys.BluetoothCentrals(), NSArray.fromStrings(bluetoothCentralIdentifiers));
        return this;
    }

    public List<String> getBluetoothPeripheralIdentifiers() {
        if (this.has(Keys.BluetoothPeripherals())) {
            NSArray val = (NSArray)this.get(Keys.BluetoothPeripherals());
            return val.asStringList();
        }
        return null;
    }

    public UIApplicationLaunchOptions setBluetoothPeripheralIdentifiers(List<String> bluetoothPeripheralIdentifiers) {
        this.set(Keys.BluetoothPeripherals(), NSArray.fromStrings(bluetoothPeripheralIdentifiers));
        return this;
    }

    public UIApplicationShortcutItem getShortcutItem() {
        if (this.has(Keys.ShortcutItem())) {
            UIApplicationShortcutItem val = (UIApplicationShortcutItem)this.get(Keys.ShortcutItem());
            return val;
        }
        return null;
    }

    public UIApplicationLaunchOptions setShortcutItem(UIApplicationShortcutItem shortcutItem) {
        this.set(Keys.ShortcutItem(), shortcutItem);
        return this;
    }

    public UIApplicationLaunchOptionsUserActivityInfo getUserActivityInfo() {
        if (this.has(Keys.UserActivityDictionary())) {
            NSDictionary val = (NSDictionary)this.get(Keys.UserActivityDictionary());
            return new UIApplicationLaunchOptionsUserActivityInfo(val);
        }
        return null;
    }

    public UIApplicationLaunchOptions setUserActivityInfo(UIApplicationLaunchOptionsUserActivityInfo userActivityInfo) {
        this.set(Keys.UserActivityDictionary(), userActivityInfo.getDictionary());
        return this;
    }

    public UIRemoteNotification getRemoteNotification() {
        if (this.has(Keys.RemoteNotification())) {
            NSDictionary val = (NSDictionary)this.get(Keys.RemoteNotification());
            return new UIRemoteNotification((NSDictionary<NSString, NSObject>)val);
        }
        return null;
    }

    @Library(value="UIKit")
    public static class Keys {
        @GlobalValue(symbol="UIApplicationLaunchOptionsURLKey", optional=true)
        public static native NSString URL();

        @GlobalValue(symbol="UIApplicationLaunchOptionsSourceApplicationKey", optional=true)
        public static native NSString SourceApplication();

        @GlobalValue(symbol="UIApplicationLaunchOptionsRemoteNotificationKey", optional=true)
        public static native NSString RemoteNotification();

        @Deprecated
        @GlobalValue(symbol="UIApplicationLaunchOptionsLocalNotificationKey", optional=true)
        public static native NSString LocalNotification();

        @GlobalValue(symbol="UIApplicationLaunchOptionsAnnotationKey", optional=true)
        public static native NSString Annotation();

        @GlobalValue(symbol="UIApplicationLaunchOptionsLocationKey", optional=true)
        public static native NSString Location();

        @GlobalValue(symbol="UIApplicationLaunchOptionsNewsstandDownloadsKey", optional=true)
        public static native NSString NewsstandDownloads();

        @GlobalValue(symbol="UIApplicationLaunchOptionsBluetoothCentralsKey", optional=true)
        public static native NSString BluetoothCentrals();

        @GlobalValue(symbol="UIApplicationLaunchOptionsBluetoothPeripheralsKey", optional=true)
        public static native NSString BluetoothPeripherals();

        @GlobalValue(symbol="UIApplicationLaunchOptionsShortcutItemKey", optional=true)
        public static native NSString ShortcutItem();

        @GlobalValue(symbol="UIApplicationLaunchOptionsEventAttributionKey", optional=true)
        public static native NSString EventAttribution();

        @GlobalValue(symbol="UIApplicationLaunchOptionsUserActivityDictionaryKey", optional=true)
        public static native NSString UserActivityDictionary();

        @GlobalValue(symbol="UIApplicationLaunchOptionsCloudKitShareMetadataKey", optional=true)
        public static native NSString CloudKitShareMetadata();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<UIApplicationLaunchOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<UIApplicationLaunchOptions> list = new ArrayList<UIApplicationLaunchOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new UIApplicationLaunchOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<UIApplicationLaunchOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (UIApplicationLaunchOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static UIApplicationLaunchOptions toObject(Class<UIApplicationLaunchOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new UIApplicationLaunchOptions(o);
        }

        @MarshalsPointer
        public static long toNative(UIApplicationLaunchOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

