/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.uikit;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSIndexSet;
import org.robovm.apple.foundation.NSItemProvider;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.uikit.UIColor;
import org.robovm.apple.uikit.UIImage;
import org.robovm.apple.uikit.UIPasteboardChangedNotification;
import org.robovm.apple.uikit.UIPasteboardOptions;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="UIKit")
@NativeClass
public class UIPasteboard
extends NSObject {
    public UIPasteboard() {
    }

    protected UIPasteboard(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected UIPasteboard(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public List<Map<String, NSObject>> getItems() {
        NSArray<NSDictionary> items = this.getItems0();
        ArrayList<Map<String, NSObject>> itemList = new ArrayList<Map<String, NSObject>>();
        for (NSDictionary item : items) {
            itemList.add(item.asStringMap());
        }
        return itemList;
    }

    public void setItems(List<Map<String, NSObject>> items) {
        NSMutableArray<NSDictionary> itemArray = new NSMutableArray<NSDictionary>();
        for (Map<String, NSObject> item : items) {
            itemArray.add(NSDictionary.fromStringMap(item));
        }
        this.setItems0(itemArray);
    }

    public void setItems(List<Map<String, NSObject>> items, UIPasteboardOptions options) {
        NSMutableArray<NSDictionary> itemArray = new NSMutableArray<NSDictionary>();
        for (Map<String, NSObject> item : items) {
            itemArray.add(NSDictionary.fromStringMap(item));
        }
        this.setItems0(itemArray, options);
    }

    @Property(selector="generalPasteboard")
    public static native UIPasteboard getGeneralPasteboard();

    @Property(selector="name")
    public native String getName();

    @Property(selector="isPersistent")
    public native boolean isPersistent();

    @Property(selector="setPersistent:")
    public native void setPersistent(boolean var1);

    @Property(selector="changeCount")
    @MachineSizedSInt
    public native long getChangeCount();

    @Property(selector="itemProviders")
    public native NSArray<NSItemProvider> getItemProviders();

    @Property(selector="setItemProviders:")
    public native void setItemProviders(NSArray<NSItemProvider> var1);

    @Property(selector="pasteboardTypes")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getPasteboardTypes();

    @Property(selector="numberOfItems")
    @MachineSizedSInt
    public native long getNumberOfItems();

    @Property(selector="items")
    private native NSArray<NSDictionary> getItems0();

    @Property(selector="setItems:")
    private native void setItems0(NSArray<NSDictionary> var1);

    @Property(selector="string")
    public native String getString();

    @Property(selector="setString:")
    public native void setString(String var1);

    @Property(selector="strings")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getStrings();

    @Property(selector="setStrings:")
    public native void setStrings(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Property(selector="URL")
    public native NSURL getURL();

    @Property(selector="setURL:")
    public native void setURL(NSURL var1);

    @Property(selector="URLs")
    public native NSArray<NSURL> getURLs();

    @Property(selector="setURLs:")
    public native void setURLs(NSArray<NSURL> var1);

    @Property(selector="image")
    public native UIImage getImage();

    @Property(selector="setImage:")
    public native void setImage(UIImage var1);

    @Property(selector="images")
    public native NSArray<UIImage> getImages();

    @Property(selector="setImages:")
    public native void setImages(NSArray<UIImage> var1);

    @Property(selector="color")
    public native UIColor getColor();

    @Property(selector="setColor:")
    public native void setColor(UIColor var1);

    @Property(selector="colors")
    public native NSArray<UIColor> getColors();

    @Property(selector="setColors:")
    public native void setColors(NSArray<UIColor> var1);

    @Property(selector="hasStrings")
    public native boolean hasStrings();

    @Property(selector="hasURLs")
    public native boolean hasURLs();

    @Property(selector="hasImages")
    public native boolean hasImages();

    @Property(selector="hasColors")
    public native boolean hasColors();

    public static UIPasteboard getFindPasteboard() {
        return UIPasteboard.getPasteboard(UIPasteboard.PasteboardNameFind(), true);
    }

    public List<List<String>> getTypes(NSIndexSet itemSet) {
        NSArray<NSArray<NSString>> types = this.getTypes0(itemSet);
        ArrayList<List<String>> typeList = new ArrayList<List<String>>();
        for (NSArray<NSString> type : types) {
            typeList.add(type.asStringList());
        }
        return typeList;
    }

    public void addItems(List<Map<String, NSObject>> items) {
        NSMutableArray<NSDictionary> itemArray = new NSMutableArray<NSDictionary>();
        for (Map<String, NSObject> item : items) {
            itemArray.add(NSDictionary.fromStringMap(item));
        }
        this.addItems((NSArray<NSDictionary>)itemArray);
    }

    @Deprecated
    @GlobalValue(symbol="UIPasteboardNameFind", optional=true)
    private static native String PasteboardNameFind();

    @GlobalValue(symbol="UIPasteboardChangedNotification", optional=true)
    public static native NSString ChangedNotification();

    @GlobalValue(symbol="UIPasteboardRemovedNotification", optional=true)
    public static native NSString RemovedNotification();

    @GlobalValue(symbol="UIPasteboardTypeListString", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getStringTypeList();

    @GlobalValue(symbol="UIPasteboardTypeListURL", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getURLTypeList();

    @GlobalValue(symbol="UIPasteboardTypeListImage", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getImageTypeList();

    @GlobalValue(symbol="UIPasteboardTypeListColor", optional=true)
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public static native List<String> getColorTypeList();

    @GlobalValue(symbol="UIPasteboardTypeAutomatic", optional=true)
    public static native String getAutomaticType();

    @Method(selector="setItemProviders:localOnly:expirationDate:")
    public native void setItemProviders(NSArray<NSItemProvider> var1, boolean var2, NSDate var3);

    @Method(selector="setObjects:")
    public native void setObjects(NSArray<?> var1);

    @Method(selector="setObjects:localOnly:expirationDate:")
    public native void setObjects(NSArray<?> var1, boolean var2, NSDate var3);

    @Method(selector="containsPasteboardTypes:")
    public native boolean contains(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="dataForPasteboardType:")
    public native NSData getData(String var1);

    @Method(selector="valueForPasteboardType:")
    public native NSObject getValue(String var1);

    @Method(selector="setValue:forPasteboardType:")
    public native void setValue(NSObject var1, String var2);

    @Method(selector="setData:forPasteboardType:")
    public native void setData(NSData var1, String var2);

    @Method(selector="pasteboardTypesForItemSet:")
    private native NSArray<NSArray<NSString>> getTypes0(NSIndexSet var1);

    @Method(selector="containsPasteboardTypes:inItemSet:")
    public native boolean contains(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1, NSIndexSet var2);

    @Method(selector="itemSetWithPasteboardTypes:")
    public native NSIndexSet getItemsWithTypes(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="valuesForPasteboardType:inItemSet:")
    public native NSArray<?> getValues(String var1, NSIndexSet var2);

    @Method(selector="dataForPasteboardType:inItemSet:")
    public native NSArray<NSData> getData(String var1, NSIndexSet var2);

    @Method(selector="addItems:")
    private native void addItems(NSArray<NSDictionary> var1);

    @Method(selector="setItems:options:")
    private native void setItems0(NSArray<NSDictionary> var1, UIPasteboardOptions var2);

    @Method(selector="detectPatternsForPatterns:completionHandler:")
    public native void detectPatternsForPatterns(NSSet<NSString> var1, @Block VoidBlock2<NSSet<NSString>, NSError> var2);

    @Method(selector="detectPatternsForPatterns:inItemSet:completionHandler:")
    public native void detectPatternsForPatterns(NSSet<NSString> var1, NSIndexSet var2, @Block VoidBlock2<NSArray<?>, NSError> var3);

    @Method(selector="detectValuesForPatterns:completionHandler:")
    public native void detectValuesForPatterns(NSSet<NSString> var1, @Block VoidBlock2<NSDictionary<NSString, ?>, NSError> var2);

    @Method(selector="detectValuesForPatterns:inItemSet:completionHandler:")
    public native void detectValuesForPatterns(NSSet<NSString> var1, NSIndexSet var2, @Block VoidBlock2<NSArray<?>, NSError> var3);

    @Method(selector="pasteboardWithName:create:")
    public static native UIPasteboard getPasteboard(String var0, boolean var1);

    @Method(selector="pasteboardWithUniqueName")
    public static native UIPasteboard getUniquePasteboard();

    @Method(selector="removePasteboardWithName:")
    public static native void removePasteboard(String var0);

    static {
        ObjCRuntime.bind(UIPasteboard.class);
    }

    @Library(value="UIKit")
    public static class DetectionPatterns {
        @GlobalValue(symbol="UIPasteboardDetectionPatternProbableWebURL", optional=true)
        public static native NSString ProbableWebURL();

        @GlobalValue(symbol="UIPasteboardDetectionPatternProbableWebSearch", optional=true)
        public static native NSString ProbableWebSearch();

        @GlobalValue(symbol="UIPasteboardDetectionPatternNumber", optional=true)
        public static native NSString Number();

        @GlobalValue(symbol="UIPasteboardDetectionPatternLink", optional=true)
        public static native NSString Link();

        @GlobalValue(symbol="UIPasteboardDetectionPatternPhoneNumber", optional=true)
        public static native NSString PhoneNumber();

        @GlobalValue(symbol="UIPasteboardDetectionPatternEmailAddress", optional=true)
        public static native NSString EmailAddress();

        @GlobalValue(symbol="UIPasteboardDetectionPatternPostalAddress", optional=true)
        public static native NSString PostalAddress();

        @GlobalValue(symbol="UIPasteboardDetectionPatternCalendarEvent", optional=true)
        public static native NSString CalendarEvent();

        @GlobalValue(symbol="UIPasteboardDetectionPatternShipmentTrackingNumber", optional=true)
        public static native NSString ShipmentTrackingNumber();

        @GlobalValue(symbol="UIPasteboardDetectionPatternFlightNumber", optional=true)
        public static native NSString FlightNumber();

        @GlobalValue(symbol="UIPasteboardDetectionPatternMoneyAmount", optional=true)
        public static native NSString MoneyAmount();

        static {
            Bro.bind(DetectionPatterns.class);
        }
    }

    public static class UIPasteboardPtr
    extends Ptr<UIPasteboard, UIPasteboardPtr> {
    }

    public static class Notifications {
        public static NSObjectProtocol observeChanged(UIPasteboard object, final VoidBlock2<UIPasteboard, UIPasteboardChangedNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIPasteboard.ChangedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> userInfo = a.getUserInfo();
                    UIPasteboardChangedNotification data = null;
                    if (userInfo != null) {
                        data = new UIPasteboardChangedNotification(userInfo);
                    }
                    block.invoke((Object)((UIPasteboard)a.getObject()), (Object)data);
                }
            });
        }

        public static NSObjectProtocol observeRemoved(UIPasteboard object, final VoidBlock1<UIPasteboard> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(UIPasteboard.RemovedNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((UIPasteboard)a.getObject()));
                }
            });
        }
    }
}

