/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAsset;
import org.robovm.apple.avfoundation.AVAssetTrackSegment;
import org.robovm.apple.avfoundation.AVAsynchronousKeyValueLoading;
import org.robovm.apple.avfoundation.AVKeyValueStatus;
import org.robovm.apple.avfoundation.AVMediaCharacteristic;
import org.robovm.apple.avfoundation.AVMetadataFormat;
import org.robovm.apple.avfoundation.AVMetadataItem;
import org.robovm.apple.avfoundation.AVMetadataKey;
import org.robovm.apple.avfoundation.AVSampleCursor;
import org.robovm.apple.avfoundation.AVTrackAssociationType;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.coremedia.CMTimeRange;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAssetTrack
extends NSObject
implements AVAsynchronousKeyValueLoading {
    protected AVAssetTrack() {
    }

    protected AVAssetTrack(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAssetTrack(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="asset")
    public native AVAsset getAsset();

    @Property(selector="trackID")
    public native int getTrackID();

    @Property(selector="mediaType")
    public native String getMediaType();

    @Property(selector="formatDescriptions")
    @Marshaler(value=NSArray.AsListMarshaler.class)
    public native List<CMFormatDescription> getFormatDescriptions();

    @Property(selector="isPlayable")
    public native boolean isPlayable();

    @Property(selector="isDecodable")
    public native boolean isDecodable();

    @Property(selector="isEnabled")
    public native boolean isEnabled();

    @Property(selector="isSelfContained")
    public native boolean isSelfContained();

    @Property(selector="totalSampleDataLength")
    public native long getTotalSampleDataLength();

    @Property(selector="timeRange")
    @ByVal
    public native CMTimeRange getTimeRange();

    @Property(selector="naturalTimeScale")
    public native int getNaturalTimeScale();

    @Property(selector="estimatedDataRate")
    public native float getEstimatedDataRate();

    @Property(selector="languageCode")
    public native String getLanguageCode();

    @Property(selector="extendedLanguageTag")
    public native String getExtendedLanguageTag();

    @Property(selector="naturalSize")
    @ByVal
    public native CGSize getNaturalSize();

    @Property(selector="preferredTransform")
    @ByVal
    public native CGAffineTransform getPreferredTransform();

    @Property(selector="preferredVolume")
    public native float getPreferredVolume();

    @Property(selector="hasAudioSampleDependencies")
    public native boolean hasAudioSampleDependencies();

    @Property(selector="nominalFrameRate")
    public native float getNominalFrameRate();

    @Property(selector="minFrameDuration")
    @ByVal
    public native CMTime getMinFrameDuration();

    @Property(selector="requiresFrameReordering")
    public native boolean requiresFrameReordering();

    @Property(selector="segments")
    public native NSArray<AVAssetTrackSegment> getSegments();

    @Property(selector="commonMetadata")
    public native NSArray<AVMetadataItem> getCommonMetadata();

    @Property(selector="metadata")
    public native NSArray<AVMetadataItem> getMetadata();

    @Property(selector="availableMetadataFormats")
    @Marshaler(value=AVMetadataFormat.AsListMarshaler.class)
    public native List<AVMetadataFormat> getAvailableMetadataFormats();

    @Property(selector="availableTrackAssociationTypes")
    @Marshaler(value=AVTrackAssociationType.AsListMarshaler.class)
    public native List<AVTrackAssociationType> getAvailableTrackAssociationTypes();

    @Property(selector="canProvideSampleCursors")
    public native boolean canProvideSampleCursors();

    public AVKeyValueStatus getStatusOfValue(AVMetadataKey key) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        AVKeyValueStatus result = this.getStatusOfValue(key, err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return result;
    }

    @GlobalValue(symbol="AVAssetTrackTrackAssociationsDidChangeNotification", optional=true)
    public static native NSString TrackAssociationsDidChangeNotification();

    @Method(selector="hasMediaCharacteristic:")
    public native boolean hasMediaCharacteristic(AVMediaCharacteristic var1);

    @Deprecated
    @Method(selector="segmentForTrackTime:")
    public native AVAssetTrackSegment getSegment(@ByVal CMTime var1);

    @Method(selector="loadSegmentForTrackTime:completionHandler:")
    public native void loadSegmentForTrackTime(@ByVal CMTime var1, @Block VoidBlock2<AVAssetTrackSegment, NSError> var2);

    @Deprecated
    @Method(selector="samplePresentationTimeForTrackTime:")
    @ByVal
    public native CMTime getSamplePresentationTime(@ByVal CMTime var1);

    @Method(selector="loadSamplePresentationTimeForTrackTime:completionHandler:")
    public native void loadSamplePresentationTimeForTrackTime(@ByVal CMTime var1, @Block(value="(@ByVal,)") VoidBlock2<CMTime, NSError> var2);

    @Deprecated
    @Method(selector="metadataForFormat:")
    public native NSArray<AVMetadataItem> getMetadataForFormat(AVMetadataFormat var1);

    @Method(selector="loadMetadataForFormat:completionHandler:")
    public native void loadMetadataForFormat(String var1, @Block VoidBlock2<NSArray<AVMetadataItem>, NSError> var2);

    @Deprecated
    @Method(selector="associatedTracksOfType:")
    public native NSArray<AVAssetTrack> getAssociatedTracksOfType(AVTrackAssociationType var1);

    @Method(selector="loadAssociatedTracksOfType:completionHandler:")
    public native void loadAssociatedTracksOfType(String var1, @Block VoidBlock2<NSArray<AVAssetTrack>, NSError> var2);

    @Method(selector="makeSampleCursorWithPresentationTimeStamp:")
    public native AVSampleCursor makeSampleCursor(@ByVal CMTime var1);

    @Method(selector="makeSampleCursorAtFirstSampleInDecodeOrder")
    public native AVSampleCursor makeSampleCursorAtFirstSampleInDecodeOrder();

    @Method(selector="makeSampleCursorAtLastSampleInDecodeOrder")
    public native AVSampleCursor makeSampleCursorAtLastSampleInDecodeOrder();

    @Override
    @Method(selector="statusOfValueForKey:error:")
    public native AVKeyValueStatus getStatusOfValue(AVMetadataKey var1, NSError.NSErrorPtr var2);

    @Override
    @Method(selector="loadValuesAsynchronouslyForKeys:completionHandler:")
    public native void loadValuesAsynchronously(@Marshaler(value=AVMetadataKey.AsListMarshaler.class) List<AVMetadataKey> var1, @Block Runnable var2);

    static {
        ObjCRuntime.bind(AVAssetTrack.class);
    }

    public static class AVAssetTrackPtr
    extends Ptr<AVAssetTrack, AVAssetTrackPtr> {
    }

    public static class Notifications {
        public static NSObject observeTrackAssociationsDidChange(AVAssetTrack object, final VoidBlock1<AVAssetTrack> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAssetTrack.TrackAssociationsDidChangeNotification(), (NSObject)object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification notification) {
                    block.invoke((Object)((AVAssetTrack)notification.getObject()));
                }
            });
        }
    }
}

