/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDataSearchFlags;
import org.robovm.apple.corefoundation.CFPropertyList;
import org.robovm.apple.corefoundation.CFRange;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreFoundation")
public class CFData
extends CFPropertyList {
    private static final int EFFECTIVE_DIRECT_ADDRESS_OFFSET;

    static long getEffectiveAddress(ByteBuffer bytes) {
        if (!bytes.isDirect()) {
            throw new IllegalArgumentException("Direct ByteBuffer expected");
        }
        return VM.getLong((long)(VM.getObjectAddress((Object)bytes) + (long)EFFECTIVE_DIRECT_ADDRESS_OFFSET));
    }

    protected CFData() {
    }

    public static CFData create(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return CFData.create((CFAllocator)null, VM.getArrayValuesAddress((Object)bytes), (long)bytes.length);
    }

    public static CFData create(ByteBuffer bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        long handle = CFData.getEffectiveAddress(bytes) + (long)bytes.position();
        CFData result = CFData.create(null, handle, (long)bytes.remaining(), null);
        return result;
    }

    public static CFData createCopy(CFData theData) {
        return CFData.createCopy(null, theData);
    }

    public ByteBuffer asByteBuffer() {
        return VM.newDirectByteBuffer((long)this.getBytePtr(), (long)this.getLength());
    }

    public byte[] getBytes() {
        int length = (int)this.getLength();
        byte[] bytes = new byte[length];
        this.getBytes(new CFRange(0L, length), VM.getArrayValuesAddress((Object)bytes));
        return bytes;
    }

    @Bridge(symbol="CFDataGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CFDataCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFData create(CFAllocator var0, @Pointer long var1, @MachineSizedSInt long var3);

    @Bridge(symbol="CFDataCreateWithBytesNoCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native CFData create(CFAllocator var0, @Pointer long var1, @MachineSizedSInt long var3, CFAllocator var5);

    @Bridge(symbol="CFDataCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CFData createCopy(CFAllocator var0, CFData var1);

    @Bridge(symbol="CFDataGetLength", optional=true)
    @MachineSizedSInt
    public native long getLength();

    @Bridge(symbol="CFDataGetBytePtr", optional=true)
    @Pointer
    protected native long getBytePtr();

    @Bridge(symbol="CFDataGetBytes", optional=true)
    protected native void getBytes(@ByVal CFRange var1, @Pointer long var2);

    @Bridge(symbol="CFDataFind", optional=true)
    @ByVal
    public native CFRange find(CFData var1, @ByVal CFRange var2, CFDataSearchFlags var3);

    static {
        try {
            Field f1 = Buffer.class.getDeclaredField("effectiveDirectAddress");
            if (f1.getType() != Long.TYPE) {
                throw new Error("java.nio.Buffer.effectiveDirectAddress should be a long");
            }
            EFFECTIVE_DIRECT_ADDRESS_OFFSET = VM.getInstanceFieldOffset((long)VM.getFieldAddress((Field)f1));
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        Bro.bind(CFData.class);
    }

    public static class CFDataPtr
    extends Ptr<CFData, CFDataPtr> {
    }
}

