/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreimage;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.coreimage.CIDetectorAccuracy;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreImage")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CIDetectorOptions
extends NSDictionaryWrapper {
    CIDetectorOptions(NSDictionary data) {
        super(data);
    }

    public CIDetectorOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public CIDetectorOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public CIDetectorAccuracy getAccuracy() {
        if (this.has(Keys.Accuracy())) {
            NSString val = (NSString)this.get(Keys.Accuracy());
            return CIDetectorAccuracy.valueOf(val);
        }
        return null;
    }

    public CIDetectorOptions setAccuracy(CIDetectorAccuracy accuracy) {
        this.set(Keys.Accuracy(), (NSObject)accuracy.value());
        return this;
    }

    public boolean isTracking() {
        if (this.has(Keys.Tracking())) {
            NSNumber val = (NSNumber)this.get(Keys.Tracking());
            return val.booleanValue();
        }
        return false;
    }

    public CIDetectorOptions setTracking(boolean tracking) {
        this.set(Keys.Tracking(), NSNumber.valueOf(tracking));
        return this;
    }

    public double getMinFeatureSize() {
        if (this.has(Keys.MinFeatureSize())) {
            NSNumber val = (NSNumber)this.get(Keys.MinFeatureSize());
            return val.doubleValue();
        }
        return 0.0;
    }

    public CIDetectorOptions setMinFeatureSize(double minFeatureSize) {
        this.set(Keys.MinFeatureSize(), NSNumber.valueOf(minFeatureSize));
        return this;
    }

    @Library(value="CoreImage")
    public static class Keys {
        @GlobalValue(symbol="CIDetectorAccuracy", optional=true)
        public static native NSString Accuracy();

        @GlobalValue(symbol="CIDetectorTracking", optional=true)
        public static native NSString Tracking();

        @GlobalValue(symbol="CIDetectorMinFeatureSize", optional=true)
        public static native NSString MinFeatureSize();

        @GlobalValue(symbol="CIDetectorMaxFeatureCount", optional=true)
        public static native NSString MaxFeatureCount();

        @GlobalValue(symbol="CIDetectorNumberOfAngles", optional=true)
        public static native NSString NumberOfAngles();

        @GlobalValue(symbol="CIDetectorReturnSubFeatures", optional=true)
        public static native NSString ReturnSubFeatures();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CIDetectorOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CIDetectorOptions> list = new ArrayList<CIDetectorOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new CIDetectorOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CIDetectorOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (CIDetectorOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CIDetectorOptions toObject(Class<CIDetectorOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CIDetectorOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CIDetectorOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

