/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.fileprovider;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="FileProvider")
public enum NSFileProviderErrorCode implements NSErrorCode
{
    NotAuthenticated(-1000L),
    FilenameCollision(-1001L),
    SyncAnchorExpired(-1002L),
    PageExpired(-1002L),
    InsufficientQuota(-1003L),
    ServerUnreachable(-1004L),
    NoSuchItem(-1005L),
    DeletionRejected(-1006L),
    DirectoryNotEmpty(-1007L),
    ProviderNotFound(-2001L),
    CannotSynchronize(-2005L),
    NonEvictableChildren(-2006L),
    UnsyncedEdits(-2007L),
    NonEvictable(-2008L),
    ExcludedFromSync(-2010L),
    DomainDisabled(-2011L);

    private final long n;

    @GlobalValue(symbol="NSFileProviderErrorDomain", optional=true)
    public static native String getClassDomain();

    private NSFileProviderErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static NSFileProviderErrorCode valueOf(long n) {
        for (NSFileProviderErrorCode v : NSFileProviderErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + NSFileProviderErrorCode.class.getName());
    }

    static {
        Bro.bind(NSFileProviderErrorCode.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return NSFileProviderErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return NSFileProviderErrorCode.getClassDomain();
        }
    }
}

