/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.gameplaykit;

import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.gameplaykit.GKGameModelPlayer;
import org.robovm.apple.gameplaykit.GKGameModelUpdate;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;

public interface GKGameModel
extends NSObjectProtocol {
    public static final int MaxScore = 0x1000000;
    public static final int MinScore = -16777216;

    @Property(selector="players")
    @Marshaler(value=NSArray.AsListMarshaler.class)
    public List<GKGameModelPlayer> getPlayers();

    @Property(selector="activePlayer")
    public GKGameModelPlayer getActivePlayer();

    @Method(selector="setGameModel:")
    public void setGameModel(GKGameModel var1);

    @Method(selector="gameModelUpdatesForPlayer:")
    @Marshaler(value=NSArray.AsListMarshaler.class)
    public List<GKGameModelUpdate> getGameModelUpdatesForPlayer(GKGameModelPlayer var1);

    @Method(selector="applyGameModelUpdate:")
    public void applyGameModelUpdate(GKGameModelUpdate var1);

    @Method(selector="scoreForPlayer:")
    @MachineSizedSInt
    public long getScoreForPlayer(GKGameModelPlayer var1);

    @Method(selector="isWinForPlayer:")
    public boolean isWinForPlayer(GKGameModelPlayer var1);

    @Method(selector="isLossForPlayer:")
    public boolean isLossForPlayer(GKGameModelPlayer var1);

    @Method(selector="unapplyGameModelUpdate:")
    public void unapplyGameModelUpdate(GKGameModelUpdate var1);
}

