/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.glkit;

import java.nio.FloatBuffer;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Array;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class GLKVector2
extends Struct<GLKVector2> {
    public GLKVector2() {
    }

    public GLKVector2(FloatBuffer v) {
        this.setV(v);
    }

    @StructMember(value=0)
    @Array(value={2})
    public native FloatBuffer getV();

    @StructMember(value=0)
    public native GLKVector2 setV(@Array(value={2}) FloatBuffer var1);

    public static GLKVector2 create(float x, float y) {
        return GLKVector2.create(new float[]{x, y});
    }

    public static GLKVector2 create(float[] values) {
        return new GLKVector2(FloatBuffer.wrap(values));
    }

    public GLKVector2 negate() {
        float[] v = new float[]{-this.getV().get(0), -this.getV().get(1)};
        return GLKVector2.create(v);
    }

    public GLKVector2 add(GLKVector2 vectorRight) {
        return GLKVector2.add(this, vectorRight);
    }

    public static GLKVector2 add(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        float[] v = new float[]{vectorLeft.getV().get(0) + vectorRight.getV().get(0), vectorLeft.getV().get(1) + vectorRight.getV().get(1)};
        return GLKVector2.create(v);
    }

    public GLKVector2 subtract(GLKVector2 vectorRight) {
        return GLKVector2.subtract(this, vectorRight);
    }

    public static GLKVector2 subtract(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        float[] v = new float[]{vectorLeft.getV().get(0) - vectorRight.getV().get(0), vectorLeft.getV().get(1) - vectorRight.getV().get(1)};
        return GLKVector2.create(v);
    }

    public GLKVector2 multiply(GLKVector2 vectorRight) {
        return GLKVector2.multiply(this, vectorRight);
    }

    public static GLKVector2 multiply(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        float[] v = new float[]{vectorLeft.getV().get(0) * vectorRight.getV().get(0), vectorLeft.getV().get(1) * vectorRight.getV().get(1)};
        return GLKVector2.create(v);
    }

    public GLKVector2 divide(GLKVector2 vectorRight) {
        float[] v = new float[]{this.getV().get(0) / vectorRight.getV().get(0), this.getV().get(1) / vectorRight.getV().get(1)};
        return GLKVector2.create(v);
    }

    public GLKVector2 addScalar(float value) {
        float[] v = new float[]{this.getV().get(0) + value, this.getV().get(1) + value};
        return GLKVector2.create(v);
    }

    public GLKVector2 subtractScalar(float value) {
        float[] v = new float[]{this.getV().get(0) - value, this.getV().get(1) - value};
        return GLKVector2.create(v);
    }

    public GLKVector2 multiplyScalar(float value) {
        float[] v = new float[]{this.getV().get(0) * value, this.getV().get(1) * value};
        return GLKVector2.create(v);
    }

    public GLKVector2 divideScalar(float value) {
        float[] v = new float[]{this.getV().get(0) / value, this.getV().get(1) / value};
        return GLKVector2.create(v);
    }

    public GLKVector2 maximum(GLKVector2 vectorRight) {
        return GLKVector2.maximum(this, vectorRight);
    }

    public static GLKVector2 maximum(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        GLKVector2 max = (GLKVector2)vectorLeft.copy();
        if (vectorRight.getV().get(0) > vectorLeft.getV().get(0)) {
            max.getV().put(0, vectorRight.getV().get(0));
        }
        if (vectorRight.getV().get(1) > vectorLeft.getV().get(1)) {
            max.getV().put(1, vectorRight.getV().get(1));
        }
        return max;
    }

    public GLKVector2 minimum(GLKVector2 vectorRight) {
        return GLKVector2.minimum(this, vectorRight);
    }

    public static GLKVector2 minimum(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        GLKVector2 min = (GLKVector2)vectorLeft.copy();
        if (vectorRight.getV().get(0) < vectorLeft.getV().get(0)) {
            min.getV().put(0, vectorRight.getV().get(0));
        }
        if (vectorRight.getV().get(1) < vectorLeft.getV().get(1)) {
            min.getV().put(1, vectorRight.getV().get(1));
        }
        return min;
    }

    public boolean allEqualToVector2(GLKVector2 vectorRight) {
        return GLKVector2.allEqualToVector2(this, vectorRight);
    }

    public static boolean allEqualToVector2(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        boolean compare = false;
        if (vectorLeft.getV().get(0) == vectorRight.getV().get(0) && vectorLeft.getV().get(1) == vectorRight.getV().get(1)) {
            compare = true;
        }
        return compare;
    }

    public boolean allEqualToScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) == value && this.getV().get(1) == value) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanVector2(GLKVector2 vectorRight) {
        return GLKVector2.allGreaterThanVector2(this, vectorRight);
    }

    public static boolean allGreaterThanVector2(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        boolean compare = false;
        if (vectorLeft.getV().get(0) > vectorRight.getV().get(0) && vectorLeft.getV().get(1) > vectorRight.getV().get(1)) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) > value && this.getV().get(1) > value) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanOrEqualToVector2(GLKVector2 vectorRight) {
        return GLKVector2.allGreaterThanOrEqualToVector2(this, vectorRight);
    }

    public static boolean allGreaterThanOrEqualToVector2(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        boolean compare = false;
        if (vectorLeft.getV().get(0) >= vectorRight.getV().get(0) && vectorLeft.getV().get(1) >= vectorRight.getV().get(1)) {
            compare = true;
        }
        return compare;
    }

    public boolean allGreaterThanOrEqualToScalar(float value) {
        boolean compare = false;
        if (this.getV().get(0) >= value && this.getV().get(1) >= value) {
            compare = true;
        }
        return compare;
    }

    public GLKVector2 normalize() {
        float scale = 1.0f / this.length();
        GLKVector2 v = this.multiplyScalar(scale);
        return v;
    }

    public float dotProduct(GLKVector2 vectorRight) {
        return GLKVector2.dotProduct(this, vectorRight);
    }

    public static float dotProduct(GLKVector2 vectorLeft, GLKVector2 vectorRight) {
        return vectorLeft.getV().get(0) * vectorRight.getV().get(0) + vectorLeft.getV().get(1) * vectorRight.getV().get(1);
    }

    public float length() {
        return (float)Math.sqrt(this.getV().get(0) * this.getV().get(0) + this.getV().get(1) * this.getV().get(1));
    }

    public float distance(GLKVector2 vectorEnd) {
        return GLKVector2.distance(this, vectorEnd);
    }

    public static float distance(GLKVector2 vectorStart, GLKVector2 vectorEnd) {
        return GLKVector2.subtract(vectorEnd, vectorStart).length();
    }

    public GLKVector2 lerp(GLKVector2 vectorEnd, float t) {
        return GLKVector2.lerp(this, vectorEnd, t);
    }

    public static GLKVector2 lerp(GLKVector2 vectorStart, GLKVector2 vectorEnd, float t) {
        float[] v = new float[]{vectorStart.getV().get(0) + (vectorEnd.getV().get(0) - vectorStart.getV().get(0)) * t, vectorStart.getV().get(1) + (vectorEnd.getV().get(1) - vectorStart.getV().get(1)) * t};
        return GLKVector2.create(v);
    }

    public GLKVector2 project(GLKVector2 projectionVector) {
        return GLKVector2.project(this, projectionVector);
    }

    public static GLKVector2 project(GLKVector2 vectorToProject, GLKVector2 projectionVector) {
        float scale = GLKVector2.dotProduct(projectionVector, vectorToProject) / GLKVector2.dotProduct(projectionVector, projectionVector);
        GLKVector2 v = projectionVector.multiplyScalar(scale);
        return v;
    }

    static {
        Bro.bind(GLKVector2.class);
    }

    public static class GLKVector2Ptr
    extends Ptr<GLKVector2, GLKVector2Ptr> {
    }
}

