/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.homekit;

import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSUUID;
import org.robovm.apple.homekit.HMErrorCode;
import org.robovm.apple.homekit.HMErrorUserInfoKey;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="HomeKit")
@StronglyLinked
public class HMError
extends NSError {
    private NSErrorUserInfo userInfo;

    protected HMError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    private NSErrorUserInfo getCachedUserInfo() {
        if (this.userInfo == null) {
            this.userInfo = this.getUserInfo();
        }
        return this.userInfo;
    }

    @Override
    public HMErrorCode getErrorCode() {
        HMErrorCode code = null;
        try {
            code = HMErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public NSDictionary<NSUUID, NSError> getFailedAccessories() {
        if (this.getCachedUserInfo().has(HMErrorUserInfoKey.FailedAccessories)) {
            NSDictionary val = (NSDictionary)this.getCachedUserInfo().get(HMErrorUserInfoKey.FailedAccessories);
            return val;
        }
        return null;
    }

    @GlobalValue(symbol="HMErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(HMError.class);
    }
}

