/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.metalpsgraph;

import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.metal.MTLCommandQueue;
import org.robovm.apple.metalps.MPSCommandBuffer;
import org.robovm.apple.metalps.MPSDataType;
import org.robovm.apple.metalpsgraph.MPSGraphCompilationDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphConvolution2DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphCreateSparseOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphDepthwiseConvolution2DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphDepthwiseConvolution3DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphDevice;
import org.robovm.apple.metalpsgraph.MPSGraphExecutable;
import org.robovm.apple.metalpsgraph.MPSGraphExecutionDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphGRUDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphLSTMDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphLossReductionType;
import org.robovm.apple.metalpsgraph.MPSGraphOperation;
import org.robovm.apple.metalpsgraph.MPSGraphOptions;
import org.robovm.apple.metalpsgraph.MPSGraphPaddingMode;
import org.robovm.apple.metalpsgraph.MPSGraphPooling2DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphPooling4DOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphRandomOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphResizeMode;
import org.robovm.apple.metalpsgraph.MPSGraphResizeNearestRoundingMode;
import org.robovm.apple.metalpsgraph.MPSGraphScatterMode;
import org.robovm.apple.metalpsgraph.MPSGraphShapedType;
import org.robovm.apple.metalpsgraph.MPSGraphSingleGateRNNDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphSparseStorageType;
import org.robovm.apple.metalpsgraph.MPSGraphStencilOpDescriptor;
import org.robovm.apple.metalpsgraph.MPSGraphTensor;
import org.robovm.apple.metalpsgraph.MPSGraphTensorData;
import org.robovm.apple.metalpsgraph.MPSGraphTensorNamedDataLayout;
import org.robovm.apple.metalpsgraph.MPSGraphVariableOp;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block0;
import org.robovm.objc.block.Block1;
import org.robovm.objc.block.Block2;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="MetalPerformanceShadersGraph")
@NativeClass
public class MPSGraph
extends NSObject {
    public MPSGraph() {
    }

    protected MPSGraph(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected MPSGraph(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="options")
    public native MPSGraphOptions getOptions();

    @Property(selector="setOptions:")
    public native void setOptions(MPSGraphOptions var1);

    @Property(selector="placeholderTensors")
    public native NSArray<MPSGraphTensor> getPlaceholderTensors();

    @Method(selector="compileWithDevice:feeds:targetTensors:targetOperations:compilationDescriptor:")
    public native MPSGraphExecutable compile(MPSGraphDevice var1, NSDictionary<MPSGraphTensor, MPSGraphShapedType> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4, MPSGraphCompilationDescriptor var5);

    @Method(selector="runWithFeeds:targetTensors:targetOperations:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> run(NSDictionary<MPSGraphTensor, MPSGraphTensorData> var1, NSArray<MPSGraphTensor> var2, NSArray<MPSGraphOperation> var3);

    @Method(selector="runWithMTLCommandQueue:feeds:targetTensors:targetOperations:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> run(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4);

    @Method(selector="runWithMTLCommandQueue:feeds:targetOperations:resultsDictionary:")
    public native void run(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphOperation> var3, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var4);

    @Method(selector="runAsyncWithFeeds:targetTensors:targetOperations:executionDescriptor:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> runAsync(NSDictionary<MPSGraphTensor, MPSGraphTensorData> var1, NSArray<MPSGraphTensor> var2, NSArray<MPSGraphOperation> var3, MPSGraphExecutionDescriptor var4);

    @Method(selector="runAsyncWithMTLCommandQueue:feeds:targetTensors:targetOperations:executionDescriptor:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> runAsync(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="runAsyncWithMTLCommandQueue:feeds:targetOperations:resultsDictionary:executionDescriptor:")
    public native void runAsync(MTLCommandQueue var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphOperation> var3, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="encodeToCommandBuffer:feeds:targetTensors:targetOperations:executionDescriptor:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensorData> encodeToCommandBuffer(MPSCommandBuffer var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphTensor> var3, NSArray<MPSGraphOperation> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="encodeToCommandBuffer:feeds:targetOperations:resultsDictionary:executionDescriptor:")
    public native void encodeToCommandBuffer(MPSCommandBuffer var1, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var2, NSArray<MPSGraphOperation> var3, NSDictionary<MPSGraphTensor, MPSGraphTensorData> var4, MPSGraphExecutionDescriptor var5);

    @Method(selector="gradientForPrimaryTensor:withTensors:name:")
    public native NSDictionary<MPSGraphTensor, MPSGraphTensor> gradientForPrimaryTensor(MPSGraphTensor var1, NSArray<MPSGraphTensor> var2, String var3);

    @Method(selector="reLUWithTensor:name:")
    public native MPSGraphTensor reLU(MPSGraphTensor var1, String var2);

    @Method(selector="reLUGradientWithIncomingGradient:sourceTensor:name:")
    public native MPSGraphTensor reLUGradient(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="sigmoidWithTensor:name:")
    public native MPSGraphTensor sigmoid(MPSGraphTensor var1, String var2);

    @Method(selector="sigmoidGradientWithIncomingGradient:sourceTensor:name:")
    public native MPSGraphTensor sigmoidGradient(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="softMaxWithTensor:axis:name:")
    public native MPSGraphTensor softMax(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="softMaxGradientWithIncomingGradient:sourceTensor:axis:name:")
    public native MPSGraphTensor softMaxGradient(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedSInt long var3, String var5);

    @Method(selector="leakyReLUWithTensor:alpha:name:")
    public native MPSGraphTensor leakyReLU(MPSGraphTensor var1, double var2, String var4);

    @Method(selector="leakyReLUWithTensor:alphaTensor:name:")
    public native MPSGraphTensor leakyReLU(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="leakyReLUGradientWithIncomingGradient:sourceTensor:alphaTensor:name:")
    public native MPSGraphTensor leakyReLU(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="identityWithTensor:name:")
    public native MPSGraphTensor identity(MPSGraphTensor var1, String var2);

    @Method(selector="exponentWithTensor:name:")
    public native MPSGraphTensor exponent(MPSGraphTensor var1, String var2);

    @Method(selector="exponentBase2WithTensor:name:")
    public native MPSGraphTensor exponentBase2(MPSGraphTensor var1, String var2);

    @Method(selector="exponentBase10WithTensor:name:")
    public native MPSGraphTensor exponentBase10(MPSGraphTensor var1, String var2);

    @Method(selector="logarithmWithTensor:name:")
    public native MPSGraphTensor logarithm(MPSGraphTensor var1, String var2);

    @Method(selector="logarithmBase2WithTensor:name:")
    public native MPSGraphTensor logarithmBase2(MPSGraphTensor var1, String var2);

    @Method(selector="logarithmBase10WithTensor:name:")
    public native MPSGraphTensor logarithmBase10(MPSGraphTensor var1, String var2);

    @Method(selector="squareWithTensor:name:")
    public native MPSGraphTensor square(MPSGraphTensor var1, String var2);

    @Method(selector="squareRootWithTensor:name:")
    public native MPSGraphTensor squareRoot(MPSGraphTensor var1, String var2);

    @Method(selector="reverseSquareRootWithTensor:name:")
    public native MPSGraphTensor reverseSquareRoot(MPSGraphTensor var1, String var2);

    @Method(selector="reciprocalWithTensor:name:")
    public native MPSGraphTensor reciprocal(MPSGraphTensor var1, String var2);

    @Method(selector="absoluteWithTensor:name:")
    public native MPSGraphTensor absolute(MPSGraphTensor var1, String var2);

    @Method(selector="negativeWithTensor:name:")
    public native MPSGraphTensor negative(MPSGraphTensor var1, String var2);

    @Method(selector="signWithTensor:name:")
    public native MPSGraphTensor sign(MPSGraphTensor var1, String var2);

    @Method(selector="signbitWithTensor:name:")
    public native MPSGraphTensor signbit(MPSGraphTensor var1, String var2);

    @Method(selector="ceilWithTensor:name:")
    public native MPSGraphTensor ceil(MPSGraphTensor var1, String var2);

    @Method(selector="floorWithTensor:name:")
    public native MPSGraphTensor floor(MPSGraphTensor var1, String var2);

    @Method(selector="roundWithTensor:name:")
    public native MPSGraphTensor round(MPSGraphTensor var1, String var2);

    @Method(selector="rintWithTensor:name:")
    public native MPSGraphTensor rint(MPSGraphTensor var1, String var2);

    @Method(selector="sinWithTensor:name:")
    public native MPSGraphTensor sin(MPSGraphTensor var1, String var2);

    @Method(selector="cosWithTensor:name:")
    public native MPSGraphTensor cos(MPSGraphTensor var1, String var2);

    @Method(selector="tanWithTensor:name:")
    public native MPSGraphTensor tan(MPSGraphTensor var1, String var2);

    @Method(selector="sinhWithTensor:name:")
    public native MPSGraphTensor sinh(MPSGraphTensor var1, String var2);

    @Method(selector="coshWithTensor:name:")
    public native MPSGraphTensor cosh(MPSGraphTensor var1, String var2);

    @Method(selector="tanhWithTensor:name:")
    public native MPSGraphTensor tanh(MPSGraphTensor var1, String var2);

    @Method(selector="asinWithTensor:name:")
    public native MPSGraphTensor asin(MPSGraphTensor var1, String var2);

    @Method(selector="acosWithTensor:name:")
    public native MPSGraphTensor acos(MPSGraphTensor var1, String var2);

    @Method(selector="atanWithTensor:name:")
    public native MPSGraphTensor atan(MPSGraphTensor var1, String var2);

    @Method(selector="asinhWithTensor:name:")
    public native MPSGraphTensor asinh(MPSGraphTensor var1, String var2);

    @Method(selector="acoshWithTensor:name:")
    public native MPSGraphTensor acosh(MPSGraphTensor var1, String var2);

    @Method(selector="atanhWithTensor:name:")
    public native MPSGraphTensor atanh(MPSGraphTensor var1, String var2);

    @Method(selector="notWithTensor:name:")
    public native MPSGraphTensor not(MPSGraphTensor var1, String var2);

    @Method(selector="isInfiniteWithTensor:name:")
    public native MPSGraphTensor isInfinite(MPSGraphTensor var1, String var2);

    @Method(selector="isFiniteWithTensor:name:")
    public native MPSGraphTensor isFinite(MPSGraphTensor var1, String var2);

    @Method(selector="isNaNWithTensor:name:")
    public native MPSGraphTensor isNaN(MPSGraphTensor var1, String var2);

    @Method(selector="erfWithTensor:name:")
    public native MPSGraphTensor erf(MPSGraphTensor var1, String var2);

    @Method(selector="truncateWithTensor:name:")
    public native MPSGraphTensor truncate(MPSGraphTensor var1, String var2);

    @Method(selector="additionWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor addition(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="subtractionWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor subtraction(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="multiplicationWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor multiplication(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="divisionWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor division(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="moduloWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor modulo(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="powerWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor power(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="minimumWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor minimum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="maximumWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor maximum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="minimumWithNaNPropagationWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor minimumWithNaNPropagation(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="maximumWithNaNPropagationWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor maximumWithNaNPropagation(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="equalWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor equal(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="notEqualWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor notEqual(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="lessThanWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor lessThan(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="lessThanOrEqualToWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor lessThanOrEqual(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="greaterThanWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor greaterThan(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="greaterThanOrEqualToWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor greaterThanOrEqual(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalANDWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalAND(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalNANDWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalNAND(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalNORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalNOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalXORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalXOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="logicalXNORWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor logicalXNOR(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="atan2WithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor atan2(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="selectWithPredicateTensor:truePredicateTensor:falsePredicateTensor:name:")
    public native MPSGraphTensor select(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="clampWithTensor:minValueTensor:maxValueTensor:name:")
    public native MPSGraphTensor clamp(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="divisionNoNaNWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor divisionNoNaN(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="floorModuloWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor floorModulo(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="convolution2DWithSourceTensor:weightsTensor:descriptor:name:")
    public native MPSGraphTensor convolution2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphConvolution2DOpDescriptor var3, String var4);

    @Method(selector="convolution2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolution2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolution2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShapeTensor:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolution2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolution2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolution2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolution2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShapeTensor:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolution2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DWithSourceTensor:weightsTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor convolutionTranspose2D(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DWithSourceTensor:weightsTensor:outputShapeTensor:descriptor:name:")
    public native MPSGraphTensor convolutionTranspose2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolutionTranspose2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShapeTensor:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolutionTranspose2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolutionTranspose2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="convolutionTranspose2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShapeTensor:forwardConvolutionDescriptor:name:")
    public native MPSGraphTensor convolutionTranspose2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphConvolution2DOpDescriptor var4, String var5);

    @Method(selector="controlDependencyWithOperations:dependentBlock:name:")
    public native NSArray<MPSGraphTensor> controlDependency(NSArray<MPSGraphOperation> var1, @Block Block0<NSArray<MPSGraphTensor>> var2, String var3);

    @Method(selector="ifWithPredicateTensor:thenBlock:elseBlock:name:")
    public native NSArray<MPSGraphTensor> doIf(MPSGraphTensor var1, @Block Block0<NSArray<MPSGraphTensor>> var2, @Block Block0<NSArray<MPSGraphTensor>> var3, String var4);

    @Method(selector="whileWithInitialInputs:before:after:name:")
    public native NSArray<MPSGraphTensor> whileLoop(NSArray<MPSGraphTensor> var1, @Block Block2<NSArray<MPSGraphTensor>, NSMutableArray<MPSGraphTensor>, MPSGraphTensor> var2, @Block Block1<NSArray<MPSGraphTensor>, NSArray<MPSGraphTensor>> var3, String var4);

    @Method(selector="forLoopWithLowerBound:upperBound:step:initialBodyArguments:body:name:")
    public native NSArray<MPSGraphTensor> forLoop(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, NSArray<MPSGraphTensor> var4, @Block Block2<MPSGraphTensor, NSArray<MPSGraphTensor>, NSArray<MPSGraphTensor>> var5, String var6);

    @Method(selector="forLoopWithNumberOfIterations:initialBodyArguments:body:name:")
    public native NSArray<MPSGraphTensor> forLoop(MPSGraphTensor var1, NSArray<MPSGraphTensor> var2, @Block Block2<MPSGraphTensor, NSArray<MPSGraphTensor>, NSArray<MPSGraphTensor>> var3, String var4);

    @Method(selector="cumulativeSumWithTensor:axis:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeSum(MPSGraphTensor var1, @MachineSizedSInt long var2, boolean var4, boolean var5, String var6);

    @Method(selector="cumulativeSumWithTensor:axisTensor:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeSum(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, boolean var4, String var5);

    @Method(selector="cumulativeSumWithTensor:axis:name:")
    public native MPSGraphTensor cumulativeSum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="cumulativeSumWithTensor:axisTensor:name:")
    public native MPSGraphTensor cumulativeSum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="cumulativeProductWithTensor:axis:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeProduct(MPSGraphTensor var1, @MachineSizedSInt long var2, boolean var4, boolean var5, String var6);

    @Method(selector="cumulativeProductWithTensor:axisTensor:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeProduct(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, boolean var4, String var5);

    @Method(selector="cumulativeProductWithTensor:axis:name:")
    public native MPSGraphTensor cumulativeProduct(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="cumulativeProductWithTensor:axisTensor:name:")
    public native MPSGraphTensor cumulativeProduct(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="cumulativeMinimumWithTensor:axis:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeMinimum(MPSGraphTensor var1, @MachineSizedSInt long var2, boolean var4, boolean var5, String var6);

    @Method(selector="cumulativeMinimumWithTensor:axisTensor:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeMinimum(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, boolean var4, String var5);

    @Method(selector="cumulativeMinimumWithTensor:axis:name:")
    public native MPSGraphTensor cumulativeMinimum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="cumulativeMinimumWithTensor:axisTensor:name:")
    public native MPSGraphTensor cumulativeMinimum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="cumulativeMaximumWithTensor:axis:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeMaximum(MPSGraphTensor var1, @MachineSizedSInt long var2, boolean var4, boolean var5, String var6);

    @Method(selector="cumulativeMaximumWithTensor:axisTensor:exclusive:reverse:name:")
    public native MPSGraphTensor cumulativeMaximum(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, boolean var4, String var5);

    @Method(selector="cumulativeMaximumWithTensor:axis:name:")
    public native MPSGraphTensor cumulativeMaximum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="cumulativeMaximumWithTensor:axisTensor:name:")
    public native MPSGraphTensor cumulativeMaximum(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="depthwiseConvolution2DWithSourceTensor:weightsTensor:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphDepthwiseConvolution2DOpDescriptor var3, String var4);

    @Method(selector="depthwiseConvolution2DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution2DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphDepthwiseConvolution2DOpDescriptor var4, String var5);

    @Method(selector="depthwiseConvolution2DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution2DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphDepthwiseConvolution2DOpDescriptor var4, String var5);

    @Method(selector="depthwiseConvolution3DWithSourceTensor:weightsTensor:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution3D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphDepthwiseConvolution3DOpDescriptor var3, String var4);

    @Method(selector="depthwiseConvolution3DDataGradientWithIncomingGradientTensor:weightsTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution3DDataGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphDepthwiseConvolution3DOpDescriptor var4, String var5);

    @Method(selector="depthwiseConvolution3DWeightsGradientWithIncomingGradientTensor:sourceTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor depthwiseConvolution3DWeightsGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphDepthwiseConvolution3DOpDescriptor var4, String var5);

    @Method(selector="gatherNDWithUpdatesTensor:indicesTensor:batchDimensions:name:")
    public native MPSGraphTensor gatherND(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedUInt long var3, String var5);

    @Method(selector="gatherWithUpdatesTensor:indicesTensor:axis:batchDimensions:name:")
    public native MPSGraphTensor gather(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedUInt long var3, @MachineSizedUInt long var5, String var7);

    @Method(selector="gatherAlongAxis:withUpdatesTensor:indicesTensor:name:")
    public native MPSGraphTensor gatherAlongAxis(@MachineSizedSInt long var1, MPSGraphTensor var3, MPSGraphTensor var4, String var5);

    @Method(selector="gatherAlongAxisTensor:withUpdatesTensor:indicesTensor:name:")
    public native MPSGraphTensor gatherAlongAxisTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="bandPartWithTensor:numLower:numUpper:name:")
    public native MPSGraphTensor bandPart(MPSGraphTensor var1, @MachineSizedSInt long var2, @MachineSizedSInt long var4, String var6);

    @Method(selector="bandPartWithTensor:numLowerTensor:numUpperTensor:name:")
    public native MPSGraphTensor bandPart(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="softMaxCrossEntropyWithSourceTensor:labelsTensor:axis:reductionType:name:")
    public native MPSGraphTensor softMaxCrossEntropy(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedSInt long var3, MPSGraphLossReductionType var5, String var6);

    @Method(selector="softMaxCrossEntropyGradientWithIncomingGradientTensor:sourceTensor:labelsTensor:axis:reductionType:name:")
    public native MPSGraphTensor softMaxCrossEntropyGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, @MachineSizedSInt long var4, MPSGraphLossReductionType var6, String var7);

    @Method(selector="matrixMultiplicationWithPrimaryTensor:secondaryTensor:name:")
    public native MPSGraphTensor matrixMultiplication(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="HammingDistanceWithPrimaryTensor:secondaryTensor:resultDataType:name:")
    public native MPSGraphTensor HammingDistance(MPSGraphTensor var1, MPSGraphTensor var2, MPSDataType var3, String var4);

    @Method(selector="sparseTensorWithType:tensors:shape:dataType:name:")
    public native MPSGraphTensor sparseTensor(MPSGraphSparseStorageType var1, NSArray<MPSGraphTensor> var2, NSArray<NSNumber> var3, MPSDataType var4, String var5);

    @Method(selector="sparseTensorWithDescriptor:tensors:shape:name:")
    public native MPSGraphTensor sparseTensor(MPSGraphCreateSparseOpDescriptor var1, NSArray<MPSGraphTensor> var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="placeholderWithShape:dataType:name:")
    public native MPSGraphTensor placeholder(NSArray<NSNumber> var1, MPSDataType var2, String var3);

    @Method(selector="placeholderWithShape:name:")
    public native MPSGraphTensor placeholder(NSArray<NSNumber> var1, String var2);

    @Method(selector="constantWithData:shape:dataType:")
    public native MPSGraphTensor constant(NSData var1, NSArray<NSNumber> var2, MPSDataType var3);

    @Method(selector="constantWithScalar:dataType:")
    public native MPSGraphTensor constant(double var1, MPSDataType var3);

    @Method(selector="constantWithScalar:shape:dataType:")
    public native MPSGraphTensor constant(double var1, NSArray<NSNumber> var3, MPSDataType var4);

    @Method(selector="variableWithData:shape:dataType:name:")
    public native MPSGraphTensor variable(NSData var1, NSArray<NSNumber> var2, MPSDataType var3, String var4);

    @Method(selector="readVariable:name:")
    public native MPSGraphTensor readVariable(MPSGraphTensor var1, String var2);

    @Method(selector="assignVariable:withValueOfTensor:name:")
    public native MPSGraphOperation assignVariable(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="meanOfTensor:axes:name:")
    public native MPSGraphTensor mean(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="varianceOfTensor:meanTensor:axes:name:")
    public native MPSGraphTensor variance(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="varianceOfTensor:axes:name:")
    public native MPSGraphTensor variance(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="normalizationWithTensor:meanTensor:varianceTensor:gammaTensor:betaTensor:epsilon:name:")
    public native MPSGraphTensor normalization(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, float var6, String var7);

    @Method(selector="normalizationGammaGradientWithIncomingGradientTensor:sourceTensor:meanTensor:varianceTensor:reductionAxes:epsilon:name:")
    public native MPSGraphTensor normalizationGammaGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, NSArray<NSNumber> var5, float var6, String var7);

    @Method(selector="normalizationBetaGradientWithIncomingGradientTensor:sourceTensor:reductionAxes:name:")
    public native MPSGraphTensor normalizationBetaGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="normalizationGradientWithIncomingGradientTensor:sourceTensor:meanTensor:varianceTensor:gammaTensor:gammaGradientTensor:betaGradientTensor:reductionAxes:epsilon:name:")
    public native MPSGraphTensor normalizationGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, NSArray<NSNumber> var8, float var9, String var10);

    @Method(selector="oneHotWithIndicesTensor:depth:axis:dataType:onValue:offValue:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MPSDataType var6, double var7, double var9, String var11);

    @Method(selector="oneHotWithIndicesTensor:depth:dataType:onValue:offValue:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, MPSDataType var4, double var5, double var7, String var9);

    @Method(selector="oneHotWithIndicesTensor:depth:axis:dataType:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, MPSDataType var6, String var7);

    @Method(selector="oneHotWithIndicesTensor:depth:axis:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, String var6);

    @Method(selector="oneHotWithIndicesTensor:depth:dataType:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, MPSDataType var4, String var5);

    @Method(selector="oneHotWithIndicesTensor:depth:name:")
    public native MPSGraphTensor oneHot(MPSGraphTensor var1, @MachineSizedUInt long var2, String var4);

    @Method(selector="stochasticGradientDescentWithLearningRateTensor:valuesTensor:gradientTensor:name:")
    public native MPSGraphTensor stochasticGradientDescent(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    @Method(selector="applyStochasticGradientDescentWithLearningRateTensor:variable:gradientTensor:name:")
    public native MPSGraphOperation applyStochasticGradientDescent(MPSGraphTensor var1, MPSGraphVariableOp var2, MPSGraphTensor var3, String var4);

    @Method(selector="adamWithLearningRateTensor:beta1Tensor:beta2Tensor:epsilonTensor:beta1PowerTensor:beta2PowerTensor:valuesTensor:momentumTensor:velocityTensor:maximumVelocityTensor:gradientTensor:name:")
    public native NSArray<MPSGraphTensor> adamWithLearningRateTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, MPSGraphTensor var10, MPSGraphTensor var11, String var12);

    @Method(selector="adamWithCurrentLearningRateTensor:beta1Tensor:beta2Tensor:epsilonTensor:valuesTensor:momentumTensor:velocityTensor:maximumVelocityTensor:gradientTensor:name:")
    public native NSArray<MPSGraphTensor> adamWithCurrentLearningRateTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, String var10);

    @Method(selector="maxPooling2DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling2D(MPSGraphTensor var1, MPSGraphPooling2DOpDescriptor var2, String var3);

    @Method(selector="maxPooling2DReturnIndicesWithSourceTensor:descriptor:name:")
    public native NSArray<MPSGraphTensor> maxPooling2DReturnIndices(MPSGraphTensor var1, MPSGraphPooling2DOpDescriptor var2, String var3);

    @Method(selector="maxPooling2DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling2DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling2DOpDescriptor var3, String var4);

    @Method(selector="maxPooling2DGradientWithGradientTensor:indicesTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor maxPooling2DGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphPooling2DOpDescriptor var4, String var5);

    @Method(selector="maxPooling2DGradientWithGradientTensor:indicesTensor:outputShapeTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling2DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphPooling2DOpDescriptor var4, String var5);

    @Method(selector="avgPooling2DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor avgPooling2D(MPSGraphTensor var1, MPSGraphPooling2DOpDescriptor var2, String var3);

    @Method(selector="avgPooling2DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor avgPooling2D(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling2DOpDescriptor var3, String var4);

    @Method(selector="maxPooling4DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling4D(MPSGraphTensor var1, MPSGraphPooling4DOpDescriptor var2, String var3);

    @Method(selector="maxPooling4DReturnIndicesWithSourceTensor:descriptor:name:")
    public native NSArray<MPSGraphTensor> maxPooling4DReturnIndices(MPSGraphTensor var1, MPSGraphPooling4DOpDescriptor var2, String var3);

    @Method(selector="maxPooling4DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling4DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling4DOpDescriptor var3, String var4);

    @Method(selector="maxPooling4DGradientWithGradientTensor:indicesTensor:outputShape:descriptor:name:")
    public native MPSGraphTensor maxPooling4DGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, MPSGraphPooling4DOpDescriptor var4, String var5);

    @Method(selector="maxPooling4DGradientWithGradientTensor:indicesTensor:outputShapeTensor:descriptor:name:")
    public native MPSGraphTensor maxPooling4DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphPooling4DOpDescriptor var4, String var5);

    @Method(selector="avgPooling4DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor avgPooling4D(MPSGraphTensor var1, MPSGraphPooling4DOpDescriptor var2, String var3);

    @Method(selector="avgPooling4DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor avgPooling4DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling4DOpDescriptor var3, String var4);

    @Method(selector="L2NormPooling4DWithSourceTensor:descriptor:name:")
    public native MPSGraphTensor L2NormPooling4D(MPSGraphTensor var1, MPSGraphPooling4DOpDescriptor var2, String var3);

    @Method(selector="L2NormPooling4DGradientWithGradientTensor:sourceTensor:descriptor:name:")
    public native MPSGraphTensor L2NormPooling4DGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPooling4DOpDescriptor var3, String var4);

    @Method(selector="randomPhiloxStateTensorWithSeed:name:")
    public native MPSGraphTensor randomPhiloxStateTensor(@MachineSizedUInt long var1, String var3);

    @Method(selector="randomPhiloxStateTensorWithCounterLow:counterHigh:key:name:")
    public native MPSGraphTensor randomPhiloxStateTensor(@MachineSizedUInt long var1, @MachineSizedUInt long var3, @MachineSizedUInt long var5, String var7);

    @Method(selector="randomTensorWithShape:descriptor:name:")
    public native MPSGraphTensor randomTensor(NSArray<NSNumber> var1, MPSGraphRandomOpDescriptor var2, String var3);

    @Method(selector="randomTensorWithShapeTensor:descriptor:name:")
    public native MPSGraphTensor randomTensor(MPSGraphTensor var1, MPSGraphRandomOpDescriptor var2, String var3);

    @Method(selector="randomTensorWithShape:descriptor:seed:name:")
    public native MPSGraphTensor randomTensor(NSArray<NSNumber> var1, MPSGraphRandomOpDescriptor var2, @MachineSizedUInt long var3, String var5);

    @Method(selector="randomTensorWithShapeTensor:descriptor:seed:name:")
    public native MPSGraphTensor randomTensor(MPSGraphTensor var1, MPSGraphRandomOpDescriptor var2, @MachineSizedUInt long var3, String var5);

    @Method(selector="randomTensorWithShape:descriptor:stateTensor:name:")
    public native NSArray<MPSGraphTensor> randomTensor(NSArray<NSNumber> var1, MPSGraphRandomOpDescriptor var2, MPSGraphTensor var3, String var4);

    @Method(selector="randomTensorWithShapeTensor:descriptor:stateTensor:name:")
    public native NSArray<MPSGraphTensor> randomTensor(MPSGraphTensor var1, MPSGraphRandomOpDescriptor var2, MPSGraphTensor var3, String var4);

    @Method(selector="randomUniformTensorWithShape:name:")
    public native MPSGraphTensor randomUniformTensor(NSArray<NSNumber> var1, String var2);

    @Method(selector="randomUniformTensorWithShapeTensor:name:")
    public native MPSGraphTensor randomUniformTensor(MPSGraphTensor var1, String var2);

    @Method(selector="randomUniformTensorWithShape:seed:name:")
    public native MPSGraphTensor randomUniformTensor(NSArray<NSNumber> var1, @MachineSizedUInt long var2, String var4);

    @Method(selector="randomUniformTensorWithShapeTensor:seed:name:")
    public native MPSGraphTensor randomUniformTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, String var4);

    @Method(selector="randomUniformTensorWithShape:stateTensor:name:")
    public native NSArray<MPSGraphTensor> randomUniformTensor(NSArray<NSNumber> var1, MPSGraphTensor var2, String var3);

    @Method(selector="randomUniformTensorWithShapeTensor:stateTensor:name:")
    public native NSArray<MPSGraphTensor> randomUniformTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="dropoutTensor:rate:name:")
    public native MPSGraphTensor dropout(MPSGraphTensor var1, double var2, String var4);

    @Method(selector="dropoutTensor:rateTensor:name:")
    public native MPSGraphTensor dropout(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="reductionSumWithTensor:axis:name:")
    public native MPSGraphTensor reductionSum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionSumWithTensor:axes:name:")
    public native MPSGraphTensor reductionSum(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionMaximumWithTensor:axis:name:")
    public native MPSGraphTensor reductionMaximum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionMaximumWithTensor:axes:name:")
    public native MPSGraphTensor reductionMaximum(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionMinimumWithTensor:axis:name:")
    public native MPSGraphTensor reductionMinimum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionMinimumWithTensor:axes:name:")
    public native MPSGraphTensor reductionMinimum(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionMaximumPropagateNaNWithTensor:axis:name:")
    public native MPSGraphTensor reductionMaximumPropagateNaN(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionMaximumPropagateNaNWithTensor:axes:name:")
    public native MPSGraphTensor reductionMaximumPropagateNaN(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionMinimumPropagateNaNWithTensor:axis:name:")
    public native MPSGraphTensor reductionMinimumPropagateNa(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionMinimumPropagateNaNWithTensor:axes:name:")
    public native MPSGraphTensor reductionMinimumPropagateNaN(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionProductWithTensor:axis:name:")
    public native MPSGraphTensor reductionProduct(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionProductWithTensor:axes:name:")
    public native MPSGraphTensor reductionProduct(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionArgMaximumWithTensor:axis:name:")
    public native MPSGraphTensor reductionArgMaximum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionArgMinimumWithTensor:axis:name:")
    public native MPSGraphTensor reductionArgMinimum(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionAndWithTensor:axis:name:")
    public native MPSGraphTensor reductionAnd(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionAndWithTensor:axes:name:")
    public native MPSGraphTensor reductionAnd(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reductionOrWithTensor:axis:name:")
    public native MPSGraphTensor reductionOr(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="reductionOrWithTensor:axes:name:")
    public native MPSGraphTensor reductionOr(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="resizeTensor:size:mode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, MPSGraphResizeMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="resizeTensor:sizeTensor:mode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphResizeMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="resizeNearestWithTensor:sizeTensor:nearestRoundingMode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeNearestWithTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphResizeNearestRoundingMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="resizeBilinearWithTensor:sizeTensor:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeBilinearWithTensor(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, boolean var4, MPSGraphTensorNamedDataLayout var5, String var6);

    @Method(selector="resizeTensor:sizeTensor:scaleOffsetTensor:mode:layout:name:")
    public native MPSGraphTensor resizeTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphResizeMode var4, MPSGraphTensorNamedDataLayout var5, String var6);

    @Method(selector="resizeNearestWithTensor:sizeTensor:scaleOffsetTensor:nearestRoundingMode:layout:name:")
    public native MPSGraphTensor resizeNearestWithTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphResizeNearestRoundingMode var4, MPSGraphTensorNamedDataLayout var5, String var6);

    @Method(selector="resizeBilinearWithTensor:sizeTensor:scaleOffsetTensor:layout:name:")
    public native MPSGraphTensor resizeBilinearWithTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensorNamedDataLayout var4, String var5);

    @Method(selector="resizeWithGradientTensor:input:mode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resize(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphResizeMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="resizeNearestWithGradientTensor:input:nearestRoundingMode:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeNearestWithGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphResizeNearestRoundingMode var3, boolean var4, boolean var5, MPSGraphTensorNamedDataLayout var6, String var7);

    @Method(selector="resizeBilinearWithGradientTensor:input:centerResult:alignCorners:layout:name:")
    public native MPSGraphTensor resizeBilinearWithGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, boolean var4, MPSGraphTensorNamedDataLayout var5, String var6);

    @Method(selector="resizeWithGradientTensor:input:scaleOffsetTensor:mode:layout:name:")
    public native MPSGraphTensor resizeWithGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphResizeMode var4, MPSGraphTensorNamedDataLayout var5, String var6);

    @Method(selector="resizeNearestWithGradientTensor:input:scaleOffsetTensor:nearestRoundingMode:layout:name:")
    public native MPSGraphTensor resizeNearestWithGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphResizeNearestRoundingMode var4, MPSGraphTensorNamedDataLayout var5, String var6);

    @Method(selector="resizeBilinearWithGradientTensor:input:scaleOffsetTensor:layout:name:")
    public native MPSGraphTensor resizeBilinearWithGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensorNamedDataLayout var4, String var5);

    @Method(selector="singleGateRNNWithSourceTensor:recurrentWeight:inputWeight:bias:initState:mask:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphSingleGateRNNDescriptor var7, String var8);

    @Method(selector="singleGateRNNWithSourceTensor:recurrentWeight:inputWeight:bias:initState:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphSingleGateRNNDescriptor var6, String var7);

    @Method(selector="singleGateRNNWithSourceTensor:recurrentWeight:initState:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphSingleGateRNNDescriptor var4, String var5);

    @Method(selector="singleGateRNNGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:stateGradient:inputWeight:bias:initState:mask:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, MPSGraphSingleGateRNNDescriptor var10, String var11);

    @Method(selector="singleGateRNNGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:inputWeight:bias:initState:mask:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNGradients(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphSingleGateRNNDescriptor var9, String var10);

    @Method(selector="singleGateRNNGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:inputWeight:bias:initState:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphSingleGateRNNDescriptor var8, String var9);

    @Method(selector="singleGateRNNGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:initState:descriptor:name:")
    public native NSArray<MPSGraphTensor> singleGateRNNGradients(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphSingleGateRNNDescriptor var6, String var7);

    @Method(selector="LSTMWithSourceTensor:recurrentWeight:inputWeight:bias:initState:initCell:mask:peephole:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphLSTMDescriptor var9, String var10);

    @Method(selector="LSTMWithSourceTensor:recurrentWeight:inputWeight:bias:initState:initCell:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphLSTMDescriptor var7, String var8);

    @Method(selector="LSTMWithSourceTensor:recurrentWeight:initState:initCell:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphLSTMDescriptor var5, String var6);

    @Method(selector="LSTMGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:cellOutputFwd:stateGradient:cellGradient:inputWeight:bias:initState:initCell:mask:peephole:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, MPSGraphTensor var10, MPSGraphTensor var11, MPSGraphTensor var12, MPSGraphTensor var13, MPSGraphLSTMDescriptor var14, String var15);

    @Method(selector="LSTMGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:cellOutputFwd:inputWeight:bias:initState:initCell:mask:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, MPSGraphTensor var10, MPSGraphLSTMDescriptor var11, String var12);

    @Method(selector="LSTMGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:cellOutputFwd:inputWeight:bias:initState:initCell:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, MPSGraphLSTMDescriptor var10, String var11);

    @Method(selector="LSTMGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:cellOutputFwd:descriptor:name:")
    public native NSArray<MPSGraphTensor> LSTMGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphLSTMDescriptor var6, String var7);

    @Method(selector="GRUWithSourceTensor:recurrentWeight:inputWeight:bias:initState:mask:secondaryBias:descriptor:name:")
    public native NSArray<MPSGraphTensor> GRUWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphGRUDescriptor var8, String var9);

    @Method(selector="GRUWithSourceTensor:recurrentWeight:inputWeight:bias:initState:descriptor:name:")
    public native NSArray<MPSGraphTensor> GRUWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphGRUDescriptor var6, String var7);

    @Method(selector="GRUWithSourceTensor:recurrentWeight:inputWeight:bias:descriptor:name:")
    public native NSArray<MPSGraphTensor> GRUWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphGRUDescriptor var5, String var6);

    @Method(selector="GRUGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:outputFwd:stateGradient:inputWeight:bias:initState:mask:secondaryBias:descriptor:name:")
    public native NSArray<MPSGraphTensor> GRUGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphTensor var9, MPSGraphTensor var10, MPSGraphTensor var11, MPSGraphGRUDescriptor var12, String var13);

    @Method(selector="GRUGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:outputFwd:inputWeight:bias:initState:descriptor:name:")
    public native NSArray<MPSGraphTensor> GRUGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphTensor var8, MPSGraphGRUDescriptor var9, String var10);

    @Method(selector="GRUGradientsWithSourceTensor:recurrentWeight:sourceGradient:zState:outputFwd:inputWeight:bias:descriptor:name:")
    public native NSArray<MPSGraphTensor> GRUGradientsWithSourceTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphTensor var6, MPSGraphTensor var7, MPSGraphGRUDescriptor var8, String var9);

    @Method(selector="scatterNDWithUpdatesTensor:indicesTensor:shape:batchDimensions:mode:name:")
    public native MPSGraphTensor scatterND(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, @MachineSizedUInt long var4, MPSGraphScatterMode var6, String var7);

    @Method(selector="scatterNDWithUpdatesTensor:indicesTensor:shape:batchDimensions:name:")
    public native MPSGraphTensor scatterND(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, @MachineSizedUInt long var4, String var6);

    @Method(selector="scatterNDWithDataTensor:updatesTensor:indicesTensor:batchDimensions:mode:name:")
    public native MPSGraphTensor scatterND(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, @MachineSizedUInt long var4, MPSGraphScatterMode var6, String var7);

    @Method(selector="scatterWithUpdatesTensor:indicesTensor:shape:axis:mode:name:")
    public native MPSGraphTensor scatter(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, @MachineSizedSInt long var4, MPSGraphScatterMode var6, String var7);

    @Method(selector="scatterWithDataTensor:updatesTensor:indicesTensor:axis:mode:name:")
    public native MPSGraphTensor scatter(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, @MachineSizedSInt long var4, MPSGraphScatterMode var6, String var7);

    @Method(selector="scatterAlongAxis:withUpdatesTensor:indicesTensor:shape:mode:name:")
    public native MPSGraphTensor scatterAlongAxis(@MachineSizedSInt long var1, MPSGraphTensor var3, MPSGraphTensor var4, NSArray<NSNumber> var5, MPSGraphScatterMode var6, String var7);

    @Method(selector="scatterAlongAxisTensor:withUpdatesTensor:indicesTensor:shape:mode:name:")
    public native MPSGraphTensor scatterAlongAxisTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, NSArray<NSNumber> var4, MPSGraphScatterMode var5, String var6);

    @Method(selector="scatterAlongAxis:withDataTensor:updatesTensor:indicesTensor:mode:name:")
    public native MPSGraphTensor scatterAlongAxis(@MachineSizedSInt long var1, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphTensor var5, MPSGraphScatterMode var6, String var7);

    @Method(selector="scatterAlongAxisTensor:withDataTensor:updatesTensor:indicesTensor:mode:name:")
    public native MPSGraphTensor scatterAlongAxisTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, MPSGraphScatterMode var5, String var6);

    @Method(selector="sortWithTensor:axis:descending:name:")
    public native MPSGraphTensor sort(MPSGraphTensor var1, @MachineSizedSInt long var2, boolean var4, String var5);

    @Method(selector="sortWithTensor:axisTensor:descending:name:")
    public native MPSGraphTensor sort(MPSGraphTensor var1, MPSGraphTensor var2, boolean var3, String var4);

    @Method(selector="sortWithTensor:axis:name:")
    public native MPSGraphTensor sort(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="sortWithTensor:axisTensor:name:")
    public native MPSGraphTensor sort(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="stencilWithSourceTensor:weightsTensor:descriptor:name:")
    public native MPSGraphTensor stencil(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphStencilOpDescriptor var3, String var4);

    @Method(selector="reshapeTensor:withShape:name:")
    public native MPSGraphTensor reshapeTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reshapeTensor:withShapeTensor:name:")
    public native MPSGraphTensor reshapeTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="transposeTensor:dimension:withDimension:name:")
    public native MPSGraphTensor transposeTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, String var6);

    @Method(selector="transposeTensor:permutation:name:")
    public native MPSGraphTensor transposeTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="sliceTensor:dimension:start:length:name:")
    public native MPSGraphTensor sliceTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedSInt long var4, @MachineSizedSInt long var6, String var8);

    @Method(selector="sliceTensor:starts:ends:strides:name:")
    public native MPSGraphTensor sliceTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, NSArray<NSNumber> var3, NSArray<NSNumber> var4, String var5);

    @Method(selector="sliceTensor:starts:ends:strides:startMask:endMask:squeezeMask:name:")
    public native MPSGraphTensor sliceTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, NSArray<NSNumber> var3, NSArray<NSNumber> var4, int var5, int var6, int var7, String var8);

    @Method(selector="sliceGradientTensor:fwdInShapeTensor:starts:ends:strides:name:")
    public native MPSGraphTensor sliceGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, NSArray<NSNumber> var4, NSArray<NSNumber> var5, String var6);

    @Method(selector="sliceGradientTensor:fwdInShapeTensor:starts:ends:strides:startMask:endMask:squeezeMask:name:")
    public native MPSGraphTensor sliceGradientTensor(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, NSArray<NSNumber> var4, NSArray<NSNumber> var5, int var6, int var7, int var8, String var9);

    @Method(selector="concatTensor:withTensor:dimension:name:")
    public native MPSGraphTensor concatTensor(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedSInt long var3, String var5);

    @Method(selector="concatTensors:dimension:name:")
    public native MPSGraphTensor concatTensors(NSArray<MPSGraphTensor> var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="concatTensors:dimension:interleave:name:")
    public native MPSGraphTensor concatTensors(NSArray<MPSGraphTensor> var1, @MachineSizedSInt long var2, boolean var4, String var5);

    @Method(selector="tileTensor:withMultiplier:name:")
    public native MPSGraphTensor tileTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="tileGradientWithIncomingGradientTensor:sourceTensor:withMultiplier:name:")
    public native MPSGraphTensor tileGradient(MPSGraphTensor var1, MPSGraphTensor var2, NSArray<NSNumber> var3, String var4);

    @Method(selector="padTensor:withPaddingMode:leftPadding:rightPadding:constantValue:name:")
    public native MPSGraphTensor padTensor(MPSGraphTensor var1, MPSGraphPaddingMode var2, NSArray<NSNumber> var3, NSArray<NSNumber> var4, double var5, String var7);

    @Method(selector="padGradientWithIncomingGradientTensor:sourceTensor:paddingMode:leftPadding:rightPadding:name:")
    public native MPSGraphTensor padGradient(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphPaddingMode var3, NSArray<NSNumber> var4, NSArray<NSNumber> var5, String var6);

    @Method(selector="spaceToDepth2DTensor:widthAxisTensor:heightAxisTensor:depthAxisTensor:blockSize:usePixelShuffleOrder:name:")
    public native MPSGraphTensor spaceToDepth2DTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, @MachineSizedUInt long var5, boolean var7, String var8);

    @Method(selector="depthToSpace2DTensor:widthAxisTensor:heightAxisTensor:depthAxisTensor:blockSize:usePixelShuffleOrder:name:")
    public native MPSGraphTensor depthToSpace2DTensor(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, MPSGraphTensor var4, @MachineSizedUInt long var5, boolean var7, String var8);

    @Method(selector="spaceToDepth2DTensor:widthAxis:heightAxis:depthAxis:blockSize:usePixelShuffleOrder:name:")
    public native MPSGraphTensor spaceToDepth2DTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, @MachineSizedUInt long var8, boolean var10, String var11);

    @Method(selector="depthToSpace2DTensor:widthAxis:heightAxis:depthAxis:blockSize:usePixelShuffleOrder:name:")
    public native MPSGraphTensor depthToSpace2DTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, @MachineSizedUInt long var6, @MachineSizedUInt long var8, boolean var10, String var11);

    @Method(selector="reverseTensor:axesTensor:name:")
    public native MPSGraphTensor reverseTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="reverseTensor:axes:name:")
    public native MPSGraphTensor reverseTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="reverseTensor:name:")
    public native MPSGraphTensor reverseTensor(MPSGraphTensor var1, String var2);

    @Method(selector="flatten2DTensor:axis:name:")
    public native MPSGraphTensor flatten2DTensor(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="flatten2DTensor:axisTensor:name:")
    public native MPSGraphTensor flatten2DTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="broadcastTensor:toShape:name:")
    public native MPSGraphTensor broadcastTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="broadcastTensor:toShapeTensor:name:")
    public native MPSGraphTensor broadcastTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="shapeOfTensor:name:")
    public native MPSGraphTensor shapeOfTensor(MPSGraphTensor var1, String var2);

    @Method(selector="castTensor:toType:name:")
    public native MPSGraphTensor castTensor(MPSGraphTensor var1, MPSDataType var2, String var3);

    @Method(selector="stackTensors:axis:name:")
    public native MPSGraphTensor stackTensors(NSArray<MPSGraphTensor> var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="splitTensor:splitSizes:axis:name:")
    public native NSArray<MPSGraphTensor> splitTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, @MachineSizedSInt long var3, String var5);

    @Method(selector="splitTensor:splitSizesTensor:axis:name:")
    public native NSArray<MPSGraphTensor> splitTensor(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedSInt long var3, String var5);

    @Method(selector="splitTensor:numSplits:axis:name:")
    public native NSArray<MPSGraphTensor> splitTensor(MPSGraphTensor var1, @MachineSizedUInt long var2, @MachineSizedSInt long var4, String var6);

    @Method(selector="squeezeTensor:name:")
    public native MPSGraphTensor squeezeTensor(MPSGraphTensor var1, String var2);

    @Method(selector="squeezeTensor:axis:name:")
    public native MPSGraphTensor squeezeTensor(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="squeezeTensor:axes:name:")
    public native MPSGraphTensor squeezeTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="squeezeTensor:axesTensor:name:")
    public native MPSGraphTensor squeezeTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="expandDimsOfTensor:axis:name:")
    public native MPSGraphTensor expandDimsOfTensor(MPSGraphTensor var1, @MachineSizedSInt long var2, String var4);

    @Method(selector="expandDimsOfTensor:axes:name:")
    public native MPSGraphTensor expandDimsOfTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="expandDimsOfTensor:axesTensor:name:")
    public native MPSGraphTensor expandDimsOfTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="coordinateAlongAxis:withShape:name:")
    public native MPSGraphTensor coordinateAlongAxis(@MachineSizedSInt long var1, NSArray<NSNumber> var3, String var4);

    @Method(selector="coordinateAlongAxisTensor:withShape:name:")
    public native MPSGraphTensor coordinateAlongAxisTensor(MPSGraphTensor var1, NSArray<NSNumber> var2, String var3);

    @Method(selector="coordinateAlongAxis:withShapeTensor:name:")
    public native MPSGraphTensor coordinateAlongAxis(@MachineSizedSInt long var1, MPSGraphTensor var3, String var4);

    @Method(selector="coordinateAlongAxisTensor:withShapeTensor:name:")
    public native MPSGraphTensor coordinateAlongAxisTensor(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="topKWithSourceTensor:k:name:")
    public native NSArray<MPSGraphTensor> topK(MPSGraphTensor var1, @MachineSizedUInt long var2, String var4);

    @Method(selector="topKWithSourceTensor:kTensor:name:")
    public native NSArray<MPSGraphTensor> topK(MPSGraphTensor var1, MPSGraphTensor var2, String var3);

    @Method(selector="topKWithGradientTensor:source:k:name:")
    public native MPSGraphTensor topK(MPSGraphTensor var1, MPSGraphTensor var2, @MachineSizedUInt long var3, String var5);

    @Method(selector="topKWithGradientTensor:source:kTensor:name:")
    public native MPSGraphTensor topK(MPSGraphTensor var1, MPSGraphTensor var2, MPSGraphTensor var3, String var4);

    static {
        ObjCRuntime.bind(MPSGraph.class);
    }

    public static class MPSGraphPtr
    extends Ptr<MPSGraph, MPSGraphPtr> {
    }
}

