/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAudioBitRateStrategy;
import org.robovm.apple.avfoundation.AVAudioBuffer;
import org.robovm.apple.avfoundation.AVAudioConverterOutputStatus;
import org.robovm.apple.avfoundation.AVAudioConverterPrimeInfo;
import org.robovm.apple.avfoundation.AVAudioConverterPrimeMethod;
import org.robovm.apple.avfoundation.AVAudioFormat;
import org.robovm.apple.avfoundation.AVAudioPCMBuffer;
import org.robovm.apple.avfoundation.AVAudioQuality;
import org.robovm.apple.avfoundation.AVSampleRateConverterAlgorithm;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.Block2;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.MachineSizedSIntPtr;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioConverter
extends NSObject {
    public AVAudioConverter() {
    }

    protected AVAudioConverter(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAudioConverter(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Method(selector="initFromFormat:toFormat:")
    public AVAudioConverter(AVAudioFormat fromFormat, AVAudioFormat toFormat) {
        super(null);
        this.initObject(this.init(fromFormat, toFormat));
    }

    @Property(selector="inputFormat")
    public native AVAudioFormat getInputFormat();

    @Property(selector="outputFormat")
    public native AVAudioFormat getOutputFormat();

    @Property(selector="channelMap")
    @Marshaler(value=NSArray.AsIntegerListMarshaler.class)
    public native List<Integer> getChannelMap();

    @Property(selector="setChannelMap:")
    public native void setChannelMap(@Marshaler(value=NSArray.AsIntegerListMarshaler.class) List<Integer> var1);

    @Property(selector="magicCookie")
    public native NSData getMagicCookie();

    @Property(selector="setMagicCookie:")
    public native void setMagicCookie(NSData var1);

    @Property(selector="downmix")
    public native boolean isDownmix();

    @Property(selector="setDownmix:")
    public native void setDownmix(boolean var1);

    @Property(selector="dither")
    public native boolean isDither();

    @Property(selector="setDither:")
    public native void setDither(boolean var1);

    @Property(selector="sampleRateConverterQuality")
    public native AVAudioQuality getSampleRateConverterQuality();

    @Property(selector="setSampleRateConverterQuality:")
    public native void setSampleRateConverterQuality(AVAudioQuality var1);

    @Property(selector="sampleRateConverterAlgorithm")
    public native AVSampleRateConverterAlgorithm getSampleRateConverterAlgorithm();

    @Property(selector="setSampleRateConverterAlgorithm:")
    public native void setSampleRateConverterAlgorithm(AVSampleRateConverterAlgorithm var1);

    @Property(selector="primeMethod")
    public native AVAudioConverterPrimeMethod getPrimeMethod();

    @Property(selector="setPrimeMethod:")
    public native void setPrimeMethod(AVAudioConverterPrimeMethod var1);

    @Property(selector="primeInfo")
    @ByVal
    public native AVAudioConverterPrimeInfo getPrimeInfo();

    @Property(selector="setPrimeInfo:")
    public native void setPrimeInfo(@ByVal AVAudioConverterPrimeInfo var1);

    @Property(selector="bitRate")
    @MachineSizedSInt
    public native long getBitRate();

    @Property(selector="setBitRate:")
    public native void setBitRate(@MachineSizedSInt long var1);

    @Property(selector="bitRateStrategy")
    public native AVAudioBitRateStrategy getBitRateStrategy();

    @Property(selector="setBitRateStrategy:")
    public native void setBitRateStrategy(AVAudioBitRateStrategy var1);

    @Property(selector="maximumOutputPacketSize")
    @MachineSizedSInt
    public native long getMaximumOutputPacketSize();

    @Property(selector="availableEncodeBitRates")
    @Marshaler(value=NSArray.AsIntegerListMarshaler.class)
    public native List<Integer> getAvailableEncodeBitRates();

    @Property(selector="applicableEncodeBitRates")
    @Marshaler(value=NSArray.AsIntegerListMarshaler.class)
    public native List<Integer> getApplicableEncodeBitRates();

    @Property(selector="availableEncodeSampleRates")
    @Marshaler(value=NSArray.AsIntegerListMarshaler.class)
    public native List<Integer> getAvailableEncodeSampleRates();

    @Property(selector="applicableEncodeSampleRates")
    @Marshaler(value=NSArray.AsIntegerListMarshaler.class)
    public native List<Integer> getApplicableEncodeSampleRates();

    @Property(selector="availableEncodeChannelLayoutTags")
    @Marshaler(value=NSArray.AsIntegerListMarshaler.class)
    public native List<Integer> getAvailableEncodeChannelLayoutTags();

    public AVAudioConverterOutputStatus convert(AVAudioBuffer outputBuffer, Block2<Integer, MachineSizedSIntPtr, AVAudioBuffer> inputBlock) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        AVAudioConverterOutputStatus result = this.convert(outputBuffer, ptr, inputBlock);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="initFromFormat:toFormat:")
    @Pointer
    protected native long init(AVAudioFormat var1, AVAudioFormat var2);

    @Method(selector="reset")
    public native void reset();

    public boolean convert(AVAudioPCMBuffer outputBuffer, AVAudioPCMBuffer inputBuffer) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.convert(outputBuffer, inputBuffer, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="convertToBuffer:fromBuffer:error:")
    private native boolean convert(AVAudioPCMBuffer var1, AVAudioPCMBuffer var2, NSError.NSErrorPtr var3);

    @Method(selector="convertToBuffer:error:withInputFromBlock:")
    protected native AVAudioConverterOutputStatus convert(AVAudioBuffer var1, NSError.NSErrorPtr var2, @Block Block2<Integer, MachineSizedSIntPtr, AVAudioBuffer> var3);

    static {
        ObjCRuntime.bind(AVAudioConverter.class);
    }

    public static class AVAudioConverterPtr
    extends Ptr<AVAudioConverter, AVAudioConverterPtr> {
    }
}

