/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAudioSessionCategory;
import org.robovm.apple.avfoundation.AVAudioSessionCategoryOptions;
import org.robovm.apple.avfoundation.AVAudioSessionDataSourceDescription;
import org.robovm.apple.avfoundation.AVAudioSessionIOType;
import org.robovm.apple.avfoundation.AVAudioSessionInterruptionNotification;
import org.robovm.apple.avfoundation.AVAudioSessionMode;
import org.robovm.apple.avfoundation.AVAudioSessionPortDescription;
import org.robovm.apple.avfoundation.AVAudioSessionPortOverride;
import org.robovm.apple.avfoundation.AVAudioSessionPromptStyle;
import org.robovm.apple.avfoundation.AVAudioSessionRecordPermission;
import org.robovm.apple.avfoundation.AVAudioSessionRouteChangeNotification;
import org.robovm.apple.avfoundation.AVAudioSessionRouteDescription;
import org.robovm.apple.avfoundation.AVAudioSessionRouteSharingPolicy;
import org.robovm.apple.avfoundation.AVAudioSessionSetActiveOptions;
import org.robovm.apple.avfoundation.AVAudioSessionSilenceSecondaryAudioHintType;
import org.robovm.apple.avfoundation.AVAudioStereoOrientation;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioSession
extends NSObject {
    public AVAudioSession() {
    }

    protected AVAudioSession(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected AVAudioSession(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="availableCategories")
    @Marshaler(value=AVAudioSessionCategory.AsListMarshaler.class)
    public native List<AVAudioSessionCategory> getAvailableCategories();

    @Property(selector="category")
    public native AVAudioSessionCategory getCategory();

    @Property(selector="categoryOptions")
    public native AVAudioSessionCategoryOptions getCategoryOptions();

    @Property(selector="routeSharingPolicy")
    public native AVAudioSessionRouteSharingPolicy getRouteSharingPolicy();

    @Property(selector="availableModes")
    @Marshaler(value=AVAudioSessionMode.AsListMarshaler.class)
    public native List<AVAudioSessionMode> getAvailableModes();

    @Property(selector="mode")
    public native AVAudioSessionMode getMode();

    @Property(selector="allowHapticsAndSystemSoundsDuringRecording")
    public native boolean isAllowHapticsAndSystemSoundsDuringRecording();

    @Property(selector="recordPermission")
    public native AVAudioSessionRecordPermission getRecordPermission();

    @Property(selector="preferredInput")
    public native AVAudioSessionPortDescription getPreferredInput();

    @Property(selector="prefersNoInterruptionsFromSystemAlerts")
    public native boolean prefersNoInterruptionsFromSystemAlerts();

    @Property(selector="preferredSampleRate")
    public native double getPreferredSampleRate();

    @Property(selector="preferredIOBufferDuration")
    public native double getPreferredIOBufferDuration();

    @Property(selector="preferredInputNumberOfChannels")
    @MachineSizedSInt
    public native long getPreferredInputNumberOfChannels();

    @Property(selector="preferredOutputNumberOfChannels")
    @MachineSizedSInt
    public native long getPreferredOutputNumberOfChannels();

    @Property(selector="preferredInputOrientation")
    public native AVAudioStereoOrientation getPreferredInputOrientation();

    @Property(selector="inputOrientation")
    public native AVAudioStereoOrientation getInputOrientation();

    @Property(selector="maximumInputNumberOfChannels")
    @MachineSizedSInt
    public native long getMaximumInputNumberOfChannels();

    @Property(selector="maximumOutputNumberOfChannels")
    @MachineSizedSInt
    public native long getMaximumOutputNumberOfChannels();

    @Property(selector="inputGain")
    public native float getInputGain();

    @Property(selector="isInputGainSettable")
    public native boolean isInputGainSettable();

    @Property(selector="isInputAvailable")
    public native boolean isInputAvailable();

    @Property(selector="inputDataSources")
    public native NSArray<AVAudioSessionDataSourceDescription> getInputDataSources();

    @Property(selector="inputDataSource")
    public native AVAudioSessionDataSourceDescription getInputDataSource();

    @Property(selector="outputDataSources")
    public native NSArray<AVAudioSessionDataSourceDescription> getOutputDataSources();

    @Property(selector="outputDataSource")
    public native AVAudioSessionDataSourceDescription getOutputDataSource();

    @Property(selector="sampleRate")
    public native double getSampleRate();

    @Property(selector="inputNumberOfChannels")
    @MachineSizedSInt
    public native long getInputNumberOfChannels();

    @Property(selector="outputNumberOfChannels")
    @MachineSizedSInt
    public native long getOutputNumberOfChannels();

    @Property(selector="inputLatency")
    public native double getInputLatency();

    @Property(selector="outputLatency")
    public native double getOutputLatency();

    @Property(selector="IOBufferDuration")
    public native double getIOBufferDuration();

    @Property(selector="isOtherAudioPlaying")
    public native boolean isOtherAudioPlaying();

    @Property(selector="secondaryAudioShouldBeSilencedHint")
    public native boolean secondaryAudioShouldBeSilencedHint();

    @Property(selector="outputVolume")
    public native float getOutputVolume();

    @Property(selector="promptStyle")
    public native AVAudioSessionPromptStyle getPromptStyle();

    @Property(selector="availableInputs")
    public native NSArray<AVAudioSessionPortDescription> getAvailableInputs();

    @Property(selector="currentRoute")
    public native AVAudioSessionRouteDescription getCurrentRoute();

    @Property(selector="supportsMultichannelContent")
    public native boolean supportsMultichannelContent();

    @GlobalValue(symbol="AVAudioSessionInterruptionNotification", optional=true)
    public static native NSString InterruptionNotification();

    @GlobalValue(symbol="AVAudioSessionRouteChangeNotification", optional=true)
    public static native NSString RouteChangeNotification();

    @GlobalValue(symbol="AVAudioSessionMediaServicesWereLostNotification", optional=true)
    public static native NSString MediaServicesWereLostNotification();

    @GlobalValue(symbol="AVAudioSessionMediaServicesWereResetNotification", optional=true)
    public static native NSString MediaServicesWereResetNotification();

    @GlobalValue(symbol="AVAudioSessionSilenceSecondaryAudioHintNotification", optional=true)
    public static native NSString SilenceSecondaryAudioHintNotification();

    @GlobalValue(symbol="AVAudioSessionSpatialPlaybackCapabilitiesChangedNotification", optional=true)
    public static native NSString SpatialPlaybackCapabilitiesChangedNotification();

    @GlobalValue(symbol="AVAudioSessionSilenceSecondaryAudioHintTypeKey", optional=true)
    protected static native NSString SilenceSecondaryAudioHintTypeKey();

    public boolean setCategory(AVAudioSessionCategory category) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setCategory(category, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setCategory:error:")
    private native boolean setCategory(AVAudioSessionCategory var1, NSError.NSErrorPtr var2);

    public boolean setCategory(AVAudioSessionCategory category, AVAudioSessionCategoryOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setCategory(category, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setCategory:withOptions:error:")
    private native boolean setCategory(AVAudioSessionCategory var1, AVAudioSessionCategoryOptions var2, NSError.NSErrorPtr var3);

    public boolean setCategory(AVAudioSessionCategory category, String mode, AVAudioSessionCategoryOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setCategory(category, mode, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setCategory:mode:options:error:")
    private native boolean setCategory(AVAudioSessionCategory var1, String var2, AVAudioSessionCategoryOptions var3, NSError.NSErrorPtr var4);

    public boolean setCategory(AVAudioSessionCategory category, String mode, AVAudioSessionRouteSharingPolicy policy, AVAudioSessionCategoryOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setCategory(category, mode, policy, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setCategory:mode:routeSharingPolicy:options:error:")
    private native boolean setCategory(AVAudioSessionCategory var1, String var2, AVAudioSessionRouteSharingPolicy var3, AVAudioSessionCategoryOptions var4, NSError.NSErrorPtr var5);

    public boolean setMode(AVAudioSessionMode mode) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setMode(mode, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setMode:error:")
    private native boolean setMode(AVAudioSessionMode var1, NSError.NSErrorPtr var2);

    public boolean setAllowHapticsAndSystemSoundsDuringRecording(boolean inValue) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setAllowHapticsAndSystemSoundsDuringRecording(inValue, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setAllowHapticsAndSystemSoundsDuringRecording:error:")
    private native boolean setAllowHapticsAndSystemSoundsDuringRecording(boolean var1, NSError.NSErrorPtr var2);

    @Method(selector="requestRecordPermission:")
    public native void requestRecordPermission(@Block VoidBooleanBlock var1);

    public boolean overrideOutputAudioPort(AVAudioSessionPortOverride portOverride) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.overrideOutputAudioPort(portOverride, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="overrideOutputAudioPort:error:")
    private native boolean overrideOutputAudioPort(AVAudioSessionPortOverride var1, NSError.NSErrorPtr var2);

    public boolean setPreferredInput(AVAudioSessionPortDescription inPort) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPreferredInput(inPort, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPreferredInput:error:")
    private native boolean setPreferredInput(AVAudioSessionPortDescription var1, NSError.NSErrorPtr var2);

    public boolean setPrefersNoInterruptionsFromSystemAlerts(boolean inValue) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPrefersNoInterruptionsFromSystemAlerts(inValue, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPrefersNoInterruptionsFromSystemAlerts:error:")
    private native boolean setPrefersNoInterruptionsFromSystemAlerts(boolean var1, NSError.NSErrorPtr var2);

    @Method(selector="sharedInstance")
    public static native AVAudioSession getSharedInstance();

    public boolean setActive(boolean active) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setActive(active, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setActive:error:")
    private native boolean setActive(boolean var1, NSError.NSErrorPtr var2);

    public boolean setActive(boolean active, AVAudioSessionSetActiveOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setActive(active, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setActive:withOptions:error:")
    private native boolean setActive(boolean var1, AVAudioSessionSetActiveOptions var2, NSError.NSErrorPtr var3);

    public boolean setPreferredSampleRate(double sampleRate) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPreferredSampleRate(sampleRate, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPreferredSampleRate:error:")
    private native boolean setPreferredSampleRate(double var1, NSError.NSErrorPtr var3);

    public boolean setPreferredIOBufferDuration(double duration) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPreferredIOBufferDuration(duration, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPreferredIOBufferDuration:error:")
    private native boolean setPreferredIOBufferDuration(double var1, NSError.NSErrorPtr var3);

    public boolean setPreferredInputNumberOfChannels(@MachineSizedSInt long count) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPreferredInputNumberOfChannels(count, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPreferredInputNumberOfChannels:error:")
    private native boolean setPreferredInputNumberOfChannels(@MachineSizedSInt long var1, NSError.NSErrorPtr var3);

    public boolean setPreferredOutputNumberOfChannels(@MachineSizedSInt long count) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPreferredOutputNumberOfChannels(count, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPreferredOutputNumberOfChannels:error:")
    private native boolean setPreferredOutputNumberOfChannels(@MachineSizedSInt long var1, NSError.NSErrorPtr var3);

    public boolean setPreferredInputOrientation(AVAudioStereoOrientation orientation) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setPreferredInputOrientation(orientation, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setPreferredInputOrientation:error:")
    private native boolean setPreferredInputOrientation(AVAudioStereoOrientation var1, NSError.NSErrorPtr var2);

    public boolean setInputGain(float gain) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setInputGain(gain, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setInputGain:error:")
    private native boolean setInputGain(float var1, NSError.NSErrorPtr var2);

    public boolean setInputDataSource(AVAudioSessionDataSourceDescription dataSource) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setInputDataSource(dataSource, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setInputDataSource:error:")
    private native boolean setInputDataSource(AVAudioSessionDataSourceDescription var1, NSError.NSErrorPtr var2);

    public boolean setOutputDataSource(AVAudioSessionDataSourceDescription dataSource) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setOutputDataSource(dataSource, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setOutputDataSource:error:")
    private native boolean setOutputDataSource(AVAudioSessionDataSourceDescription var1, NSError.NSErrorPtr var2);

    public boolean setAggregatedIOPreference(AVAudioSessionIOType inIOType) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setAggregatedIOPreference(inIOType, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setAggregatedIOPreference:error:")
    private native boolean setAggregatedIOPreference(AVAudioSessionIOType var1, NSError.NSErrorPtr var2);

    public boolean setSupportsMultichannelContent(boolean inValue) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setSupportsMultichannelContent(inValue, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setSupportsMultichannelContent:error:")
    private native boolean setSupportsMultichannelContent(boolean var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(AVAudioSession.class);
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVAudioSessionSpatialAudioEnabledKey", optional=true)
        public static native NSString SpatialAudioEnabled();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AVAudioSessionPtr
    extends Ptr<AVAudioSession, AVAudioSessionPtr> {
    }

    public static class Notifications {
        public static NSObject observeInterruption(final VoidBlock1<AVAudioSessionInterruptionNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioSession.InterruptionNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> userInfo = a.getUserInfo();
                    AVAudioSessionInterruptionNotification data = null;
                    if (userInfo != null) {
                        data = new AVAudioSessionInterruptionNotification(userInfo);
                    }
                    block.invoke(data);
                }
            });
        }

        public static NSObject observeRouteChange(final VoidBlock1<AVAudioSessionRouteChangeNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioSession.RouteChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> userInfo = a.getUserInfo();
                    AVAudioSessionRouteChangeNotification data = null;
                    if (userInfo != null) {
                        data = new AVAudioSessionRouteChangeNotification(userInfo);
                    }
                    block.invoke(data);
                }
            });
        }

        public static NSObject observeMediaServicesWereLost(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioSession.MediaServicesWereLostNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeMediaServicesWereReset(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioSession.MediaServicesWereResetNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }

        public static NSObject observeSilenceSecondaryAudioHint(final VoidBlock1<AVAudioSessionSilenceSecondaryAudioHintType> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioSession.SilenceSecondaryAudioHintNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    NSDictionary<?, ?> userInfo = a.getUserInfo();
                    AVAudioSessionSilenceSecondaryAudioHintType type = null;
                    if (userInfo.containsKey(AVAudioSession.SilenceSecondaryAudioHintTypeKey())) {
                        NSNumber val = (NSNumber)userInfo.get(AVAudioSession.SilenceSecondaryAudioHintTypeKey());
                        type = AVAudioSessionSilenceSecondaryAudioHintType.valueOf(val.intValue());
                    }
                    block.invoke(type);
                }
            });
        }
    }
}

