/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.avfoundation.AVAssetReferenceRestrictions;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSDictionaryWrapper;
import org.robovm.apple.foundation.NSHTTPCookie;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class AVURLAssetOptions
extends NSDictionaryWrapper {
    AVURLAssetOptions(NSDictionary data) {
        super(data);
    }

    public AVURLAssetOptions() {
    }

    public boolean has(NSString key) {
        return this.data.containsKey(key);
    }

    public NSObject get(NSString key) {
        if (this.has(key)) {
            return this.data.get(key);
        }
        return null;
    }

    public AVURLAssetOptions set(NSString key, NSObject value) {
        this.data.put(key, value);
        return this;
    }

    public boolean prefersPreciseDurationAndTiming() {
        if (this.has(Keys.PreferPreciseDurationAndTiming())) {
            NSNumber val = (NSNumber)this.get(Keys.PreferPreciseDurationAndTiming());
            return val.booleanValue();
        }
        return false;
    }

    public AVURLAssetOptions setPrefersPreciseDurationAndTiming(boolean prefersPreciseDurationAndTiming) {
        this.set(Keys.PreferPreciseDurationAndTiming(), NSNumber.valueOf(prefersPreciseDurationAndTiming));
        return this;
    }

    public AVAssetReferenceRestrictions getReferenceRestrictions() {
        if (this.has(Keys.ReferenceRestrictions())) {
            NSNumber val = (NSNumber)this.get(Keys.ReferenceRestrictions());
            return new AVAssetReferenceRestrictions(val.longValue());
        }
        return null;
    }

    public AVURLAssetOptions setReferenceRestrictions(AVAssetReferenceRestrictions referenceRestrictions) {
        this.set(Keys.ReferenceRestrictions(), NSNumber.valueOf(referenceRestrictions.value()));
        return this;
    }

    public NSArray<NSHTTPCookie> getHTTPCookies() {
        if (this.has(Keys.HTTPCookies())) {
            NSArray val = (NSArray)this.get(Keys.HTTPCookies());
            return val;
        }
        return null;
    }

    public AVURLAssetOptions setHTTPCookies(NSArray<NSHTTPCookie> hTTPCookies) {
        this.set(Keys.HTTPCookies(), hTTPCookies);
        return this;
    }

    @Library(value="AVFoundation")
    public static class Keys {
        @GlobalValue(symbol="AVURLAssetPreferPreciseDurationAndTimingKey", optional=true)
        public static native NSString PreferPreciseDurationAndTiming();

        @GlobalValue(symbol="AVURLAssetReferenceRestrictionsKey", optional=true)
        public static native NSString ReferenceRestrictions();

        @GlobalValue(symbol="AVURLAssetHTTPCookiesKey", optional=true)
        public static native NSString HTTPCookies();

        @GlobalValue(symbol="AVURLAssetAllowsCellularAccessKey", optional=true)
        public static native NSString AllowsCellularAccess();

        @GlobalValue(symbol="AVURLAssetAllowsExpensiveNetworkAccessKey", optional=true)
        public static native NSString AllowsExpensiveNetworkAccess();

        @GlobalValue(symbol="AVURLAssetAllowsConstrainedNetworkAccessKey", optional=true)
        public static native NSString AllowsConstrainedNetworkAccess();

        @GlobalValue(symbol="AVURLAssetURLRequestAttributionKey", optional=true)
        public static native NSString URLRequestAttribution();

        @GlobalValue(symbol="AVURLAssetHTTPUserAgentKey", optional=true)
        public static native NSString HTTPUserAgent();

        @GlobalValue(symbol="AVURLAssetPrimarySessionIdentifierKey", optional=true)
        public static native NSString PrimarySessionIdentifier();

        static {
            Bro.bind(Keys.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVURLAssetOptions> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(NSArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVURLAssetOptions> list = new ArrayList<AVURLAssetOptions>();
            for (int i = 0; i < o.size(); ++i) {
                list.add(new AVURLAssetOptions((NSDictionary)o.get(i)));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVURLAssetOptions> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSDictionary> array = new NSMutableArray<NSDictionary>();
            for (AVURLAssetOptions i : l) {
                array.add(i.getDictionary());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVURLAssetOptions toObject(Class<AVURLAssetOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVURLAssetOptions(o);
        }

        @MarshalsPointer
        public static long toNative(AVURLAssetOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

