/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreservices;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.GlobalValueEnumeration;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CFNetwork")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@StronglyLinked
public class CFProxyType
extends GlobalValueEnumeration<CFString> {
    public static final CFProxyType None;
    public static final CFProxyType HTTP;
    public static final CFProxyType HTTPS;
    public static final CFProxyType SOCKS;
    public static final CFProxyType FTP;
    public static final CFProxyType AutoConfigurationURL;
    public static final CFProxyType AutoConfigurationJavaScript;
    private static CFProxyType[] values;

    CFProxyType(String getterName) {
        super(Values.class, getterName);
    }

    public static CFProxyType valueOf(CFString value) {
        for (CFProxyType v : values) {
            if (!((CFString)v.value()).equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + CFProxyType.class.getName());
    }

    static {
        Bro.bind(CFProxyType.class);
        None = new CFProxyType("None");
        HTTP = new CFProxyType("HTTP");
        HTTPS = new CFProxyType("HTTPS");
        SOCKS = new CFProxyType("SOCKS");
        FTP = new CFProxyType("FTP");
        AutoConfigurationURL = new CFProxyType("AutoConfigurationURL");
        AutoConfigurationJavaScript = new CFProxyType("AutoConfigurationJavaScript");
        values = new CFProxyType[]{None, HTTP, HTTPS, SOCKS, FTP, AutoConfigurationURL, AutoConfigurationJavaScript};
    }

    @Library(value="CFNetwork")
    @StronglyLinked
    public static class Values {
        @GlobalValue(symbol="kCFProxyTypeNone", optional=true)
        public static native CFString None();

        @GlobalValue(symbol="kCFProxyTypeHTTP", optional=true)
        public static native CFString HTTP();

        @GlobalValue(symbol="kCFProxyTypeHTTPS", optional=true)
        public static native CFString HTTPS();

        @GlobalValue(symbol="kCFProxyTypeSOCKS", optional=true)
        public static native CFString SOCKS();

        @GlobalValue(symbol="kCFProxyTypeFTP", optional=true)
        public static native CFString FTP();

        @GlobalValue(symbol="kCFProxyTypeAutoConfigurationURL", optional=true)
        public static native CFString AutoConfigurationURL();

        @GlobalValue(symbol="kCFProxyTypeAutoConfigurationJavaScript", optional=true)
        public static native CFString AutoConfigurationJavaScript();

        static {
            Bro.bind(Values.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFProxyType> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFProxyType> list = new ArrayList<CFProxyType>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(CFProxyType.valueOf(o.get(i, CFString.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFProxyType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFProxyType o : l) {
                ((CFArray)array).add((NativeObject)o.value());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFProxyType toObject(Class<CFProxyType> cls, long handle, long flags) {
            CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return CFProxyType.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(CFProxyType o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative((CFType)o.value(), flags);
        }
    }
}

