/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coretext;

import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coretext.CTLineBoundsOptions;
import org.robovm.apple.coretext.CTLineBreakMode;
import org.robovm.apple.coretext.CTParagraphStyleSetting;
import org.robovm.apple.coretext.CTParagraphStyleSettings;
import org.robovm.apple.coretext.CTParagraphStyleSpecifier;
import org.robovm.apple.coretext.CTTextAlignment;
import org.robovm.apple.coretext.CTTextTab;
import org.robovm.apple.coretext.CTWritingDirection;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.MachineSizedFloatPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreText")
public class CTParagraphStyle
extends CFType {
    protected CTParagraphStyle() {
    }

    public static CTParagraphStyle create(CTParagraphStyleSettings settings) {
        CTParagraphStyleSetting setting = null;
        int count = 0;
        if (settings != null) {
            setting = (CTParagraphStyleSetting)Struct.allocate(CTParagraphStyleSetting.class);
            count = settings.getSettings().size();
            setting.update(settings.getSettings().values().toArray(new CTParagraphStyleSetting[count]));
        }
        return CTParagraphStyle.create(setting, count);
    }

    public CTTextAlignment getAlignment() {
        BytePtr ptr = new BytePtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.Alignment, BytePtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return CTTextAlignment.valueOf(ptr.get());
    }

    public CTLineBreakMode getLineBreakMode() {
        BytePtr ptr = new BytePtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.LineBreakMode, BytePtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return CTLineBreakMode.valueOf(ptr.get());
    }

    public CTWritingDirection getBaseWritingDirection() {
        BytePtr ptr = new BytePtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.BaseWritingDirection, BytePtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return CTWritingDirection.valueOf(ptr.get());
    }

    public double getFirstLineHeadIndent() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.FirstLineHeadIndent, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getHeadIndent() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.HeadIndent, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getTailIndent() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.TailIndent, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getDefaultTabInterval() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.DefaultTabInterval, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getLineHeightMultiple() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.LineHeightMultiple, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getMaximumLineHeight() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.MaximumLineHeight, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getMinimumLineHeight() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.MinimumLineHeight, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getParagraphSpacing() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.ParagraphSpacing, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getParagraphSpacingBefore() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.ParagraphSpacingBefore, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getMaximumLineSpacing() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.MaximumLineSpacing, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getMinimumLineSpacing() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.MinimumLineSpacing, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public double getLineSpacingAdjustment() {
        MachineSizedFloatPtr ptr = new MachineSizedFloatPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.LineSpacingAdjustment, MachineSizedFloatPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ptr.get();
    }

    public List<CTTextTab> getTabStops() {
        CFArray.CFArrayPtr ptr = new CFArray.CFArrayPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.TabStops, CFArray.CFArrayPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return ((CFArray)ptr.get()).toList(CTTextTab.class);
    }

    public CTLineBoundsOptions getLineBoundsOptions() {
        LongPtr ptr = new LongPtr();
        this.getValueForSpecifier(CTParagraphStyleSpecifier.LineBoundsOptions, LongPtr.sizeOf(), (VoidPtr)ptr.as(VoidPtr.class));
        return new CTLineBoundsOptions(ptr.get());
    }

    @Bridge(symbol="CTParagraphStyleGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CTParagraphStyleCreate", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    protected static native CTParagraphStyle create(CTParagraphStyleSetting var0, @MachineSizedUInt long var1);

    @Bridge(symbol="CTParagraphStyleCreateCopy", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    public static native CTParagraphStyle createCopy(CTParagraphStyle var0);

    @Bridge(symbol="CTParagraphStyleGetValueForSpecifier", optional=true)
    protected native boolean getValueForSpecifier(CTParagraphStyleSpecifier var1, @MachineSizedUInt long var2, VoidPtr var4);

    static {
        Bro.bind(CTParagraphStyle.class);
    }

    public static class CTParagraphStylePtr
    extends Ptr<CTParagraphStyle, CTParagraphStylePtr> {
    }
}

