/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corevideo;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.corefoundation.CFAllocator;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corevideo.CVImageBuffer;
import org.robovm.apple.corevideo.CVPixelBufferAttributes;
import org.robovm.apple.corevideo.CVPixelBufferLockFlags;
import org.robovm.apple.corevideo.CVPixelFormatType;
import org.robovm.apple.corevideo.CVReturn;
import org.robovm.apple.iosurface.IOSurface;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.MachineSizedUIntPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="CoreVideo")
public class CVPixelBuffer
extends CVImageBuffer {
    private static AtomicLong refconId = new AtomicLong();
    private long localRefconId;
    private static LongMap<ReleaseBytesCallback> releaseBytesCallbacks = new LongMap();
    private static LongMap<ReleasePlanarBytesCallback> releasePlanarBytesCallbacks = new LongMap();
    private static final Method cbReleaseBytes;
    private static final Method cbReleasePlanarBytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReleaseBytes(long refcon, VoidPtr baseAddress) {
        ReleaseBytesCallback callback = null;
        LongMap<ReleaseBytesCallback> longMap = releaseBytesCallbacks;
        synchronized (longMap) {
            callback = (ReleaseBytesCallback)releaseBytesCallbacks.get(refcon);
        }
        callback.release(baseAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbReleasePlanarBytes(long refcon, VoidPtr dataPtr, @MachineSizedUInt long dataSize, @MachineSizedUInt long numberOfPlanes, VoidPtr planeAddresses) {
        ReleasePlanarBytesCallback callback = null;
        LongMap<ReleasePlanarBytesCallback> longMap = releasePlanarBytesCallbacks;
        synchronized (longMap) {
            callback = (ReleasePlanarBytesCallback)releasePlanarBytesCallbacks.get(refcon);
        }
        callback.release(dataPtr, dataSize, numberOfPlanes, planeAddresses);
    }

    public static CVPixelBufferAttributes createResolvedAttributesDictionary(List<CVPixelBufferAttributes> attributes) {
        return CVPixelBuffer.createResolvedAttributesDictionary(null, attributes);
    }

    public static CVPixelBufferAttributes createResolvedAttributesDictionary(CFAllocator allocator, List<CVPixelBufferAttributes> attributes) {
        CFDictionary.CFDictionaryPtr ptr = new CFDictionary.CFDictionaryPtr();
        CVPixelBuffer.createResolvedAttributesDictionary(allocator, attributes, ptr);
        return new CVPixelBufferAttributes((CFDictionary)ptr.get());
    }

    public static CVPixelBuffer create(long width, long height, CVPixelFormatType pixelFormatType, CVPixelBufferAttributes pixelBufferAttributes) {
        return CVPixelBuffer.create(null, width, height, pixelFormatType, pixelBufferAttributes);
    }

    public static CVPixelBuffer create(CFAllocator allocator, long width, long height, CVPixelFormatType pixelFormatType, CVPixelBufferAttributes pixelBufferAttributes) {
        long refconId = CVPixelBuffer.refconId.getAndIncrement();
        CVPixelBufferPtr ptr = new CVPixelBufferPtr();
        CVReturn err = CVPixelBuffer.create(allocator, width, height, pixelFormatType, pixelBufferAttributes, ptr);
        if (err == CVReturn.Success) {
            CVPixelBuffer buffer = (CVPixelBuffer)ptr.get();
            buffer.localRefconId = refconId;
            return buffer;
        }
        return null;
    }

    public static CVPixelBuffer create(long width, long height, CVPixelFormatType pixelFormatType, VoidPtr baseAddress, long bytesPerRow, ReleaseBytesCallback releaseCallback, CVPixelBufferAttributes pixelBufferAttributes) {
        return CVPixelBuffer.create(null, width, height, pixelFormatType, baseAddress, bytesPerRow, releaseCallback, pixelBufferAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CVPixelBuffer create(CFAllocator allocator, long width, long height, CVPixelFormatType pixelFormatType, VoidPtr baseAddress, long bytesPerRow, ReleaseBytesCallback releaseCallback, CVPixelBufferAttributes pixelBufferAttributes) {
        CVPixelBufferPtr ptr;
        long refconId = CVPixelBuffer.refconId.getAndIncrement();
        CVReturn err = CVPixelBuffer.create(allocator, width, height, pixelFormatType, baseAddress, bytesPerRow, new FunctionPtr(cbReleaseBytes), refconId, pixelBufferAttributes, ptr = new CVPixelBufferPtr());
        if (err == CVReturn.Success) {
            CVPixelBuffer buffer = (CVPixelBuffer)ptr.get();
            buffer.localRefconId = refconId;
            LongMap<ReleaseBytesCallback> longMap = releaseBytesCallbacks;
            synchronized (longMap) {
                releaseBytesCallbacks.put(refconId, (Object)releaseCallback);
            }
            return buffer;
        }
        return null;
    }

    public long[] getExtendedPixels() {
        MachineSizedUIntPtr left = new MachineSizedUIntPtr();
        MachineSizedUIntPtr right = new MachineSizedUIntPtr();
        MachineSizedUIntPtr top = new MachineSizedUIntPtr();
        MachineSizedUIntPtr bottom = new MachineSizedUIntPtr();
        this.getExtendedPixels(left, right, top, bottom);
        return new long[]{left.get(), right.get(), top.get(), bottom.get()};
    }

    @Bridge(symbol="CVPixelBufferGetTypeID", optional=true)
    @MachineSizedUInt
    public static native long getClassTypeID();

    @Bridge(symbol="CVPixelBufferCreateResolvedAttributesDictionary", optional=true)
    private static native CVReturn createResolvedAttributesDictionary(CFAllocator var0, @Marshaler(value=CVPixelBufferAttributes.AsListMarshaler.class) List<CVPixelBufferAttributes> var1, CFDictionary.CFDictionaryPtr var2);

    @Bridge(symbol="CVPixelBufferCreate", optional=true)
    protected static native CVReturn create(CFAllocator var0, @MachineSizedUInt long var1, @MachineSizedUInt long var3, CVPixelFormatType var5, CVPixelBufferAttributes var6, CVPixelBufferPtr var7);

    @Bridge(symbol="CVPixelBufferCreateWithBytes", optional=true)
    protected static native CVReturn create(CFAllocator var0, @MachineSizedUInt long var1, @MachineSizedUInt long var3, CVPixelFormatType var5, VoidPtr var6, @MachineSizedUInt long var7, FunctionPtr var9, @Pointer long var10, CVPixelBufferAttributes var12, CVPixelBufferPtr var13);

    @Bridge(symbol="CVPixelBufferCreateWithPlanarBytes", optional=true)
    protected static native CVReturn create(CFAllocator var0, @MachineSizedUInt long var1, @MachineSizedUInt long var3, CVPixelFormatType var5, VoidPtr var6, @MachineSizedUInt long var7, @MachineSizedUInt long var9, VoidPtr.VoidPtrPtr var11, MachineSizedUIntPtr var12, MachineSizedUIntPtr var13, MachineSizedUIntPtr var14, FunctionPtr var15, VoidPtr var16, CVPixelBufferAttributes var17, CVPixelBufferPtr var18);

    @Bridge(symbol="CVPixelBufferLockBaseAddress", optional=true)
    public native CVReturn lockBaseAddress(CVPixelBufferLockFlags var1);

    @Bridge(symbol="CVPixelBufferUnlockBaseAddress", optional=true)
    public native CVReturn unlockBaseAddress(CVPixelBufferLockFlags var1);

    @Bridge(symbol="CVPixelBufferGetWidth", optional=true)
    @MachineSizedUInt
    public native long getWidth();

    @Bridge(symbol="CVPixelBufferGetHeight", optional=true)
    @MachineSizedUInt
    public native long getHeight();

    @Bridge(symbol="CVPixelBufferGetPixelFormatType", optional=true)
    public native CVPixelFormatType getPixelFormatType();

    @Bridge(symbol="CVPixelBufferGetBaseAddress", optional=true)
    public native VoidPtr getBaseAddress();

    @Bridge(symbol="CVPixelBufferGetBytesPerRow", optional=true)
    @MachineSizedUInt
    public native long getBytesPerRow();

    @Bridge(symbol="CVPixelBufferGetDataSize", optional=true)
    @MachineSizedUInt
    public native long getDataSize();

    @Bridge(symbol="CVPixelBufferIsPlanar", optional=true)
    public native boolean isPlanar();

    @Bridge(symbol="CVPixelBufferGetPlaneCount", optional=true)
    @MachineSizedUInt
    public native long getPlaneCount();

    @Bridge(symbol="CVPixelBufferGetWidthOfPlane", optional=true)
    @MachineSizedUInt
    public native long getWidthOfPlane(@MachineSizedUInt long var1);

    @Bridge(symbol="CVPixelBufferGetHeightOfPlane", optional=true)
    @MachineSizedUInt
    public native long getHeightOfPlane(@MachineSizedUInt long var1);

    @Bridge(symbol="CVPixelBufferGetBaseAddressOfPlane", optional=true)
    public native VoidPtr getBaseAddressOfPlane(@MachineSizedUInt long var1);

    @Bridge(symbol="CVPixelBufferGetBytesPerRowOfPlane", optional=true)
    @MachineSizedUInt
    public native long getBytesPerRowOfPlane(@MachineSizedUInt long var1);

    @Bridge(symbol="CVPixelBufferGetExtendedPixels", optional=true)
    protected native void getExtendedPixels(MachineSizedUIntPtr var1, MachineSizedUIntPtr var2, MachineSizedUIntPtr var3, MachineSizedUIntPtr var4);

    @Bridge(symbol="CVPixelBufferFillExtendedPixels", optional=true)
    public native CVReturn fillExtendedPixels();

    @Bridge(symbol="CVPixelBufferCopyCreationAttributes", optional=true)
    public native CFDictionary copyCreationAttributes();

    @Bridge(symbol="CVPixelBufferGetIOSurface", optional=true)
    public native IOSurface getIOSurface();

    @Bridge(symbol="CVPixelBufferCreateWithIOSurface", optional=true)
    protected static native CVReturn create(CFAllocator var0, IOSurface var1, CVPixelBufferAttributes var2, CVPixelBufferPtr var3);

    static {
        try {
            cbReleaseBytes = CVPixelBuffer.class.getDeclaredMethod("cbReleaseBytes", Long.TYPE, VoidPtr.class);
            cbReleasePlanarBytes = CVPixelBuffer.class.getDeclaredMethod("cbReleasePlanarBytes", Long.TYPE, VoidPtr.class, Long.TYPE, Long.TYPE, VoidPtr.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(CVPixelBuffer.class);
    }

    public static interface ReleaseBytesCallback {
        public void release(VoidPtr var1);
    }

    public static interface ReleasePlanarBytesCallback {
        public void release(VoidPtr var1, @MachineSizedUInt long var2, @MachineSizedUInt long var4, VoidPtr var6);
    }

    public static class CVPixelBufferPtr
    extends Ptr<CVPixelBuffer, CVPixelBufferPtr> {
    }
}

