/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.devicediscoveryextension;

import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.annotation.StronglyLinked;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.ValuedEnum;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;

@Marshaler(value=ValuedEnum.AsMachineSizedSIntMarshaler.class)
@Library(value="DeviceDiscoveryExtension")
public enum DDErrorCode implements NSErrorCode
{
    Success(0L),
    Unknown(350000L),
    BadParameter(350001L),
    Unsupported(350002L),
    Timeout(350003L),
    Internal(350004L),
    MissingEntitlement(350005L),
    Permission(350006L),
    Next(350007L);

    private final long n;

    @GlobalValue(symbol="DDErrorDomain", optional=true)
    public static native String getClassDomain();

    private DDErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static DDErrorCode valueOf(long n) {
        for (DDErrorCode v : DDErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + DDErrorCode.class.getName());
    }

    static {
        Bro.bind(DDErrorCode.class);
        Bro.bind(NSErrorWrap.class);
    }

    @StronglyLinked
    public static class NSErrorWrap
    extends NSError {
        protected NSErrorWrap(NSObject.SkipInit skipInit) {
            super(skipInit);
        }

        @Override
        public NSErrorCode getErrorCode() {
            try {
                return DDErrorCode.valueOf(this.getCode());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static String getClassDomain() {
            return DDErrorCode.getClassDomain();
        }
    }
}

