/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSIndexSet;
import org.robovm.apple.foundation.NSKeyValueChange;
import org.robovm.apple.foundation.NSKeyValueChangeInfo;
import org.robovm.apple.foundation.NSKeyValueCoder;
import org.robovm.apple.foundation.NSKeyValueObservingOptions;
import org.robovm.apple.foundation.NSKeyValueSetMutationKind;
import org.robovm.apple.foundation.NSObjectProtocol;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSThread;
import org.robovm.objc.ObjCClass;
import org.robovm.objc.ObjCObject;
import org.robovm.objc.ObjCProtocol;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshalers;
import org.robovm.rt.bro.annotation.MarshalsPointer;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="Foundation")
@NativeClass
@Marshalers(value={@org.robovm.rt.bro.annotation.Marshaler(value=NSString.AsStringMarshaler.class), @org.robovm.rt.bro.annotation.Marshaler(value=NSArray.AsListMarshaler.class), @org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)})
public class NSObject
extends ObjCObject
implements NSObjectProtocol {
    public static final int FLAG_NO_RETAIN = 1;
    private boolean forceSkipInit;
    private NSKeyValueCoder keyValueCoder;
    private static final Selector alloc;
    private static final Selector retain;
    private static final Selector release;
    private static final Selector autorelease;
    private Set<KeyValueObserverWrapper> keyValueObservers;

    @Method(selector="init")
    public NSObject() {
        if (!this.forceSkipInit) {
            this.initObject(this.init());
        }
    }

    @Deprecated
    protected NSObject(long handle) {
        super(handle);
    }

    protected NSObject(Handle h, long handle) {
        super(handle);
    }

    protected NSObject(SkipInit skipInit) {
    }

    @Property(selector="classForCoder")
    public native Class<? extends NSObject> getClassForCoder();

    @Property(selector="autoContentAccessingProxy")
    public native NSObject getAutoContentAccessingProxy();

    @Property(selector="observationInfo")
    public native VoidPtr getObservationInfo();

    @Property(selector="setObservationInfo:")
    public native void setObservationInfo(VoidPtr var1);

    @Property(selector="classForKeyedArchiver")
    public native Class<? extends NSObject> getClassForKeyedArchiver();

    protected void forceSkipInit() {
        this.forceSkipInit = true;
    }

    protected void afterMarshaled(int flags) {
        super.afterMarshaled(flags);
        if ((flags & 1) == 0) {
            NSObject.retain(this.getHandle());
        }
    }

    protected long alloc() {
        long h = this.getHandle();
        if (h == 0L) {
            h = NSObject.alloc(this.getObjCClass());
        }
        return h;
    }

    static long alloc(ObjCClass c) {
        long h = ObjCRuntime.ptr_objc_msgSend((long)c.getHandle(), (long)alloc.getHandle());
        if (h == 0L) {
            throw new OutOfMemoryError();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NSObject)) {
            return false;
        }
        return this.isEqual((NSObject)obj);
    }

    public int hashCode() {
        long h = this.hash();
        return (int)(h ^ h >>> 32);
    }

    protected void doDispose() {
        super.doDispose();
        long handle = this.getHandle();
        if (handle != 0L) {
            NSObject.release(handle);
        }
    }

    public String toString() {
        return this.description();
    }

    protected static void retain(long handle) {
        ObjCRuntime.void_objc_msgSend((long)handle, (long)retain.getHandle());
    }

    protected static void release(long handle) {
        ObjCRuntime.void_objc_msgSend((long)handle, (long)release.getHandle());
    }

    protected static void autorelease(long handle) {
        ObjCRuntime.void_objc_msgSend((long)handle, (long)autorelease.getHandle());
    }

    @Method(selector="performSelector:")
    public final native NSObject performSelector(Selector var1);

    @Method(selector="performSelector:withObject:")
    public final native NSObject performSelector(Selector var1, NSObject var2);

    @Method(selector="performSelector:withObject:withObject:")
    public final native NSObject performSelector(Selector var1, NSObject var2, NSObject var3);

    @Method(selector="isEqual:")
    public native boolean isEqual(NSObject var1);

    @Method(selector="hash")
    @MachineSizedUInt
    public native long hash();

    @Method(selector="isKindOfClass:")
    public native boolean isKindOfClass(ObjCClass var1);

    @Method(selector="isMemberOfClass:")
    public native boolean isMemberOfClass(ObjCClass var1);

    @Method(selector="conformsToProtocol:")
    public native boolean conformsToProtocol(ObjCProtocol var1);

    @Method(selector="respondsToSelector:")
    public native boolean respondsToSelector(Selector var1);

    @Method(selector="init")
    @Pointer
    protected native long init();

    @Method(selector="retain")
    public final native NSObject retain();

    @Method(selector="release")
    public final native void release();

    @Method(selector="autorelease")
    public native NSObject autorelease();

    @Method(selector="retainCount")
    @MachineSizedUInt
    public native long retainCount();

    @Method(selector="description")
    public native String description();

    @Method(selector="performSelector:")
    public final native void performSelectorV(Selector var1);

    @Method(selector="performSelector:withObject:")
    public final native void performSelectorV(Selector var1, NSObject var2);

    @Method(selector="performSelector:withObject:withObject:")
    public final native void performSelectorV(Selector var1, NSObject var2, NSObject var3);

    public void addKeyValueObserver(String keyPath, NSKeyValueObserver observer) {
        this.addKeyValueObserver(keyPath, observer, NSKeyValueObservingOptions.None);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyValueObserver(String keyPath, NSKeyValueObserver observer, NSKeyValueObservingOptions options) {
        if (keyPath == null) {
            throw new NullPointerException("keyPath");
        }
        if (observer == null) {
            throw new NullPointerException("observer");
        }
        if (this.keyValueObservers == null) {
            this.keyValueObservers = new HashSet<KeyValueObserverWrapper>();
        }
        KeyValueObserverWrapper wrapper = null;
        Set<KeyValueObserverWrapper> set = this.keyValueObservers;
        synchronized (set) {
            for (KeyValueObserverWrapper w : this.keyValueObservers) {
                if (w.observer != observer) continue;
                wrapper = w;
                break;
            }
            if (wrapper != null) {
                wrapper.keyPaths.add(keyPath);
            } else {
                wrapper = new KeyValueObserverWrapper(observer, keyPath);
                this.addStrongRef(wrapper);
                this.keyValueObservers.add(wrapper);
            }
        }
        this.addObserver(wrapper, keyPath, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyValueObservers(String keyPath) {
        if (keyPath == null) {
            throw new NullPointerException("keyPath");
        }
        if (this.keyValueObservers == null) {
            return;
        }
        Set<KeyValueObserverWrapper> set = this.keyValueObservers;
        synchronized (set) {
            Iterator<KeyValueObserverWrapper> i = this.keyValueObservers.iterator();
            while (i.hasNext()) {
                KeyValueObserverWrapper wrapper = i.next();
                if (!wrapper.keyPaths.remove(keyPath)) continue;
                this.removeObserver(wrapper, keyPath, null);
                if (wrapper.keyPaths.size() != 0) continue;
                i.remove();
                this.removeStrongRef(wrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeyValueObserver(String keyPath, NSKeyValueObserver observer) {
        if (keyPath == null) {
            throw new NullPointerException("keyPath");
        }
        if (observer == null) {
            throw new NullPointerException("observer");
        }
        if (this.keyValueObservers == null) {
            return;
        }
        KeyValueObserverWrapper wrapper = null;
        Set<KeyValueObserverWrapper> set = this.keyValueObservers;
        synchronized (set) {
            for (KeyValueObserverWrapper w : this.keyValueObservers) {
                if (w.observer != observer) continue;
                wrapper = w;
                break;
            }
            if (wrapper != null && wrapper.keyPaths.remove(keyPath)) {
                this.removeObserver(wrapper, keyPath, null);
                if (wrapper.keyPaths.size() == 0) {
                    this.keyValueObservers.remove(wrapper);
                    this.removeStrongRef(wrapper);
                }
            }
        }
    }

    public NSKeyValueCoder getKeyValueCoder() {
        if (this.keyValueCoder == null) {
            this.keyValueCoder = new NSKeyValueCoder(this);
        }
        return this.keyValueCoder;
    }

    public void willChangeValues(String key, NSKeyValueChange changeKind, NSIndexSet indexes) {
        this.willChangeValues(changeKind, indexes, key);
    }

    public void didChangeValues(String key, NSKeyValueChange changeKind, NSIndexSet indexes) {
        this.didChangeValues(changeKind, indexes, key);
    }

    @Method(selector="awakeFromNib")
    public native void awakeFromNib();

    @Method(selector="copy")
    public native NSObject copy();

    @Method(selector="mutableCopy")
    public native NSObject mutableCopy();

    @Method(selector="performSelector:withObject:afterDelay:inModes:")
    public final native void performSelector(Selector var1, NSObject var2, double var3, NSArray<NSString> var5);

    @Method(selector="performSelector:withObject:afterDelay:")
    public final native void performSelector(Selector var1, NSObject var2, double var3);

    @Method(selector="addObserver:forKeyPath:options:context:")
    private native void addObserver(NSObject var1, String var2, NSKeyValueObservingOptions var3, VoidPtr var4);

    @Method(selector="removeObserver:forKeyPath:context:")
    private native void removeObserver(NSObject var1, String var2, VoidPtr var3);

    @Method(selector="willChangeValueForKey:")
    public native void willChangeValue(String var1);

    @Method(selector="didChangeValueForKey:")
    public native void didChangeValue(String var1);

    @Method(selector="willChange:valuesAtIndexes:forKey:")
    private native void willChangeValues(NSKeyValueChange var1, NSIndexSet var2, String var3);

    @Method(selector="didChange:valuesAtIndexes:forKey:")
    private native void didChangeValues(NSKeyValueChange var1, NSIndexSet var2, String var3);

    @Method(selector="willChangeValueForKey:withSetMutation:usingObjects:")
    public native void willChangeValue(String var1, NSKeyValueSetMutationKind var2, NSSet<?> var3);

    @Method(selector="didChangeValueForKey:withSetMutation:usingObjects:")
    public native void didChangeValue(String var1, NSKeyValueSetMutationKind var2, NSSet<?> var3);

    @Method(selector="performSelectorOnMainThread:withObject:waitUntilDone:modes:")
    public final native void performSelectorOnMainThread(Selector var1, NSObject var2, boolean var3, NSArray<NSString> var4);

    @Method(selector="performSelectorOnMainThread:withObject:waitUntilDone:")
    public final native void performSelectorOnMainThread(Selector var1, NSObject var2, boolean var3);

    @Method(selector="performSelector:onThread:withObject:waitUntilDone:modes:")
    public final native void performSelector(Selector var1, NSThread var2, NSObject var3, boolean var4, NSArray<NSString> var5);

    @Method(selector="performSelector:onThread:withObject:waitUntilDone:")
    public final native void performSelector(Selector var1, NSThread var2, NSObject var3, boolean var4);

    @Method(selector="performSelectorInBackground:withObject:")
    public final native void performSelectorInBackground(Selector var1, NSObject var2);

    static {
        ObjCRuntime.bind(NSObject.class);
        alloc = Selector.register((String)"alloc");
        retain = Selector.register((String)"retain");
        release = Selector.register((String)"release");
        autorelease = Selector.register((String)"autorelease");
    }

    public static interface NSKeyValueObserver {
        public void observeValue(String var1, NSObject var2, NSKeyValueChangeInfo var3);
    }

    private class KeyValueObserverWrapper
    extends NSObject {
        private NSKeyValueObserver observer;
        private Set<String> keyPaths = new HashSet<String>();

        private KeyValueObserverWrapper(NSKeyValueObserver observer, String keyPath) {
            this.observer = observer;
            this.keyPaths.add(keyPath);
        }

        @Method(selector="observeValueForKeyPath:ofObject:change:context:")
        private void observeValueForKeyPath(String keyPath, NSObject object, NSKeyValueChangeInfo change, VoidPtr context) {
            this.observer.observeValue(keyPath, object, change);
        }
    }

    public static class NoRetainMarshaler {
        @MarshalsPointer
        public static NSObject toObject(Class<? extends NSObject> cls, long handle, long flags) {
            return Marshaler.toObject(cls, handle, flags, false);
        }

        @MarshalsPointer
        public static long toNative(NSObject o, long flags) {
            return Marshaler.toNative(o, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSObject toObject(Class<? extends NSObject> cls, long handle, long flags) {
            return Marshaler.toObject(cls, handle, flags, true);
        }

        static NSObject toObject(Class<? extends NSObject> cls, long handle, long flags, boolean retain) {
            NSObject o = (NSObject)ObjCObject.toObjCObject(cls, (long)handle, (int)(retain ? 0 : 1));
            return o;
        }

        @MarshalsPointer
        public static long toNative(NSObject o, long flags) {
            if (o == null) {
                return 0L;
            }
            long handle = o.getHandle();
            if ((flags & 3L) > 0L) {
                NSObject.retain(handle);
                if ((flags & 1L) > 0L) {
                    NSObject.autorelease(handle);
                }
            }
            return handle;
        }

        @MarshalsPointer
        public static long toNative(NSObjectProtocol o, long flags) {
            return Marshaler.toNative((NSObject)o, flags);
        }
    }

    public static class NSObjectPtr
    extends Ptr<NSObject, NSObjectPtr> {
    }

    protected static class Handle {
        private Handle() {
        }
    }

    protected static class SkipInit {
        private SkipInit() {
        }
    }
}

