/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.foundation;

import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSActivityOptions;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperatingSystem;
import org.robovm.apple.foundation.NSOperatingSystemVersion;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSProcessInfoThermalState;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBooleanBlock;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="Foundation")
@NativeClass
public class NSProcessInfo
extends NSObject {
    protected NSProcessInfo(NSObject.Handle h, long handle) {
        super(h, handle);
    }

    protected NSProcessInfo(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="processInfo")
    public static native NSProcessInfo getSharedProcessInfo();

    @Property(selector="environment")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSObject> getEnvironment();

    @Property(selector="arguments")
    @Marshaler(value=NSArray.AsStringListMarshaler.class)
    public native List<String> getArguments();

    @Property(selector="hostName")
    public native String getHostName();

    @Property(selector="processName")
    public native String getProcessName();

    @Property(selector="setProcessName:")
    public native void setProcessName(String var1);

    @Property(selector="processIdentifier")
    public native int getProcessIdentifier();

    @Property(selector="globallyUniqueString")
    public native String getGloballyUniqueString();

    @Property(selector="operatingSystemVersionString")
    public native String getOperatingSystemVersionString();

    @Property(selector="operatingSystemVersion")
    @ByVal
    public native NSOperatingSystemVersion getOperatingSystemVersion();

    @Property(selector="processorCount")
    @MachineSizedUInt
    public native long getProcessorCount();

    @Property(selector="activeProcessorCount")
    @MachineSizedUInt
    public native long getActiveProcessorCount();

    @Property(selector="physicalMemory")
    public native long getPhysicalMemory();

    @Property(selector="systemUptime")
    public native double getSystemUptime();

    @Property(selector="thermalState")
    public native NSProcessInfoThermalState getThermalState();

    @Property(selector="isLowPowerModeEnabled")
    public native boolean isLowPowerModeEnabled();

    @Property(selector="isMacCatalystApp")
    public native boolean isMacCatalystApp();

    @Property(selector="isiOSAppOnMac")
    public native boolean isIOSAppOnMac();

    @GlobalValue(symbol="NSProcessInfoThermalStateDidChangeNotification", optional=true)
    public static native NSString ThermalStateDidChangeNotification();

    @GlobalValue(symbol="NSProcessInfoPowerStateDidChangeNotification", optional=true)
    public static native NSString PowerStateDidChangeNotification();

    @Deprecated
    @Method(selector="operatingSystem")
    public native NSOperatingSystem getOperatingSystem();

    @Deprecated
    @Method(selector="operatingSystemName")
    public native String getOperatingSystemName();

    @Method(selector="isOperatingSystemAtLeastVersion:")
    public native boolean isOperatingSystemAtLeastVersion(@ByVal NSOperatingSystemVersion var1);

    @Method(selector="beginActivityWithOptions:reason:")
    public native NSObject beginActivity(NSActivityOptions var1, String var2);

    @Method(selector="endActivity:")
    public native void endActivity(NSObject var1);

    @Method(selector="performActivityWithOptions:reason:usingBlock:")
    public native void performActivity(NSActivityOptions var1, String var2, @Block Runnable var3);

    @Method(selector="performExpiringActivityWithReason:usingBlock:")
    public native void performExpiringActivity(String var1, @Block VoidBooleanBlock var2);

    static {
        ObjCRuntime.bind(NSProcessInfo.class);
    }

    public static class NSProcessInfoPtr
    extends Ptr<NSProcessInfo, NSProcessInfoPtr> {
    }

    public static class Notifications {
        public static NSObject observePowerStateDidChange(final Runnable block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSProcessInfo.PowerStateDidChangeNotification(), null, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.run();
                }
            });
        }
    }
}

